/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy;

import com.fizzgate.plugin.PluginConfig;
import com.fizzgate.util.JacksonUtils;
import java.util.List;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;

public class Route {
    public boolean dedicatedLine = false;
    public byte type;
    public HttpMethod method;
    public String path;
    public String registryCenter;
    public String backendService;
    public String backendPath;
    @Deprecated
    public String query;
    public String nextHttpHostPort;
    public List<PluginConfig> pluginConfigs;
    public boolean pluginConfigsChange = false;
    public String rpcMethod;
    public String rpcParamTypes;
    public String rpcVersion;
    public String rpcGroup;
    public long timeout = 0L;
    public int retryCount = 0;
    public long retryInterval = 0L;
    public MediaType contentType;
    public String body;

    public Route dedicatedLine(boolean b) {
        this.dedicatedLine = b;
        return this;
    }

    public Route type(int t) {
        this.type = (byte)t;
        return this;
    }

    public Route method(HttpMethod m) {
        this.method = m;
        return this;
    }

    public Route path(String p) {
        this.path = p;
        return this;
    }

    public Route registryCenter(String rc) {
        this.registryCenter = rc;
        return this;
    }

    public Route backendService(String bs) {
        this.backendService = bs;
        return this;
    }

    public Route backendPath(String bp) {
        this.backendPath = bp;
        return this;
    }

    @Deprecated
    public Route query(String qry) {
        this.query = qry;
        return this;
    }

    public Route pluginConfigs(List<PluginConfig> pcs) {
        this.pluginConfigs = pcs;
        this.pluginConfigsChange = true;
        return this;
    }

    public Route nextHttpHostPort(String nhhp) {
        this.nextHttpHostPort = nhhp;
        return this;
    }

    public Route rpcMethod(String m) {
        this.rpcMethod = m;
        return this;
    }

    public Route rpcParamTypes(String t) {
        this.rpcParamTypes = t;
        return this;
    }

    public Route rpcVersion(String v) {
        this.rpcVersion = v;
        return this;
    }

    public Route rpcGroup(String g) {
        this.rpcGroup = g;
        return this;
    }

    public Route timeout(long t) {
        this.timeout = t;
        return this;
    }

    public Route retryCount(int rc) {
        this.retryCount = rc;
        return this;
    }

    public Route retryInterval(long ri) {
        this.retryInterval = ri;
        return this;
    }

    public Route contentType(MediaType type) {
        this.contentType = type;
        return this;
    }

    public Route body(String b) {
        this.body = b;
        return this;
    }

    @Deprecated
    public String getBackendPathQuery() {
        if (this.query != null) {
            return this.backendPath + '?' + this.query;
        }
        return this.backendPath;
    }

    public String toString() {
        return JacksonUtils.writeValueAsString((Object)this);
    }
}

