/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy;

import com.fizzgate.proxy.RpcInstanceService;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.ReactorUtils;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class RpcInstanceServiceImpl
implements RpcInstanceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcInstanceServiceImpl.class);
    private static final String RPC_SERVICE_CHANNEL = "fizz_rpc_service_channel";
    private static final String RPC_SERVICE_HASH_KEY = "fizz_rpc_service";
    private static final String SERVICE_KEY_PATTERN = "%s-%s";
    private static final Byte LOAD_BALANCE_TYPE_ROUND_ROBIN = 1;
    private static final Byte LOAD_BALANCE_TYPE_RANDOM = 2;
    private static Map<String, List<String>> serviceToInstancesMap = new ConcurrentHashMap<String, List<String>>(32);
    private static Map<String, Byte> serviceToLoadBalanceTypeMap = new ConcurrentHashMap<String, Byte>(32);
    private static Map<Long, RpcService> idToRpcServiceMap = new ConcurrentHashMap<Long, RpcService>(32);
    private static Map<String, AtomicLong> serviceToCountMap = new ConcurrentHashMap<String, AtomicLong>(32);
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate redisTemplate;

    @PostConstruct
    public void init() throws Throwable {
        this.init(this::lsnRpcServiceChange);
    }

    @Override
    public void refreshLocalCache() throws Throwable {
        this.init(null);
    }

    private void init(Supplier<Mono<Throwable>> doAfterLoadCache) throws Throwable {
        ConcurrentHashMap<String, List<String>> serviceToInstancesMapTmp = new ConcurrentHashMap<String, List<String>>(32);
        ConcurrentHashMap<String, Byte> serviceToLoadBalanceTypeMapTmp = new ConcurrentHashMap<String, Byte>(32);
        ConcurrentHashMap<Long, RpcService> idToRpcServiceMapTmp = new ConcurrentHashMap<Long, RpcService>(32);
        ConcurrentHashMap<String, AtomicLong> serviceToCountMapTmp = new ConcurrentHashMap<String, AtomicLong>(32);
        Throwable[] throwable = new Throwable[1];
        Throwable error = (Throwable)Mono.just((Object)Objects.requireNonNull(this.redisTemplate.opsForHash().entries((Object)RPC_SERVICE_HASH_KEY).defaultIfEmpty(new AbstractMap.SimpleEntry<Object, Object>(ReactorUtils.OBJ, ReactorUtils.OBJ)).onErrorStop().doOnError(t -> LOGGER.info(null, t)).concatMap(e -> {
            Object k = e.getKey();
            if (k == ReactorUtils.OBJ) {
                return Flux.just((Object)e);
            }
            Object v = e.getValue();
            ThreadContext.put((String)"traceId", (String)k.toString());
            LOGGER.info(k.toString() + ':' + v.toString());
            String json = (String)v;
            try {
                RpcService rpcService = (RpcService)JacksonUtils.readValue((String)json, RpcService.class);
                this.updateLocalCache(rpcService, serviceToInstancesMapTmp, serviceToLoadBalanceTypeMapTmp, idToRpcServiceMapTmp, serviceToCountMapTmp);
                return Flux.just((Object)e);
            }
            catch (Throwable t) {
                throwable[0] = t;
                LOGGER.info(json, t);
                return Flux.error((Throwable)t);
            }
        }).blockLast())).flatMap(e -> {
            if (throwable[0] != null) {
                return Mono.error((Throwable)throwable[0]);
            }
            if (doAfterLoadCache != null) {
                return (Mono)doAfterLoadCache.get();
            }
            return Mono.just((Object)ReactorUtils.EMPTY_THROWABLE);
        }).block();
        if (error != ReactorUtils.EMPTY_THROWABLE) {
            assert (error != null);
            throw error;
        }
        serviceToInstancesMap = serviceToInstancesMapTmp;
        serviceToLoadBalanceTypeMap = serviceToLoadBalanceTypeMapTmp;
        idToRpcServiceMap = idToRpcServiceMapTmp;
        serviceToCountMap = serviceToCountMapTmp;
    }

    @Override
    public String getInstance(RpcInstanceService.RpcTypeEnum rpcTypeEnum, String service) {
        Byte loadBalanceType = serviceToLoadBalanceTypeMap.get(this.getServiceKey(rpcTypeEnum.getType(), service));
        if (LOAD_BALANCE_TYPE_RANDOM.equals(loadBalanceType)) {
            LOGGER.debug("type:{} service:{} get instance random", (Object)rpcTypeEnum, (Object)service);
            return this.getInstanceRandom(rpcTypeEnum, service);
        }
        LOGGER.debug("type:{} service:{} get instance round-robin", (Object)rpcTypeEnum, (Object)service);
        return this.getInstanceRoundRobin(rpcTypeEnum, service);
    }

    private String getInstanceRandom(RpcInstanceService.RpcTypeEnum rpcTypeEnum, String service) {
        List<String> instanceList = this.getAllInstance(rpcTypeEnum, service);
        if (CollectionUtils.isEmpty(instanceList)) {
            return null;
        }
        if (instanceList.size() == 1) {
            return instanceList.get(0);
        }
        return instanceList.get(ThreadLocalRandom.current().nextInt(instanceList.size()));
    }

    private String getInstanceRoundRobin(RpcInstanceService.RpcTypeEnum rpcTypeEnum, String service) {
        List<String> instanceList = this.getAllInstance(rpcTypeEnum, service);
        if (CollectionUtils.isEmpty(instanceList)) {
            return null;
        }
        if (instanceList.size() == 1) {
            return instanceList.get(0);
        }
        long currentCount = serviceToCountMap.computeIfAbsent(this.getServiceKey(rpcTypeEnum.getType(), service), it -> new AtomicLong()).getAndIncrement();
        return instanceList.get((int)currentCount % instanceList.size());
    }

    private List<String> getAllInstance(RpcInstanceService.RpcTypeEnum rpcTypeEnum, String service) {
        return serviceToInstancesMap.get(this.getServiceKey(rpcTypeEnum.getType(), service));
    }

    private Mono<Throwable> lsnRpcServiceChange() {
        Throwable[] throwable = new Throwable[1];
        boolean[] b = new boolean[]{false};
        this.redisTemplate.listenToChannel(new String[]{RPC_SERVICE_CHANNEL}).doOnError(t -> {
            throwable[0] = t;
            b[0] = false;
            LOGGER.error("lsn fizz_rpc_service_channel", t);
        }).doOnSubscribe(s -> {
            b[0] = true;
            LOGGER.info("success to lsn on fizz_rpc_service_channel");
        }).doOnNext(msg -> {
            String json = (String)msg.getMessage();
            ThreadContext.put((String)"traceId", (String)("rpc" + System.currentTimeMillis()));
            LOGGER.info(json);
            try {
                RpcService rpcService = (RpcService)JacksonUtils.readValue((String)json, RpcService.class);
                this.updateLocalCache(rpcService, serviceToInstancesMap, serviceToLoadBalanceTypeMap, idToRpcServiceMap, serviceToCountMap);
            }
            catch (Throwable t) {
                LOGGER.info(json, t);
            }
        }).subscribe();
        Throwable t2 = throwable[0];
        while (!b[0]) {
            if (t2 != null) {
                return Mono.error((Throwable)t2);
            }
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                return Mono.error((Throwable)e);
            }
        }
        return Mono.just((Object)ReactorUtils.EMPTY_THROWABLE);
    }

    private void updateLocalCache(RpcService rpcService, Map<String, List<String>> serviceToInstancesMap, Map<String, Byte> serviceToLoadBalanceTypeMap, Map<Long, RpcService> idToRpcServiceMap, Map<String, AtomicLong> serviceToCountMap) {
        if (rpcService.getType() == null) {
            rpcService.setType(RpcInstanceService.RpcTypeEnum.gRPC.getType());
            rpcService.setLoadBalanceType(LOAD_BALANCE_TYPE_ROUND_ROBIN);
        }
        if (rpcService.getIsDeleted() == 1) {
            RpcService removedRpcService = idToRpcServiceMap.remove(rpcService.getId());
            LOGGER.info("remove {}", (Object)removedRpcService);
            if (removedRpcService != null) {
                serviceToInstancesMap.remove(this.getServiceKey(rpcService));
                serviceToLoadBalanceTypeMap.remove(this.getServiceKey(rpcService));
                serviceToCountMap.remove(this.getServiceKey(rpcService));
            }
        } else {
            RpcService existRpcService = idToRpcServiceMap.get(rpcService.getId());
            idToRpcServiceMap.put(rpcService.getId(), rpcService);
            if (existRpcService == null) {
                LOGGER.info("add {}", (Object)rpcService);
            } else {
                LOGGER.info("update {} with {}", (Object)existRpcService, (Object)rpcService);
                serviceToInstancesMap.remove(this.getServiceKey(existRpcService));
                serviceToLoadBalanceTypeMap.remove(this.getServiceKey(existRpcService));
                serviceToCountMap.remove(this.getServiceKey(existRpcService));
            }
            serviceToInstancesMap.put(this.getServiceKey(rpcService), rpcService.getInstance() == null ? Collections.emptyList() : Arrays.asList(rpcService.getInstance().split(",")));
            serviceToLoadBalanceTypeMap.put(this.getServiceKey(rpcService), rpcService.getLoadBalanceType());
        }
    }

    private String getServiceKey(RpcService rpcService) {
        return String.format(SERVICE_KEY_PATTERN, rpcService.getType(), rpcService.getService());
    }

    private String getServiceKey(Byte type, String service) {
        return String.format(SERVICE_KEY_PATTERN, type, service);
    }

    static class RpcService {
        private static final int DELETED = 1;
        private Long id;
        private Integer isDeleted;
        private String service;
        private String instance;
        private Byte type;
        private Byte loadBalanceType;

        RpcService() {
        }

        public String toString() {
            return JacksonUtils.writeValueAsString((Object)this);
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Integer getIsDeleted() {
            return this.isDeleted;
        }

        public void setDeleted(Integer isDeleted) {
            this.isDeleted = isDeleted;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getInstance() {
            return this.instance;
        }

        public void setInstance(String instance) {
            this.instance = instance;
        }

        public Byte getType() {
            return this.type;
        }

        public void setType(Byte type) {
            this.type = type;
        }

        public Byte getLoadBalanceType() {
            return this.loadBalanceType;
        }

        public void setLoadBalanceType(Byte loadBalanceType) {
            this.loadBalanceType = loadBalanceType;
        }
    }
}

