/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy.dubbo;

import com.fizzgate.fizz.exception.FizzException;
import com.fizzgate.proxy.dubbo.ApacheDubboGenericServiceProperties;
import com.fizzgate.proxy.dubbo.DubboInterfaceDeclaration;
import com.fizzgate.proxy.dubbo.DubboUtils;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.utils.ReferenceConfigCache;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.service.GenericException;
import org.apache.dubbo.rpc.service.GenericService;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

@Service
public class ApacheDubboGenericService {
    @Resource
    private ApacheDubboGenericServiceProperties apacheDubboGenericServiceProperties;

    @PostConstruct
    public void afterPropertiesSet() {
    }

    public ReferenceConfig<GenericService> createReferenceConfig(String serviceName, String version, String group) {
        ApplicationConfig applicationConfig = new ApplicationConfig();
        applicationConfig.setName("fizz_proxy");
        RegistryConfig registryConfig = new RegistryConfig();
        registryConfig.setAddress(this.apacheDubboGenericServiceProperties.getZookeeperAddress());
        ReferenceConfig referenceConfig = new ReferenceConfig();
        referenceConfig.setInterface(serviceName);
        applicationConfig.setRegistry(registryConfig);
        referenceConfig.setApplication(applicationConfig);
        referenceConfig.setGeneric(Boolean.valueOf(true));
        referenceConfig.setAsync(Boolean.valueOf(true));
        referenceConfig.setTimeout(Integer.valueOf(30000));
        referenceConfig.setVersion(version);
        referenceConfig.setGroup(group);
        applicationConfig.setQosEnable(Boolean.valueOf(false));
        return referenceConfig;
    }

    public Mono<Object> send(Map<String, Object> body, DubboInterfaceDeclaration interfaceDeclaration, Map<String, String> attachments) {
        RpcContext.getContext().setAttachments(attachments);
        ReferenceConfig<GenericService> reference = this.createReferenceConfig(interfaceDeclaration.getServiceName(), interfaceDeclaration.getVersion(), interfaceDeclaration.getGroup());
        ReferenceConfigCache cache = ReferenceConfigCache.getCache();
        GenericService genericService = (GenericService)cache.get(reference);
        ImmutablePair pair = CollectionUtils.isEmpty(body) ? new ImmutablePair((Object)new String[0], (Object)new Object[0]) : DubboUtils.parseDubboParam(body, interfaceDeclaration.getParameterTypes());
        CompletableFuture<Object> future = null;
        Object object = genericService.$invoke(interfaceDeclaration.getMethod(), (String[])pair.getLeft(), (Object[])pair.getRight());
        future = object == null ? RpcContext.getContext().getCompletableFuture() : (object instanceof CompletableFuture ? (CompletableFuture)object : CompletableFuture.completedFuture(object));
        Mono result = Mono.fromFuture((CompletableFuture)future.thenApply(ret -> ret)).onErrorMap(exception -> exception instanceof GenericException ? new FizzException(((GenericException)exception).getExceptionMessage()) : new FizzException((Throwable)exception));
        if (interfaceDeclaration.getTimeout() != null && interfaceDeclaration.getTimeout() > 0) {
            return result.timeout(Duration.ofMillis(interfaceDeclaration.getTimeout().longValue()));
        }
        return result;
    }
}

