/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy.grpc;

import com.fizzgate.fizz.exception.FizzException;
import com.fizzgate.proxy.grpc.GrpcInterfaceDeclaration;
import com.fizzgate.proxy.grpc.ListenableFutureAdapter;
import com.fizzgate.proxy.grpc.client.CallResults;
import com.fizzgate.proxy.grpc.client.GrpcProxyClient;
import com.fizzgate.proxy.grpc.client.core.GrpcMethodDefinition;
import com.fizzgate.proxy.grpc.client.utils.ChannelFactory;
import com.fizzgate.proxy.grpc.client.utils.GrpcReflectionUtils;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.rpc.service.GenericException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class GrpcGenericService {
    @Autowired
    private GrpcProxyClient grpcProxyClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<Object> send(String payload, GrpcInterfaceDeclaration grpcInterfaceDeclaration, HashMap<String, Object> attachments) {
        GrpcMethodDefinition methodDefinition = GrpcReflectionUtils.parseToMethodDefinition(grpcInterfaceDeclaration.getServiceName() + "." + grpcInterfaceDeclaration.getMethod());
        HostAndPort endPoint = HostAndPort.fromString((String)grpcInterfaceDeclaration.getEndpoint());
        if (endPoint == null) {
            throw new RuntimeException("can't find target endpoint");
        }
        HashMap<String, Object> metaHeaderMap = attachments;
        ManagedChannel channel = null;
        try {
            channel = ChannelFactory.create(endPoint, metaHeaderMap);
            CallOptions calloptions = CallOptions.DEFAULT.withDeadlineAfter((long)grpcInterfaceDeclaration.getTimeout(), TimeUnit.MILLISECONDS);
            CallResults callResults = new CallResults();
            ListenableFuture<Void> future = this.grpcProxyClient.invokeMethodAsync(methodDefinition, (Channel)channel, calloptions, Collections.singletonList(payload), callResults);
            Mono mono = Mono.fromFuture((CompletableFuture)new ListenableFutureAdapter<Void>(future).getCompletableFuture().thenApply(ret -> callResults.asJSON())).onErrorMap(exception -> exception instanceof GenericException ? new FizzException(((GenericException)exception).getExceptionMessage()) : new FizzException((Throwable)exception));
            return mono;
        }
        finally {
            if (channel != null) {
                channel.shutdown();
            }
        }
    }
}

