/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy.grpc;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CompletableFuture;

public class ListenableFutureAdapter<T> {
    private final ListenableFuture<T> listenableFuture;
    private final CompletableFuture<T> completableFuture;

    public ListenableFutureAdapter(final ListenableFuture<T> listenableFuture) {
        this.listenableFuture = listenableFuture;
        this.completableFuture = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean cancelled = listenableFuture.cancel(mayInterruptIfRunning);
                super.cancel(cancelled);
                return cancelled;
            }
        };
        Futures.addCallback(this.listenableFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                ListenableFutureAdapter.this.completableFuture.complete(result);
            }

            public void onFailure(Throwable ex) {
                ListenableFutureAdapter.this.completableFuture.completeExceptionally(ex);
            }
        });
    }

    public CompletableFuture<T> getCompletableFuture() {
        return this.completableFuture;
    }

    public static final <T> CompletableFuture<T> toCompletable(ListenableFuture<T> listenableFuture) {
        ListenableFutureAdapter<T> listenableFutureAdapter = new ListenableFutureAdapter<T>(listenableFuture);
        return listenableFutureAdapter.getCompletableFuture();
    }
}

