/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy.grpc.client;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.util.List;

public class CallParams {
    private Descriptors.MethodDescriptor methodDescriptor;
    private Channel channel;
    private CallOptions callOptions;
    private List<DynamicMessage> requests;
    private StreamObserver<DynamicMessage> responseObserver;

    CallParams(Descriptors.MethodDescriptor methodDescriptor, Channel channel, CallOptions callOptions, List<DynamicMessage> requests, StreamObserver<DynamicMessage> responseObserver) {
        this.methodDescriptor = methodDescriptor;
        this.channel = channel;
        this.callOptions = callOptions;
        this.requests = requests;
        this.responseObserver = responseObserver;
    }

    public static CallParamsBuilder builder() {
        return new CallParamsBuilder();
    }

    public Descriptors.MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public CallOptions getCallOptions() {
        return this.callOptions;
    }

    public List<DynamicMessage> getRequests() {
        return this.requests;
    }

    public StreamObserver<DynamicMessage> getResponseObserver() {
        return this.responseObserver;
    }

    public static class CallParamsBuilder {
        private Descriptors.MethodDescriptor methodDescriptor;
        private Channel channel;
        private CallOptions callOptions;
        private List<DynamicMessage> requests;
        private StreamObserver<DynamicMessage> responseObserver;

        CallParamsBuilder() {
        }

        public CallParamsBuilder methodDescriptor(Descriptors.MethodDescriptor methodDescriptor) {
            this.methodDescriptor = methodDescriptor;
            return this;
        }

        public CallParamsBuilder channel(Channel channel) {
            this.channel = channel;
            return this;
        }

        public CallParamsBuilder callOptions(CallOptions callOptions) {
            this.callOptions = callOptions;
            return this;
        }

        public CallParamsBuilder requests(List<DynamicMessage> requests) {
            this.requests = requests;
            return this;
        }

        public CallParamsBuilder responseObserver(StreamObserver<DynamicMessage> responseObserver) {
            this.responseObserver = responseObserver;
            return this;
        }

        public CallParams build() {
            return new CallParams(this.methodDescriptor, this.channel, this.callOptions, this.requests, this.responseObserver);
        }

        public String toString() {
            return "CallParams.CallParamsBuilder(methodDescriptor=" + this.methodDescriptor + ", channel=" + this.channel + ", callOptions=" + this.callOptions + ", requests=" + this.requests + ", responseObserver=" + this.responseObserver + ")";
        }
    }
}

