/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy.grpc.client;

import com.fizzgate.proxy.grpc.client.CallParams;
import com.fizzgate.proxy.grpc.client.core.CompositeStreamObserver;
import com.fizzgate.proxy.grpc.client.core.DoneObserver;
import com.fizzgate.proxy.grpc.client.core.DynamicMessageMarshaller;
import com.fizzgate.proxy.grpc.client.utils.GrpcReflectionUtils;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcClient {
    private static final Logger logger = LoggerFactory.getLogger(GrpcClient.class);

    @Nullable
    public ListenableFuture<Void> call(CallParams callParams) {
        this.checkParams(callParams);
        MethodDescriptor.MethodType methodType = GrpcReflectionUtils.fetchMethodType(callParams.getMethodDescriptor());
        List<DynamicMessage> requests = callParams.getRequests();
        StreamObserver<DynamicMessage> responseObserver = callParams.getResponseObserver();
        DoneObserver doneObserver = new DoneObserver();
        CompositeStreamObserver compositeObserver = CompositeStreamObserver.of(responseObserver, doneObserver);
        switch (methodType) {
            case UNARY: {
                ClientCalls.asyncUnaryCall(this.createCall(callParams), (Object)requests.get(0), compositeObserver);
                return doneObserver.getCompletionFuture();
            }
            case SERVER_STREAMING: {
                ClientCalls.asyncServerStreamingCall(this.createCall(callParams), (Object)requests.get(0), compositeObserver);
                return doneObserver.getCompletionFuture();
            }
            case CLIENT_STREAMING: {
                StreamObserver requestObserver = ClientCalls.asyncClientStreamingCall(this.createCall(callParams), compositeObserver);
                requests.forEach(arg_0 -> responseObserver.onNext(arg_0));
                requestObserver.onCompleted();
                return doneObserver.getCompletionFuture();
            }
            case BIDI_STREAMING: {
                StreamObserver requestObserver = ClientCalls.asyncBidiStreamingCall(this.createCall(callParams), compositeObserver);
                requests.forEach(arg_0 -> responseObserver.onNext(arg_0));
                requestObserver.onCompleted();
                return doneObserver.getCompletionFuture();
            }
        }
        logger.info("Unknown methodType:{}", (Object)methodType);
        return null;
    }

    private void checkParams(CallParams callParams) {
        Preconditions.checkNotNull((Object)callParams);
        Preconditions.checkNotNull((Object)callParams.getMethodDescriptor());
        Preconditions.checkNotNull((Object)callParams.getChannel());
        Preconditions.checkNotNull((Object)callParams.getCallOptions());
        Preconditions.checkArgument((boolean)ObjectUtils.isNotEmpty(callParams.getRequests()));
        Preconditions.checkNotNull(callParams.getResponseObserver());
    }

    private ClientCall<DynamicMessage, DynamicMessage> createCall(CallParams callParams) {
        return callParams.getChannel().newCall(this.createGrpcMethodDescriptor(callParams.getMethodDescriptor()), callParams.getCallOptions());
    }

    private MethodDescriptor<DynamicMessage, DynamicMessage> createGrpcMethodDescriptor(Descriptors.MethodDescriptor descriptor) {
        return MethodDescriptor.newBuilder().setType(GrpcReflectionUtils.fetchMethodType(descriptor)).setFullMethodName(GrpcReflectionUtils.fetchFullMethodName(descriptor)).setRequestMarshaller((MethodDescriptor.Marshaller)new DynamicMessageMarshaller(descriptor.getInputType())).setResponseMarshaller((MethodDescriptor.Marshaller)new DynamicMessageMarshaller(descriptor.getOutputType())).build();
    }
}

