/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy.grpc.client;

import com.fizzgate.proxy.grpc.client.CallParams;
import com.fizzgate.proxy.grpc.client.CallResults;
import com.fizzgate.proxy.grpc.client.GrpcClient;
import com.fizzgate.proxy.grpc.client.core.GrpcMethodDefinition;
import com.fizzgate.proxy.grpc.client.core.ServiceResolver;
import com.fizzgate.proxy.grpc.client.utils.GrpcReflectionUtils;
import com.fizzgate.proxy.grpc.client.utils.MessageWriter;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.util.JsonFormat;
import io.grpc.CallOptions;
import io.grpc.Channel;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.springframework.stereotype.Service;

@Service
public class GrpcProxyClient {
    private GrpcClient grpcClient = new GrpcClient();

    public CallResults invokeMethod(GrpcMethodDefinition definition, Channel channel, CallOptions callOptions, List<String> requestJsonTexts) {
        CallResults results = new CallResults();
        try {
            this.invokeMethodAsync(definition, channel, callOptions, requestJsonTexts, results).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Caught exception while waiting for rpc", e);
        }
        return results;
    }

    public ListenableFuture<Void> invokeMethodAsync(GrpcMethodDefinition definition, Channel channel, CallOptions callOptions, List<String> requestJsonTexts, CallResults results) {
        DescriptorProtos.FileDescriptorSet fileDescriptorSet = GrpcReflectionUtils.resolveService(channel, definition.getFullServiceName());
        if (fileDescriptorSet == null) {
            return null;
        }
        ServiceResolver serviceResolver = ServiceResolver.fromFileDescriptorSet(fileDescriptorSet);
        Descriptors.MethodDescriptor methodDescriptor = serviceResolver.resolveServiceMethod(definition);
        JsonFormat.TypeRegistry registry = JsonFormat.TypeRegistry.newBuilder().add(serviceResolver.listMessageTypes()).build();
        List<DynamicMessage> requestMessages = GrpcReflectionUtils.parseToMessages(registry, methodDescriptor.getInputType(), requestJsonTexts);
        MessageWriter<DynamicMessage> streamObserver = MessageWriter.newInstance(registry, results);
        CallParams callParams = CallParams.builder().methodDescriptor(methodDescriptor).channel(channel).callOptions(callOptions).requests(requestMessages).responseObserver(streamObserver).build();
        return this.grpcClient.call(callParams);
    }
}

