/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy.grpc.client.core;

import com.google.common.collect.ImmutableList;
import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeStreamObserver<T>
implements StreamObserver<T> {
    private static final Logger logger = LoggerFactory.getLogger(CompositeStreamObserver.class);
    private final ImmutableList<StreamObserver<T>> observers;

    @SafeVarargs
    public static <T> CompositeStreamObserver<T> of(StreamObserver<T> ... observers) {
        return new CompositeStreamObserver<T>(ImmutableList.copyOf((Object[])observers));
    }

    private CompositeStreamObserver(ImmutableList<StreamObserver<T>> observers) {
        this.observers = observers;
    }

    public void onCompleted() {
        for (StreamObserver observer : this.observers) {
            try {
                observer.onCompleted();
            }
            catch (Throwable t) {
                logger.error("Exception in composite onComplete, moving on", t);
            }
        }
    }

    public void onError(Throwable t) {
        for (StreamObserver observer : this.observers) {
            try {
                observer.onError(t);
            }
            catch (Throwable s) {
                logger.error("Exception in composite onError, moving on", s);
            }
        }
    }

    public void onNext(T value) {
        for (StreamObserver observer : this.observers) {
            try {
                observer.onNext(value);
            }
            catch (Throwable t) {
                logger.error("Exception in composite onNext, moving on", t);
            }
        }
    }
}

