/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy.grpc.client.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.Channel;
import io.grpc.reflection.v1alpha.ListServiceResponse;
import io.grpc.reflection.v1alpha.ServerReflectionGrpc;
import io.grpc.reflection.v1alpha.ServerReflectionRequest;
import io.grpc.reflection.v1alpha.ServerReflectionResponse;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerReflectionClient {
    private static final Logger logger = LoggerFactory.getLogger(ServerReflectionClient.class);
    private static final long LIST_RPC_DEADLINE_MS = 10000L;
    private static final long LOOKUP_RPC_DEADLINE_MS = 10000L;
    private static final ServerReflectionRequest LIST_SERVICES_REQUEST = ServerReflectionRequest.newBuilder().setListServices("").build();
    private final Channel channel;

    public static ServerReflectionClient create(Channel channel) {
        return new ServerReflectionClient(channel);
    }

    private ServerReflectionClient(Channel channel) {
        this.channel = channel;
    }

    public ListenableFuture<ImmutableList<String>> listServices() {
        ListServicesHandler rpcHandler = new ListServicesHandler();
        StreamObserver requestStream = ((ServerReflectionGrpc.ServerReflectionStub)ServerReflectionGrpc.newStub((Channel)this.channel).withDeadlineAfter(10000L, TimeUnit.MILLISECONDS)).serverReflectionInfo((StreamObserver)rpcHandler);
        return rpcHandler.start((StreamObserver<ServerReflectionRequest>)requestStream);
    }

    public ListenableFuture<DescriptorProtos.FileDescriptorSet> lookupService(String serviceName) {
        LookupServiceHandler rpcHandler = new LookupServiceHandler(serviceName);
        StreamObserver requestStream = ((ServerReflectionGrpc.ServerReflectionStub)ServerReflectionGrpc.newStub((Channel)this.channel).withDeadlineAfter(10000L, TimeUnit.MILLISECONDS)).serverReflectionInfo((StreamObserver)rpcHandler);
        return rpcHandler.start((StreamObserver<ServerReflectionRequest>)requestStream);
    }

    private static class LookupServiceHandler
    implements StreamObserver<ServerReflectionResponse> {
        private final SettableFuture<DescriptorProtos.FileDescriptorSet> resultFuture;
        private final String serviceName;
        private final HashSet<String> requestedDescriptors;
        private final HashMap<String, DescriptorProtos.FileDescriptorProto> resolvedDescriptors;
        private StreamObserver<ServerReflectionRequest> requestStream;
        private int outstandingRequests;

        private LookupServiceHandler(String serviceName) {
            this.serviceName = serviceName;
            this.resultFuture = SettableFuture.create();
            this.resolvedDescriptors = new HashMap();
            this.requestedDescriptors = new HashSet();
            this.outstandingRequests = 0;
        }

        ListenableFuture<DescriptorProtos.FileDescriptorSet> start(StreamObserver<ServerReflectionRequest> requestStream) {
            this.requestStream = requestStream;
            requestStream.onNext((Object)LookupServiceHandler.requestForSymbol(this.serviceName));
            ++this.outstandingRequests;
            return this.resultFuture;
        }

        public void onNext(ServerReflectionResponse response) {
            ServerReflectionResponse.MessageResponseCase responseCase = response.getMessageResponseCase();
            switch (responseCase) {
                case FILE_DESCRIPTOR_RESPONSE: {
                    ImmutableSet<DescriptorProtos.FileDescriptorProto> descriptors = this.parseDescriptors(response.getFileDescriptorResponse().getFileDescriptorProtoList());
                    descriptors.forEach(d -> this.resolvedDescriptors.put(d.getName(), (DescriptorProtos.FileDescriptorProto)d));
                    descriptors.forEach(this::processDependencies);
                    break;
                }
                default: {
                    logger.warn("Got unknown reflection response type: " + responseCase);
                }
            }
        }

        public void onError(Throwable t) {
            this.resultFuture.setException((Throwable)new RuntimeException("Reflection lookup rpc failed for: " + this.serviceName, t));
        }

        public void onCompleted() {
            if (!this.resultFuture.isDone()) {
                logger.error("Unexpected completion of the server reflection rpc");
                this.resultFuture.setException((Throwable)new RuntimeException("Unexpected end of rpc"));
            }
        }

        private ImmutableSet<DescriptorProtos.FileDescriptorProto> parseDescriptors(List<ByteString> descriptorBytes) {
            ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
            for (ByteString fileDescriptorBytes : descriptorBytes) {
                try {
                    resultBuilder.add((Object)DescriptorProtos.FileDescriptorProto.parseFrom((ByteString)fileDescriptorBytes));
                }
                catch (InvalidProtocolBufferException e) {
                    logger.warn("Failed to parse bytes as file descriptor proto");
                }
            }
            return resultBuilder.build();
        }

        private void processDependencies(DescriptorProtos.FileDescriptorProto fileDescriptor) {
            logger.debug("Processing deps of descriptor: " + fileDescriptor.getName());
            fileDescriptor.getDependencyList().forEach(dep -> {
                if (!this.resolvedDescriptors.containsKey(dep) && !this.requestedDescriptors.contains(dep)) {
                    this.requestedDescriptors.add((String)dep);
                    ++this.outstandingRequests;
                    this.requestStream.onNext((Object)LookupServiceHandler.requestForDescriptor(dep));
                }
            });
            --this.outstandingRequests;
            if (this.outstandingRequests == 0) {
                logger.debug("Retrieved service definition for [{}] by reflection", (Object)this.serviceName);
                this.resultFuture.set((Object)DescriptorProtos.FileDescriptorSet.newBuilder().addAllFile(this.resolvedDescriptors.values()).build());
                this.requestStream.onCompleted();
            }
        }

        private static ServerReflectionRequest requestForDescriptor(String name) {
            return ServerReflectionRequest.newBuilder().setFileByFilename(name).build();
        }

        private static ServerReflectionRequest requestForSymbol(String symbol) {
            return ServerReflectionRequest.newBuilder().setFileContainingSymbol(symbol).build();
        }
    }

    private static class ListServicesHandler
    implements StreamObserver<ServerReflectionResponse> {
        private final SettableFuture<ImmutableList<String>> resultFuture = SettableFuture.create();
        private StreamObserver<ServerReflectionRequest> requestStream;

        private ListServicesHandler() {
        }

        ListenableFuture<ImmutableList<String>> start(StreamObserver<ServerReflectionRequest> requestStream) {
            this.requestStream = requestStream;
            requestStream.onNext((Object)LIST_SERVICES_REQUEST);
            return this.resultFuture;
        }

        public void onNext(ServerReflectionResponse serverReflectionResponse) {
            ServerReflectionResponse.MessageResponseCase responseCase = serverReflectionResponse.getMessageResponseCase();
            switch (responseCase) {
                case LIST_SERVICES_RESPONSE: {
                    this.handleListServiceResponse(serverReflectionResponse.getListServicesResponse());
                    break;
                }
                default: {
                    logger.warn("Got unknown reflection response type: " + responseCase);
                }
            }
        }

        public void onError(Throwable t) {
            this.resultFuture.setException((Throwable)new RuntimeException("Error in server reflection rpc while listing services", t));
        }

        public void onCompleted() {
            if (!this.resultFuture.isDone()) {
                logger.error("Unexpected completion of server reflection rpc while listing services");
                this.resultFuture.setException((Throwable)new RuntimeException("Unexpected end of rpc"));
            }
        }

        private void handleListServiceResponse(ListServiceResponse response) {
            ImmutableList.Builder servicesBuilder = ImmutableList.builder();
            response.getServiceList().forEach(service -> servicesBuilder.add((Object)service.getName()));
            this.resultFuture.set((Object)servicesBuilder.build());
            this.requestStream.onCompleted();
        }
    }
}

