/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy.grpc.client.core;

import com.fizzgate.proxy.grpc.client.core.GrpcMethodDefinition;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceResolver {
    private static final Logger logger = LoggerFactory.getLogger(ServiceResolver.class);
    private final ImmutableList<Descriptors.FileDescriptor> fileDescriptors;

    public static ServiceResolver fromFileDescriptorSet(DescriptorProtos.FileDescriptorSet descriptorSet) {
        ImmutableMap<String, DescriptorProtos.FileDescriptorProto> descriptorProtoIndex = ServiceResolver.computeDescriptorProtoIndex(descriptorSet);
        HashMap<String, Descriptors.FileDescriptor> descriptorCache = new HashMap<String, Descriptors.FileDescriptor>();
        ImmutableList.Builder result = ImmutableList.builder();
        for (DescriptorProtos.FileDescriptorProto descriptorProto : descriptorSet.getFileList()) {
            try {
                result.add((Object)ServiceResolver.descriptorFromProto(descriptorProto, descriptorProtoIndex, descriptorCache));
            }
            catch (Descriptors.DescriptorValidationException e) {
                logger.warn("Skipped descriptor " + descriptorProto.getName() + " due to error", (Throwable)e);
            }
        }
        return new ServiceResolver((Iterable<Descriptors.FileDescriptor>)result.build());
    }

    private ServiceResolver(Iterable<Descriptors.FileDescriptor> fileDescriptors) {
        this.fileDescriptors = ImmutableList.copyOf(fileDescriptors);
    }

    public Iterable<Descriptors.ServiceDescriptor> listServices() {
        ArrayList<Descriptors.ServiceDescriptor> serviceDescriptors = new ArrayList<Descriptors.ServiceDescriptor>();
        for (Descriptors.FileDescriptor fileDescriptor : this.fileDescriptors) {
            serviceDescriptors.addAll(fileDescriptor.getServices());
        }
        return serviceDescriptors;
    }

    public ImmutableSet<Descriptors.Descriptor> listMessageTypes() {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        this.fileDescriptors.forEach(d -> resultBuilder.addAll((Iterable)d.getMessageTypes()));
        return resultBuilder.build();
    }

    public Descriptors.MethodDescriptor resolveServiceMethod(GrpcMethodDefinition definition) {
        Descriptors.ServiceDescriptor service = this.findService(definition.getPackageName(), definition.getServiceName());
        Descriptors.MethodDescriptor method = service.findMethodByName(definition.getMethodName());
        if (method == null) {
            throw new IllegalArgumentException("Unable to find method " + definition.getMethodName() + " in service " + definition.getServiceName());
        }
        return method;
    }

    private Descriptors.ServiceDescriptor findService(String packageName, String serviceName) {
        for (Descriptors.FileDescriptor fileDescriptor : this.fileDescriptors) {
            Descriptors.ServiceDescriptor serviceDescriptor;
            if (!fileDescriptor.getPackage().equals(packageName) || (serviceDescriptor = fileDescriptor.findServiceByName(serviceName)) == null) continue;
            return serviceDescriptor;
        }
        throw new IllegalArgumentException("Unable to find service with name: " + serviceName);
    }

    private static ImmutableMap<String, DescriptorProtos.FileDescriptorProto> computeDescriptorProtoIndex(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (DescriptorProtos.FileDescriptorProto descriptorProto : fileDescriptorSet.getFileList()) {
            resultBuilder.put((Object)descriptorProto.getName(), (Object)descriptorProto);
        }
        return resultBuilder.build();
    }

    private static Descriptors.FileDescriptor descriptorFromProto(DescriptorProtos.FileDescriptorProto descriptorProto, ImmutableMap<String, DescriptorProtos.FileDescriptorProto> descriptorProtoIndex, Map<String, Descriptors.FileDescriptor> descriptorCache) throws Descriptors.DescriptorValidationException {
        String descriptorName = descriptorProto.getName();
        if (descriptorCache.containsKey(descriptorName)) {
            return descriptorCache.get(descriptorName);
        }
        ImmutableList.Builder dependencies = ImmutableList.builder();
        for (String dependencyName : descriptorProto.getDependencyList()) {
            if (!descriptorProtoIndex.containsKey((Object)dependencyName)) {
                throw new IllegalArgumentException("Could not find dependency: " + dependencyName);
            }
            DescriptorProtos.FileDescriptorProto dependencyProto = (DescriptorProtos.FileDescriptorProto)descriptorProtoIndex.get((Object)dependencyName);
            dependencies.add((Object)ServiceResolver.descriptorFromProto(dependencyProto, descriptorProtoIndex, descriptorCache));
        }
        Object[] empty = new Descriptors.FileDescriptor[]{};
        return Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)descriptorProto, (Descriptors.FileDescriptor[])((Descriptors.FileDescriptor[])dependencies.build().toArray(empty)));
    }

    public List<Descriptors.FileDescriptor> getFileDescriptors() {
        return this.fileDescriptors;
    }
}

