/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy.grpc.client.utils;

import com.google.common.net.HostAndPort;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.util.Collections;
import java.util.Map;

public class ChannelFactory {
    public static ManagedChannel create(HostAndPort endpoint) {
        return ChannelFactory.create(endpoint, Collections.emptyMap());
    }

    public static ManagedChannel create(HostAndPort endpoint, Map<String, Object> metaDataMap) {
        return ((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)endpoint.getHostText(), (int)endpoint.getPort()).negotiationType(NegotiationType.PLAINTEXT).intercept(new ClientInterceptor[]{ChannelFactory.metadataInterceptor(metaDataMap)})).build();
    }

    private static ClientInterceptor metadataInterceptor(final Map<String, Object> metaDataMap) {
        return new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                    protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                        metaDataMap.forEach((k, v) -> {
                            Metadata.Key mKey = Metadata.Key.of((String)k, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                            headers.put(mKey, (Object)String.valueOf(v));
                        });
                        this.delegate().start(responseListener, headers);
                    }
                };
            }
        };
    }
}

