/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy.grpc.client.utils;

import com.fizzgate.proxy.grpc.client.core.GrpcMethodDefinition;
import com.fizzgate.proxy.grpc.client.core.ServerReflectionClient;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcReflectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(GrpcReflectionUtils.class);

    public static List<DescriptorProtos.FileDescriptorSet> resolveServices(Channel channel) {
        ServerReflectionClient serverReflectionClient = ServerReflectionClient.create(channel);
        try {
            List services = (List)serverReflectionClient.listServices().get();
            if (ObjectUtils.isEmpty((Object)services)) {
                logger.info("Can't find services by channel {}", (Object)channel);
                return Collections.emptyList();
            }
            return services.stream().map(serviceName -> {
                ListenableFuture<DescriptorProtos.FileDescriptorSet> future = serverReflectionClient.lookupService((String)serviceName);
                try {
                    return (DescriptorProtos.FileDescriptorSet)future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Get {} fileDescriptor occurs error", serviceName, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Throwable t) {
            logger.error("Exception resolve service", t);
            throw new RuntimeException(t);
        }
    }

    public static DescriptorProtos.FileDescriptorSet resolveService(Channel channel, String serviceName) {
        ServerReflectionClient reflectionClient = ServerReflectionClient.create(channel);
        try {
            List serviceNames = (List)reflectionClient.listServices().get();
            if (!serviceNames.contains(serviceName)) {
                throw Status.NOT_FOUND.withDescription(String.format("Remote server does not have service %s. Services: %s", serviceName, serviceNames)).asRuntimeException();
            }
            return (DescriptorProtos.FileDescriptorSet)reflectionClient.lookupService(serviceName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Resolve services get error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String fetchFullMethodName(Descriptors.MethodDescriptor methodDescriptor) {
        String serviceName = methodDescriptor.getService().getFullName();
        String methodName = methodDescriptor.getName();
        return MethodDescriptor.generateFullMethodName((String)serviceName, (String)methodName);
    }

    public static MethodDescriptor.MethodType fetchMethodType(Descriptors.MethodDescriptor methodDescriptor) {
        boolean clientStreaming = methodDescriptor.toProto().getClientStreaming();
        boolean serverStreaming = methodDescriptor.toProto().getServerStreaming();
        if (clientStreaming && serverStreaming) {
            return MethodDescriptor.MethodType.BIDI_STREAMING;
        }
        if (!clientStreaming && !serverStreaming) {
            return MethodDescriptor.MethodType.UNARY;
        }
        if (!clientStreaming) {
            return MethodDescriptor.MethodType.SERVER_STREAMING;
        }
        return MethodDescriptor.MethodType.SERVER_STREAMING;
    }

    public static List<DynamicMessage> parseToMessages(JsonFormat.TypeRegistry registry, Descriptors.Descriptor descriptor, List<String> jsonTexts) {
        JsonFormat.Parser parser = JsonFormat.parser().usingTypeRegistry(registry);
        ArrayList<DynamicMessage> messages = new ArrayList<DynamicMessage>();
        try {
            for (String jsonText : jsonTexts) {
                DynamicMessage.Builder messageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
                parser.merge(jsonText, (Message.Builder)messageBuilder);
                messages.add(messageBuilder.build());
            }
            return messages;
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Unable to parse json text", e);
        }
    }

    public static GrpcMethodDefinition parseToMethodDefinition(String rawMethodName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)rawMethodName), (Object)"Raw method name can't be empty.");
        int methodSplitPosition = rawMethodName.lastIndexOf(".");
        Preconditions.checkArgument((methodSplitPosition != -1 ? 1 : 0) != 0, (Object)"No package name and service name found.");
        String methodName = rawMethodName.substring(methodSplitPosition + 1);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)methodName), (Object)"Method name can't be empty.");
        String fullServiceName = rawMethodName.substring(0, methodSplitPosition);
        int serviceSplitPosition = fullServiceName.lastIndexOf(".");
        String serviceName = fullServiceName.substring(serviceSplitPosition + 1);
        String packageName = "";
        if (serviceSplitPosition != -1) {
            packageName = fullServiceName.substring(0, serviceSplitPosition);
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)serviceName), (Object)"Service name can't be empty.");
        return new GrpcMethodDefinition(packageName, serviceName, methodName);
    }
}

