/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy.grpc.client.utils;

import com.fizzgate.proxy.grpc.client.CallResults;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageWriter<T extends Message>
implements StreamObserver<T> {
    private static final Logger logger = LoggerFactory.getLogger(MessageWriter.class);
    private final JsonFormat.Printer printer;
    private final CallResults results;

    private MessageWriter(JsonFormat.Printer printer, CallResults results) {
        this.printer = printer;
        this.results = results;
    }

    public static <T extends Message> MessageWriter<T> newInstance(JsonFormat.TypeRegistry registry, CallResults results) {
        return new MessageWriter<T>(JsonFormat.printer().usingTypeRegistry(registry).includingDefaultValueFields(), results);
    }

    public void onNext(T value) {
        try {
            this.results.add(this.printer.print(value));
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("Skipping invalid response message", (Throwable)e);
        }
    }

    public void onError(Throwable t) {
        logger.error("Messages write occur errors", t);
    }

    public void onCompleted() {
        logger.info("Messages write complete");
    }
}

