/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.service_registry;

import com.fizzgate.service_registry.eureka.FizzEurekaHelper;
import com.fizzgate.service_registry.nacos.FizzNacosHelper;
import com.fizzgate.util.PropertiesUtils;
import com.fizzgate.util.YmlUtils;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.ApplicationContext;

public abstract class FizzServiceRegistration {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FizzServiceRegistration.class);
    protected String id;
    private Type type;
    private Registration registration;
    private ServiceRegistry serviceRegistry;

    public static FizzServiceRegistration getFizzServiceRegistration(ApplicationContext applicationContext, Type type, ConfigFormat configFormat, String config) {
        Properties configProperties = configFormat == ConfigFormat.YML ? YmlUtils.string2properties((String)config) : PropertiesUtils.from((String)config);
        FizzServiceRegistration fizzServiceRegistration = type == Type.EUREKA ? FizzEurekaHelper.getServiceRegistration(applicationContext, configProperties) : FizzNacosHelper.getServiceRegistration(applicationContext, configProperties);
        return fizzServiceRegistration;
    }

    public FizzServiceRegistration(String id, Type type, Registration registration, ServiceRegistry serviceRegistry) {
        this.id = id;
        this.type = type;
        this.registration = registration;
        this.serviceRegistry = serviceRegistry;
    }

    public String getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public void register() {
        this.serviceRegistry.register(this.registration);
        LOGGER.info("register to {} {}", (Object)this.type, (Object)this.id);
    }

    public void deregister() {
        this.serviceRegistry.deregister(this.registration);
        LOGGER.info("deregister to {} {}", (Object)this.type, (Object)this.id);
    }

    public void close() {
        this.serviceRegistry.close();
        this.shutdownClient();
        LOGGER.info("close {} {}", (Object)this.type, (Object)this.id);
    }

    protected abstract void shutdownClient();

    public abstract ServerStatus getServerStatus();

    public abstract List<String> getServices();

    public abstract String getInstance(String var1);

    public static enum ServerStatus {
        UP,
        DOWN,
        STARTING,
        OUT_OF_SERVICE,
        UNKNOWN;

    }

    public static enum ConfigFormat {
        YML,
        PROPERTIES;

    }

    public static enum Type {
        EUREKA,
        NACOS;

    }
}

