/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.service_registry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fizzgate.service_registry.FizzServiceRegistration;
import com.fizzgate.util.JacksonUtils;
import java.util.Objects;
import org.springframework.context.ApplicationContext;

public class RegistryCenter {
    public static final int EUREKA = 1;
    public static final int NACOS = 2;
    public static final int YML = 1;
    public static final int PROPERTIES = 2;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public boolean isDeleted = false;
    public long id;
    public String name;
    public int type;
    public int clientConfigFormat;
    public String clientConfig;
    private FizzServiceRegistration fizzServiceRegistration;

    @JsonCreator
    public RegistryCenter(@JsonProperty(value="isDeleted") int isDeleted, @JsonProperty(value="id") long id, @JsonProperty(value="name") String name, @JsonProperty(value="type") int type, @JsonProperty(value="format") int clientConfigFormat, @JsonProperty(value="content") String clientConfig) {
        if (isDeleted == 1) {
            this.isDeleted = true;
        }
        this.id = id;
        this.name = name;
        this.type = type;
        this.clientConfigFormat = clientConfigFormat;
        this.clientConfig = clientConfig;
    }

    public void initFizzServiceRegistration(ApplicationContext applicationContext) {
        this.fizzServiceRegistration = FizzServiceRegistration.getFizzServiceRegistration(applicationContext, this.type == 1 ? FizzServiceRegistration.Type.EUREKA : FizzServiceRegistration.Type.NACOS, this.clientConfigFormat == 1 ? FizzServiceRegistration.ConfigFormat.YML : FizzServiceRegistration.ConfigFormat.PROPERTIES, this.clientConfig);
    }

    @JsonIgnore
    public FizzServiceRegistration getFizzServiceRegistration() {
        return this.fizzServiceRegistration;
    }

    @JsonIgnore
    public String getInstance(String service) {
        return this.fizzServiceRegistration.getInstance(service);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistryCenter that = (RegistryCenter)o;
        return this.id == that.id && this.type == that.type && this.clientConfigFormat == that.clientConfigFormat && Objects.equals(this.name, that.name) && Objects.equals(this.clientConfig, that.clientConfig);
    }

    public String toString() {
        return JacksonUtils.writeValueAsString((Object)this);
    }
}

