/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.service_registry;

import com.fizzgate.config.SystemConfig;
import com.fizzgate.service_registry.FizzServiceRegistration;
import com.fizzgate.service_registry.RegistryCenter;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.Result;
import com.fizzgate.util.ThreadContext;
import com.fizzgate.util.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class RegistryCenterService
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryCenterService.class);
    private Map<String, RegistryCenter> registryCenterMap = new HashMap<String, RegistryCenter>();
    @Resource
    private ReactiveWebServerApplicationContext applicationContext;
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;
    @Resource
    private SystemConfig systemConfig;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Result<?> result = this.initRegistryCenter();
        if (result.code == 0) {
            throw new RuntimeException(result.msg, result.t);
        }
        result = this.lsnRegistryCenterChange();
        if (result.code == 0) {
            throw new RuntimeException(result.msg, result.t);
        }
    }

    public Result<?> initRegistryCenter() {
        Result result = Result.succ();
        Flux registryCenterEntries = this.rt.opsForHash().entries((Object)"fizz_registry");
        registryCenterEntries.collectList().defaultIfEmpty(Collections.emptyList()).flatMap(es -> {
            if (!es.isEmpty()) {
                String json = null;
                try {
                    for (Map.Entry e : es) {
                        json = (String)e.getValue();
                        RegistryCenter rc = (RegistryCenter)JacksonUtils.readValue((String)json, RegistryCenter.class);
                        RegistryCenter currentRegistryCenter = this.registryCenterMap.get(rc.name);
                        if (currentRegistryCenter == null) {
                            this.register(rc);
                            continue;
                        }
                        if (rc.equals(currentRegistryCenter)) continue;
                        this.deregister(currentRegistryCenter);
                        this.register(rc);
                    }
                }
                catch (Throwable t) {
                    result.code = 0;
                    result.msg = "init registry center error, json: " + json;
                    result.t = t;
                }
            } else {
                LOGGER.info("no registry center");
            }
            return Mono.empty();
        }).onErrorReturn(throwable -> {
            result.code = 0;
            result.msg = "init registry center error";
            result.t = throwable;
            return true;
        }, (Object)result).block();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregister(RegistryCenter rc) throws Throwable {
        FizzServiceRegistration fizzServiceRegistration = rc.getFizzServiceRegistration();
        Throwable error = null;
        try {
            fizzServiceRegistration.deregister();
            this.registryCenterMap.remove(rc.name);
        }
        catch (Throwable t) {
            LOGGER.error("deregister {}", (Object)rc, (Object)t);
            error = t;
        }
        finally {
            try {
                fizzServiceRegistration.close();
            }
            catch (Throwable t) {
                LOGGER.error("close {}", (Object)rc, (Object)t);
                error = t;
            }
        }
        if (error != null) {
            if (this.systemConfig.isFastFailWhenRegistryCenterDown()) {
                throw error;
            }
            LOGGER.warn("fail to deregister {}, fast fail when registry center down is false, so continue", (Object)rc);
        }
    }

    private void register(RegistryCenter rc) throws Throwable {
        rc.initFizzServiceRegistration((ApplicationContext)this.applicationContext);
        FizzServiceRegistration fizzServiceRegistration = rc.getFizzServiceRegistration();
        try {
            fizzServiceRegistration.register();
            this.registryCenterMap.put(rc.name, rc);
        }
        catch (Throwable t0) {
            Throwable error = t0;
            LOGGER.error("register {}", (Object)rc, (Object)t0);
            try {
                fizzServiceRegistration.close();
            }
            catch (Throwable t1) {
                error = t1;
                LOGGER.error("close {}", (Object)rc, (Object)t1);
            }
            if (this.systemConfig.isFastFailWhenRegistryCenterDown()) {
                throw error;
            }
            LOGGER.warn("fail to register {}, fast fail when registry center down is false, so continue", (Object)rc);
        }
    }

    private Result<?> lsnRegistryCenterChange() {
        Result result = Result.succ();
        String channel = "fizz_registry_channel";
        this.rt.listenToChannel(new String[]{channel}).doOnError(t -> {
            result.code = 0;
            result.msg = "lsn error, channel: " + channel;
            result.t = t;
            LOGGER.error("lsn channel {} error", (Object)channel, t);
        }).doOnSubscribe(s -> LOGGER.info("success to lsn on {}", (Object)channel)).doOnNext(msg -> {
            String message = (String)msg.getMessage();
            try {
                RegistryCenter rc = (RegistryCenter)JacksonUtils.readValue((String)message, RegistryCenter.class);
                RegistryCenter prev = this.registryCenterMap.get(rc.name);
                if (rc.isDeleted) {
                    this.deregister(prev);
                } else {
                    if (prev != null) {
                        this.deregister(prev);
                    }
                    this.register(rc);
                }
            }
            catch (Throwable t) {
                LOGGER.error("update registry center error, {}", (Object)message, (Object)t);
            }
        }).subscribe();
        return result;
    }

    public RegistryCenter getRegistryCenter(String name) {
        return this.registryCenterMap.get(name);
    }

    public String getInstance(String registryCenter, String service) {
        RegistryCenter rc = this.registryCenterMap.get(registryCenter);
        if (rc == null) {
            throw Utils.runtimeExceptionWithoutStack((String)(registryCenter + " not exists"));
        }
        return rc.getInstance(service);
    }

    public static String getServiceNameSpace(String registryCenter, String service) {
        if (registryCenter == null) {
            return service;
        }
        StringBuilder b = ThreadContext.getStringBuilder((String)"$sb0");
        return b.append(registryCenter).append(',').append(service).toString();
    }
}

