/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.service_registry.eureka;

import com.fizzgate.service_registry.eureka.FizzEurekaServiceRegistration;
import com.fizzgate.util.PropertiesUtils;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.cloud.loadbalancer.support.SimpleObjectProvider;
import org.springframework.cloud.netflix.eureka.CloudEurekaClient;
import org.springframework.cloud.netflix.eureka.CloudEurekaInstanceConfig;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.eureka.InstanceInfoFactory;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;

public abstract class FizzEurekaHelper {
    private static final int el = "eureka.".length();
    private static final int ecl = "eureka.client.".length();
    private static final int eil = "eureka.instance.".length();

    private FizzEurekaHelper() {
    }

    public static FizzEurekaServiceRegistration getServiceRegistration(ApplicationContext applicationContext, Properties eurekaProperties) {
        String serverPort;
        String virtualHostName;
        Properties eurekaProps = new Properties();
        eurekaProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(n, v) -> {
            String propertyName = (String)n;
            String pn = null;
            pn = propertyName.charAt(ecl - 1) == '.' ? propertyName.substring(ecl) : (propertyName.charAt(eil - 1) == '.' ? propertyName.substring(eil) : propertyName.substring(el));
            if (pn.indexOf(45) > -1) {
                pn = PropertiesUtils.normalize((String)pn);
            }
            eurekaProps.put(pn, v);
        }));
        InetUtils inetUtils = null;
        try {
            inetUtils = (InetUtils)applicationContext.getBean(InetUtils.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            inetUtils = new InetUtils(new InetUtilsProperties());
        }
        EurekaInstanceConfigBean eurekaInstanceConfig = new EurekaInstanceConfigBean(inetUtils);
        PropertiesUtils.setBeanPropertyValue((Object)eurekaInstanceConfig, (Properties)eurekaProps);
        String appname = eurekaInstanceConfig.getAppname();
        if (appname == null || appname.equals("unknown")) {
            appname = applicationContext.getEnvironment().getProperty("spring.application.name");
            eurekaInstanceConfig.setAppname(appname);
        }
        if ((virtualHostName = eurekaInstanceConfig.getVirtualHostName()) == null || virtualHostName.equals("unknown")) {
            eurekaInstanceConfig.setVirtualHostName(appname);
        }
        if ((serverPort = eurekaProps.getProperty("serverPort")) == null) {
            serverPort = applicationContext.getEnvironment().getProperty("server.port");
        }
        assert (serverPort != null);
        eurekaInstanceConfig.setNonSecurePort(Integer.parseInt(serverPort));
        String ipAddress = System.getProperty("eureka.instance.ip-address");
        if (StringUtils.isBlank((CharSequence)ipAddress) && StringUtils.isBlank((CharSequence)(ipAddress = System.getenv("eureka.instance.ip-address"))) && (ipAddress = eurekaInstanceConfig.getIpAddress()) == null) {
            ipAddress = inetUtils.findFirstNonLoopbackAddress().getHostAddress();
        }
        eurekaInstanceConfig.setIpAddress(ipAddress);
        String instanceId = eurekaInstanceConfig.getInstanceId();
        if (instanceId == null) {
            eurekaInstanceConfig.setInstanceId(ipAddress + ':' + appname + ':' + serverPort);
        }
        InstanceInfo instanceInfo = new InstanceInfoFactory().create((EurekaInstanceConfig)eurekaInstanceConfig);
        ApplicationInfoManager applicationInfoManager = new ApplicationInfoManager((EurekaInstanceConfig)eurekaInstanceConfig, instanceInfo);
        EurekaClientConfigBean eurekaClientConfig = new EurekaClientConfigBean();
        HashMap<String, Class<Map>> propertyTypeHint = new HashMap<String, Class<Map>>();
        propertyTypeHint.put("serviceUrl", Map.class);
        PropertiesUtils.setBeanPropertyValue((Object)eurekaClientConfig, (Properties)eurekaProps, propertyTypeHint);
        CloudEurekaClient eurekaClient = new CloudEurekaClient(applicationInfoManager, (EurekaClientConfig)eurekaClientConfig, null, (ApplicationEventPublisher)applicationContext);
        SimpleObjectProvider healthCheckHandler = new SimpleObjectProvider(null);
        EurekaRegistration eurekaRegistration = EurekaRegistration.builder((CloudEurekaInstanceConfig)eurekaInstanceConfig).with(applicationInfoManager).with((ObjectProvider)healthCheckHandler).with((EurekaClient)eurekaClient).build();
        EurekaServiceRegistry serviceRegistry = new EurekaServiceRegistry();
        String registerCenter = eurekaProps.getProperty("register-center");
        if (registerCenter == null) {
            registerCenter = (String)eurekaClientConfig.getServiceUrl().get("defaultZone");
        }
        return new FizzEurekaServiceRegistration(registerCenter, eurekaRegistration, serviceRegistry, eurekaClient);
    }
}

