/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.service_registry.eureka;

import com.fizzgate.service_registry.FizzServiceRegistration;
import com.fizzgate.util.Utils;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.netflix.eureka.CloudEurekaClient;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaServiceRegistry;
import org.springframework.util.CollectionUtils;

public class FizzEurekaServiceRegistration
extends FizzServiceRegistration {
    private final CloudEurekaClient client;
    private final long renewalInterval;
    private long prevHeartbeatTimestamp = -1L;

    public FizzEurekaServiceRegistration(String id, EurekaRegistration registration, EurekaServiceRegistry serviceRegistry, CloudEurekaClient client) {
        super(id, FizzServiceRegistration.Type.EUREKA, (Registration)registration, (ServiceRegistry)serviceRegistry);
        this.client = client;
        this.renewalInterval = (long)this.client.getApplicationInfoManager().getInfo().getLeaseInfo().getRenewalIntervalInSecs() * 1000L;
    }

    public DiscoveryClient getDiscoveryClient() {
        return this.client;
    }

    @Override
    protected void shutdownClient() {
        this.client.shutdown();
        LOGGER.info("shutdown {} client", (Object)this.id);
    }

    @Override
    public FizzServiceRegistration.ServerStatus getServerStatus() {
        EurekaClientConfig eurekaClientConfig = this.client.getEurekaClientConfig();
        List eurekaServerServiceUrls = eurekaClientConfig.getEurekaServerServiceUrls("defaultZone");
        HashMap<String, Integer> registryCenterVip2port = new HashMap<String, Integer>();
        for (Object serviceUrl : eurekaServerServiceUrls) {
            int port;
            String vip;
            int at = ((String)serviceUrl).indexOf(64);
            if (at > -1) {
                int slash;
                int colon = ((String)serviceUrl).indexOf(58, at);
                if (colon > -1) {
                    slash = ((String)serviceUrl).indexOf(47, colon);
                    vip = ((String)serviceUrl).substring(at + 1, colon);
                    port = Integer.parseInt(((String)serviceUrl).substring(colon + 1, slash));
                } else {
                    slash = ((String)serviceUrl).indexOf(47, at);
                    vip = ((String)serviceUrl).substring(at + 1, slash);
                    port = 80;
                }
            } else {
                int slash;
                int begin = ((String)serviceUrl).indexOf(47) + 2;
                int colon = ((String)serviceUrl).indexOf(58, begin);
                if (colon > -1) {
                    slash = ((String)serviceUrl).indexOf(47, colon);
                    vip = ((String)serviceUrl).substring(begin, colon);
                    port = Integer.parseInt(((String)serviceUrl).substring(colon + 1, slash));
                } else {
                    slash = ((String)serviceUrl).indexOf(47, begin);
                    vip = ((String)serviceUrl).substring(begin, slash);
                    port = 80;
                }
            }
            registryCenterVip2port.put(vip, port);
        }
        boolean f = false;
        for (Application registeredApplication : this.client.getApplications().getRegisteredApplications()) {
            List instances = registeredApplication.getInstances();
            for (InstanceInfo instance : instances) {
                int p;
                String vipAddress = instance.getVIPAddress();
                String ipAddr = instance.getIPAddr();
                Integer port = (Integer)registryCenterVip2port.get(vipAddress);
                if (port == null) {
                    port = (Integer)registryCenterVip2port.get(ipAddr);
                }
                if (port == null || (p = instance.getPort()) != port) continue;
                f = true;
                break;
            }
            if (!f) continue;
            for (InstanceInfo instance : instances) {
                InstanceInfo.InstanceStatus status = instance.getStatus();
                if (status == InstanceInfo.InstanceStatus.UP) continue;
                return this.transfrom(status);
            }
            return this.transfrom(InstanceInfo.InstanceStatus.UP);
        }
        long heartbeatTimestamp = this.client.getStats().lastSuccessfulHeartbeatTimestampMs();
        if (heartbeatTimestamp == -1L) {
            return this.transfrom(InstanceInfo.InstanceStatus.STARTING);
        }
        if (heartbeatTimestamp > this.prevHeartbeatTimestamp) {
            this.prevHeartbeatTimestamp = heartbeatTimestamp;
            return this.transfrom(InstanceInfo.InstanceStatus.UP);
        }
        long duration = this.prevHeartbeatTimestamp + this.renewalInterval;
        if (System.currentTimeMillis() > duration) {
            LOGGER.warn("unknown eureka {} status", (Object)this.getId());
            return this.transfrom(InstanceInfo.InstanceStatus.UNKNOWN);
        }
        return this.transfrom(InstanceInfo.InstanceStatus.UP);
    }

    private FizzServiceRegistration.ServerStatus transfrom(InstanceInfo.InstanceStatus status) {
        if (status == InstanceInfo.InstanceStatus.UP) {
            return FizzServiceRegistration.ServerStatus.UP;
        }
        if (status == InstanceInfo.InstanceStatus.DOWN) {
            return FizzServiceRegistration.ServerStatus.DOWN;
        }
        if (status == InstanceInfo.InstanceStatus.OUT_OF_SERVICE) {
            return FizzServiceRegistration.ServerStatus.OUT_OF_SERVICE;
        }
        if (status == InstanceInfo.InstanceStatus.STARTING) {
            return FizzServiceRegistration.ServerStatus.STARTING;
        }
        return FizzServiceRegistration.ServerStatus.UNKNOWN;
    }

    @Override
    public List<String> getServices() {
        List registeredApplications = this.client.getApplications().getRegisteredApplications();
        if (registeredApplications.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> services = new ArrayList<String>(registeredApplications.size());
        for (Application app : registeredApplications) {
            services.add(app.getName().toLowerCase());
        }
        return services;
    }

    @Override
    public String getInstance(String service) {
        InstanceInfo inst = this.getInstanceInfo(service);
        return inst.getIPAddr() + ':' + inst.getPort();
    }

    public InstanceInfo getInstanceInfo(String service) {
        List insts = this.client.getInstancesByVipAddress(service, false);
        if (CollectionUtils.isEmpty((Collection)insts)) {
            throw Utils.runtimeExceptionWithoutStack((String)(this.getId() + " eureka no " + service));
        }
        Applications apps = this.client.getApplications();
        int index = (int)(apps.getNextIndex(service.toUpperCase(), false).incrementAndGet() % (long)insts.size());
        return (InstanceInfo)insts.get(index);
    }
}

