/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.service_registry.nacos;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.registry.NacosRegistration;
import com.alibaba.cloud.nacos.registry.NacosServiceRegistry;
import com.alibaba.nacos.api.naming.NamingService;
import com.fizzgate.service_registry.nacos.FizzNacosProperties;
import com.fizzgate.service_registry.nacos.FizzNacosServiceRegistration;
import com.fizzgate.util.PropertiesUtils;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public abstract class FizzNacosHelper {
    private static final int ndl = "nacos.discovery.".length();

    private FizzNacosHelper() {
    }

    public static FizzNacosServiceRegistration getServiceRegistration(ApplicationContext applicationContext, Properties nacosProperties) {
        String ip;
        Properties ps = new Properties();
        nacosProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(n, propertyValue) -> {
            String propertyName = (String)n;
            if (propertyName.endsWith("username")) {
                ps.put("username", propertyValue);
            } else if (propertyName.endsWith("password")) {
                ps.put("password", propertyValue);
            } else {
                String pn = propertyName.substring(ndl);
                if (pn.indexOf(45) > -1) {
                    pn = PropertiesUtils.normalize((String)pn);
                }
                ps.put(pn, propertyValue);
            }
        }));
        FizzNacosProperties fizzNacosProperties = new FizzNacosProperties(ps);
        PropertiesUtils.setBeanPropertyValue((Object)((Object)fizzNacosProperties), (Properties)ps);
        fizzNacosProperties.setApplicationContext(applicationContext);
        if (fizzNacosProperties.getId() == null) {
            String group;
            String id = fizzNacosProperties.getServerAddr();
            String namespace = fizzNacosProperties.getNamespace();
            if (StringUtils.isNotBlank((CharSequence)namespace)) {
                id = id + '_' + namespace;
            }
            if (StringUtils.isNotBlank((CharSequence)(group = fizzNacosProperties.getGroup()))) {
                id = id + '_' + group;
            }
            fizzNacosProperties.setId(id);
        }
        Environment env = applicationContext.getEnvironment();
        if (fizzNacosProperties.getService() == null) {
            fizzNacosProperties.setService(env.getProperty("spring.application.name"));
        }
        if (StringUtils.isBlank((CharSequence)(ip = fizzNacosProperties.getIp()))) {
            ip = System.getProperty("nacos.discovery.ip");
            if (StringUtils.isBlank((CharSequence)ip)) {
                ip = System.getenv("nacos.discovery.ip");
            }
            if (StringUtils.isNotBlank((CharSequence)ip)) {
                fizzNacosProperties.setIp(ip);
            }
        }
        if (fizzNacosProperties.getPort() == -1) {
            fizzNacosProperties.setPort(Integer.parseInt(env.getProperty("server.port")));
        }
        fizzNacosProperties.setNamingLoadCacheAtStart("false");
        fizzNacosProperties.init();
        NacosServiceManager nacosServiceManager = new NacosServiceManager();
        NacosServiceRegistry nacosServiceRegistry = new NacosServiceRegistry(nacosServiceManager, (NacosDiscoveryProperties)fizzNacosProperties);
        NacosRegistration nacosRegistration = new NacosRegistration(null, (NacosDiscoveryProperties)fizzNacosProperties, applicationContext);
        Properties nps = fizzNacosProperties.getNacosProperties();
        NamingService namingService = nacosServiceManager.getNamingService(nps);
        return new FizzNacosServiceRegistration(fizzNacosProperties.getId(), nacosRegistration, nacosServiceRegistry, namingService);
    }
}

