/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.service_registry.nacos;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class FizzNacosProperties
extends NacosDiscoveryProperties {
    private ApplicationContext applicationContext;
    private String id;
    private String serverAddr;
    private String username = "";
    private String password = "";
    private String endpoint = "";
    private String namespace;
    private long watchDelay = 30000L;
    private String logName = "";
    private String service;
    private float weight = 1.0f;
    private String clusterName = "DEFAULT";
    private String group = "DEFAULT_GROUP";
    private String namingLoadCacheAtStart = "false";
    private Map<String, String> metadata = new HashMap<String, String>();
    private boolean registerEnabled = true;
    private String ip;
    private String networkInterface = "";
    private int port = -1;
    private boolean secure = false;
    private String accessKey = "";
    private String secretKey = "";
    private Integer heartBeatInterval;
    private Integer heartBeatTimeout;
    private Integer ipDeleteTimeout;
    private boolean instanceEnabled = true;
    private boolean ephemeral = true;
    private boolean failFast = true;
    private boolean init = false;
    private Properties config;

    public FizzNacosProperties(Properties config) {
        this.config = config;
    }

    public void init() {
        if (this.init) {
            return;
        }
        this.metadata.put("preserved.register.source", "SPRING_CLOUD");
        if (this.secure) {
            this.metadata.put("secure", "true");
        }
        this.serverAddr = Objects.toString(this.serverAddr, "");
        if (this.serverAddr.endsWith("/")) {
            this.serverAddr = this.serverAddr.substring(0, this.serverAddr.length() - 1);
        }
        this.endpoint = Objects.toString(this.endpoint, "");
        this.namespace = Objects.toString(this.namespace, "");
        this.logName = Objects.toString(this.logName, "");
        if (StringUtils.isEmpty((Object)this.ip)) {
            if (StringUtils.isEmpty((Object)this.networkInterface)) {
                InetUtils inetUtils = null;
                try {
                    inetUtils = (InetUtils)this.applicationContext.getBean(InetUtils.class);
                }
                catch (NoSuchBeanDefinitionException e) {
                    inetUtils = new InetUtils(new InetUtilsProperties());
                }
                this.ip = inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
            } else {
                NetworkInterface netInterface = null;
                try {
                    netInterface = NetworkInterface.getByName(this.networkInterface);
                }
                catch (SocketException e) {
                    throw new RuntimeException(e);
                }
                Enumeration<InetAddress> inetAddress = netInterface.getInetAddresses();
                while (inetAddress.hasMoreElements()) {
                    InetAddress currentAddress = inetAddress.nextElement();
                    if (!(currentAddress instanceof Inet4Address) || currentAddress.isLoopbackAddress()) continue;
                    this.ip = currentAddress.getHostAddress();
                    break;
                }
                if (StringUtils.isEmpty((Object)this.ip)) {
                    throw new RuntimeException("cannot find available ip from network interface " + this.networkInterface);
                }
            }
        }
        this.init = true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public void setRegisterEnabled(boolean registerEnabled) {
        this.registerEnabled = registerEnabled;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public Integer getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public void setHeartBeatInterval(Integer heartBeatInterval) {
        this.heartBeatInterval = heartBeatInterval;
    }

    public Integer getHeartBeatTimeout() {
        return this.heartBeatTimeout;
    }

    public void setHeartBeatTimeout(Integer heartBeatTimeout) {
        this.heartBeatTimeout = heartBeatTimeout;
    }

    public Integer getIpDeleteTimeout() {
        return this.ipDeleteTimeout;
    }

    public void setIpDeleteTimeout(Integer ipDeleteTimeout) {
        this.ipDeleteTimeout = ipDeleteTimeout;
    }

    public String getNamingLoadCacheAtStart() {
        return this.namingLoadCacheAtStart;
    }

    public void setNamingLoadCacheAtStart(String namingLoadCacheAtStart) {
        this.namingLoadCacheAtStart = namingLoadCacheAtStart;
    }

    public long getWatchDelay() {
        return this.watchDelay;
    }

    public void setWatchDelay(long watchDelay) {
        this.watchDelay = watchDelay;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isInstanceEnabled() {
        return this.instanceEnabled;
    }

    public void setInstanceEnabled(boolean instanceEnabled) {
        this.instanceEnabled = instanceEnabled;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public void setEphemeral(boolean ephemeral) {
        this.ephemeral = ephemeral;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FizzNacosProperties that = (FizzNacosProperties)((Object)o);
        return Objects.equals(this.serverAddr, that.serverAddr) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.logName, that.logName) && Objects.equals(this.service, that.service) && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.group, that.group) && Objects.equals(this.ip, that.ip) && Objects.equals(this.port, that.port) && Objects.equals(this.networkInterface, that.networkInterface) && Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.secretKey, that.secretKey) && Objects.equals(this.heartBeatInterval, that.heartBeatInterval) && Objects.equals(this.heartBeatTimeout, that.heartBeatTimeout) && Objects.equals(this.failFast, that.failFast) && Objects.equals(this.ipDeleteTimeout, that.ipDeleteTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.serverAddr, this.username, this.password, this.endpoint, this.namespace, this.watchDelay, this.logName, this.service, Float.valueOf(this.weight), this.clusterName, this.group, this.namingLoadCacheAtStart, this.registerEnabled, this.ip, this.networkInterface, this.port, this.secure, this.accessKey, this.secretKey, this.heartBeatInterval, this.heartBeatTimeout, this.ipDeleteTimeout, this.instanceEnabled, this.ephemeral, this.failFast);
    }

    public String toString() {
        return "FizzNacosProperties{serverAddr='" + this.serverAddr + '\'' + ", endpoint='" + this.endpoint + '\'' + ", namespace='" + this.namespace + '\'' + ", watchDelay=" + this.watchDelay + ", logName='" + this.logName + '\'' + ", service='" + this.service + '\'' + ", weight=" + this.weight + ", clusterName='" + this.clusterName + '\'' + ", group='" + this.group + '\'' + ", namingLoadCacheAtStart='" + this.namingLoadCacheAtStart + '\'' + ", metadata=" + this.metadata + ", registerEnabled=" + this.registerEnabled + ", ip='" + this.ip + '\'' + ", networkInterface='" + this.networkInterface + '\'' + ", port=" + this.port + ", secure=" + this.secure + ", accessKey='" + this.accessKey + '\'' + ", secretKey='" + this.secretKey + '\'' + ", heartBeatInterval=" + this.heartBeatInterval + ", heartBeatTimeout=" + this.heartBeatTimeout + ", ipDeleteTimeout=" + this.ipDeleteTimeout + ", failFast=" + this.failFast + '}';
    }

    public Properties getNacosProperties() {
        Properties properties = new Properties();
        properties.put("serverAddr", this.serverAddr);
        properties.put("username", Objects.toString(this.username, ""));
        properties.put("password", Objects.toString(this.password, ""));
        properties.put("namespace", this.namespace);
        properties.put("com.alibaba.nacos.naming.log.filename", this.logName);
        if (this.endpoint.contains(":")) {
            int index = this.endpoint.indexOf(":");
            properties.put("endpoint", this.endpoint.substring(0, index));
            properties.put("endpointPort", this.endpoint.substring(index + 1));
        } else {
            properties.put("endpoint", this.endpoint);
        }
        properties.put("accessKey", this.accessKey);
        properties.put("secretKey", this.secretKey);
        properties.put("clusterName", this.clusterName);
        properties.put("namingLoadCacheAtStart", this.namingLoadCacheAtStart);
        properties.put("enabled", (Object)true);
        properties.put("com.alibaba.nacos.naming.log.filename", "");
        this.config.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(c, v) -> {
            if (!properties.containsKey(c)) {
                properties.put(c, v);
            }
        }));
        return properties;
    }
}

