/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.service_registry.nacos;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.registry.NacosRegistration;
import com.alibaba.cloud.nacos.registry.NacosServiceRegistry;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.client.naming.cache.ServiceInfoHolder;
import com.alibaba.nacos.client.naming.core.ServerListManager;
import com.alibaba.nacos.client.naming.core.ServiceInfoUpdateService;
import com.alibaba.nacos.client.naming.remote.NamingClientProxyDelegate;
import com.alibaba.nacos.client.naming.remote.gprc.NamingGrpcClientProxy;
import com.alibaba.nacos.client.naming.remote.gprc.redo.NamingGrpcRedoService;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientProxy;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.remote.client.Connection;
import com.alibaba.nacos.common.remote.client.RpcClientStatus;
import com.alibaba.nacos.common.remote.client.grpc.GrpcClient;
import com.alibaba.nacos.common.utils.ThreadUtils;
import com.fizzgate.service_registry.FizzServiceRegistration;
import com.fizzgate.util.ReflectionUtils;
import com.fizzgate.util.Utils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.util.StringUtils;

public class FizzNacosServiceRegistration
extends FizzServiceRegistration {
    private NamingService namingService;
    private final String group;
    private List<String> clusters;
    private boolean useGroup;
    private boolean userCluster;

    public FizzNacosServiceRegistration(String id, NacosRegistration registration, NacosServiceRegistry serviceRegistry, NamingService namingService) {
        super(id, FizzServiceRegistration.Type.NACOS, (Registration)registration, (ServiceRegistry)serviceRegistry);
        String cluster;
        this.namingService = namingService;
        NacosDiscoveryProperties discoveryProperties = registration.getNacosDiscoveryProperties();
        this.group = discoveryProperties.getGroup();
        if (StringUtils.hasText((String)this.group)) {
            this.useGroup = true;
        }
        if (StringUtils.hasText((String)(cluster = discoveryProperties.getClusterName()))) {
            this.userCluster = true;
            this.clusters = Collections.singletonList(cluster);
        }
    }

    public NamingService getNamingService() {
        return this.namingService;
    }

    @Override
    public void close() {
        ServiceInfoHolder serviceInfoHolder = (ServiceInfoHolder)ReflectionUtils.get((Object)this.namingService, (String)"serviceInfoHolder");
        NamingClientProxyDelegate namingClientProxyDelegate = (NamingClientProxyDelegate)ReflectionUtils.get((Object)this.namingService, (String)"clientProxy");
        try {
            serviceInfoHolder.shutdown();
            ServiceInfoUpdateService serviceInfoUpdateService = (ServiceInfoUpdateService)ReflectionUtils.get((Object)namingClientProxyDelegate, (String)"serviceInfoUpdateService");
            serviceInfoUpdateService.shutdown();
            ServerListManager serverListManager = (ServerListManager)ReflectionUtils.get((Object)namingClientProxyDelegate, (String)"serverListManager");
            serverListManager.shutdown();
            NamingHttpClientProxy namingHttpClientProxy = (NamingHttpClientProxy)ReflectionUtils.get((Object)namingClientProxyDelegate, (String)"httpClientProxy");
            namingHttpClientProxy.shutdown();
            NamingGrpcClientProxy namingGrpcClientProxy = (NamingGrpcClientProxy)ReflectionUtils.get((Object)namingClientProxyDelegate, (String)"grpcClientProxy");
            GrpcClient grpcClient = (GrpcClient)ReflectionUtils.get((Object)namingGrpcClientProxy, (String)"rpcClient");
            AtomicReference rpcClientStatus = (AtomicReference)ReflectionUtils.get((Object)grpcClient, (String)"rpcClientStatus");
            rpcClientStatus.set(RpcClientStatus.SHUTDOWN);
            LOGGER.info("shutdown {} grpc client ,set status to shutdown", (Object)this.getId());
            ScheduledExecutorService clientEventExecutor = (ScheduledExecutorService)ReflectionUtils.get((Object)grpcClient, (String)"clientEventExecutor");
            clientEventExecutor.shutdownNow();
            LOGGER.info("shutdown {} client event executor {}", (Object)this.getId(), (Object)clientEventExecutor);
            Connection currentConnection = (Connection)ReflectionUtils.get((Object)grpcClient, (String)"currentConnection");
            if (currentConnection != null) {
                currentConnection.setAbandon(true);
                ReflectionUtils.invokeMethod((String)"closeConnection", (Object)grpcClient, (Class[])new Class[]{Connection.class}, (Object[])new Object[]{currentConnection});
                LOGGER.info("close {} current connection {}", (Object)this.getId(), (Object)currentConnection.getConnectionId());
            }
            NamingGrpcRedoService namingGrpcRedoService = (NamingGrpcRedoService)ReflectionUtils.get((Object)namingGrpcClientProxy, (String)"redoService");
            namingGrpcRedoService.shutdown();
            ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)ReflectionUtils.get((Object)namingClientProxyDelegate, (String)"executorService");
            ThreadUtils.shutdownThreadPool((ExecutorService)scheduledExecutorService, (Logger)LogUtils.NAMING_LOGGER);
            LOGGER.info("nacos {} client resource is closed", (Object)this.getId());
        }
        catch (Exception e) {
            LOGGER.error("nacos {} naming service shutdown exception", (Object)this.getId(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void shutdownClient() {
    }

    @Override
    public FizzServiceRegistration.ServerStatus getServerStatus() {
        String status = this.namingService.getServerStatus();
        return this.transfrom(status);
    }

    private FizzServiceRegistration.ServerStatus transfrom(String status) {
        if (status.equals("UP")) {
            return FizzServiceRegistration.ServerStatus.UP;
        }
        if (status.equals("DOWN")) {
            return FizzServiceRegistration.ServerStatus.DOWN;
        }
        LOGGER.warn("nacos {} status is {}", (Object)this.getId(), (Object)status);
        return FizzServiceRegistration.ServerStatus.UNKNOWN;
    }

    @Override
    public List<String> getServices() {
        try {
            ListView servicesOfServer = this.useGroup ? this.namingService.getServicesOfServer(1, Integer.MAX_VALUE, this.group) : this.namingService.getServicesOfServer(1, Integer.MAX_VALUE);
            return servicesOfServer.getData();
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getInstance(String service) {
        Instance instance = this.getInstanceInfo(service);
        return instance.getIp() + ':' + instance.getPort();
    }

    public Instance getInstanceInfo(String service) {
        Instance instance = null;
        try {
            instance = this.useGroup && this.userCluster ? this.namingService.selectOneHealthyInstance(service, this.group, this.clusters) : (this.useGroup ? this.namingService.selectOneHealthyInstance(service, this.group) : (this.userCluster ? this.namingService.selectOneHealthyInstance(service, this.clusters) : this.namingService.selectOneHealthyInstance(service)));
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
        if (instance == null) {
            throw Utils.runtimeExceptionWithoutStack((String)(this.getId() + " nacos no " + service));
        }
        return instance;
    }
}

