/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.stats;

import com.fizzgate.stats.BlockType;
import com.fizzgate.stats.IncrRequestResult;
import com.fizzgate.stats.ResourceConfig;
import com.fizzgate.stats.ResourceStat;
import com.fizzgate.stats.ResourceTimeWindowStat;
import com.fizzgate.stats.TimeSlot;
import com.fizzgate.stats.TimeWindowStat;
import com.fizzgate.stats.circuitbreaker.CircuitBreakManager;
import com.fizzgate.stats.circuitbreaker.CircuitBreaker;
import com.fizzgate.util.ResourceIdUtils;
import com.fizzgate.util.WebUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;

public class FlowStat {
    private static final Logger log = LoggerFactory.getLogger(FlowStat.class);
    public static long INTERVAL = 1000L;
    public boolean cleanResource = true;
    public boolean createTimeSlotOnlyTraffic = true;
    public ConcurrentMap<String, ResourceStat> resourceStats = new ConcurrentHashMap<String, ResourceStat>(256);
    public static long RETENTION_TIME_IN_MINUTES = 5L;
    private ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private Lock w = this.rwl.writeLock();
    private ExecutorService pool = Executors.newFixedThreadPool(2);
    private CircuitBreakManager circuitBreakManager;

    public FlowStat() {
        this.runScheduleJob();
    }

    public FlowStat(boolean cleanResource, boolean createTimeSlotOnlyTraffic) {
        this.cleanResource = cleanResource;
        this.createTimeSlotOnlyTraffic = createTimeSlotOnlyTraffic;
        this.runScheduleJob();
    }

    public FlowStat(CircuitBreakManager circuitBreakManager) {
        this.circuitBreakManager = circuitBreakManager;
        this.runScheduleJob();
    }

    public void setCircuitBreakManager(CircuitBreakManager circuitBreakManager) {
        this.circuitBreakManager = circuitBreakManager;
    }

    private void runScheduleJob() {
        this.pool.submit(new HousekeepJob(this));
        this.pool.submit(new PeakConcurrentJob(this));
    }

    public void updateRetentionTime(int retentionTimeInMinutes) {
        RETENTION_TIME_IN_MINUTES = retentionTimeInMinutes;
    }

    public long currentTimeSlotId() {
        return System.currentTimeMillis() / INTERVAL * INTERVAL;
    }

    public long getTimeSlotId(long timeMilli) {
        return System.currentTimeMillis() / INTERVAL * INTERVAL;
    }

    public IncrRequestResult incrRequest(List<ResourceConfig> resourceConfigs, long curTimeSlotId) {
        return this.incrRequest(resourceConfigs, curTimeSlotId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrRequestResult incrRequest(List<ResourceConfig> resourceConfigs, long curTimeSlotId, BiFunction<ResourceConfig, List<ResourceConfig>, List<ResourceConfig>> totalBlockFunc) {
        if (resourceConfigs == null || resourceConfigs.size() == 0) {
            return null;
        }
        this.w.lock();
        try {
            for (ResourceConfig resourceConfig : resourceConfigs) {
                List<ResourceConfig> parentResCfgs;
                long total;
                long n;
                long maxCon = resourceConfig.getMaxCon();
                long maxQPS = resourceConfig.getMaxQPS();
                if (maxCon <= 0L && maxQPS <= 0L) continue;
                ResourceStat resourceStat = this.getResourceStat(resourceConfig.getResourceId());
                if (maxCon > 0L && (n = (long)resourceStat.getConcurrentRequests().get()) >= maxCon) {
                    Object parentResCfgs2;
                    resourceStat.incrBlockRequestToTimeSlot(curTimeSlotId);
                    if (totalBlockFunc != null && (parentResCfgs2 = totalBlockFunc.apply(resourceConfig, resourceConfigs)) != null && parentResCfgs2.size() > 0) {
                        Iterator iterator = parentResCfgs2.iterator();
                        while (iterator.hasNext()) {
                            ResourceConfig pResCfg = (ResourceConfig)iterator.next();
                            this.getResourceStat(pResCfg.getResourceId()).incrTotalBlockRequestToTimeSlot(curTimeSlotId);
                        }
                    }
                    parentResCfgs2 = IncrRequestResult.block(resourceConfig.getResourceId(), BlockType.CONCURRENT_REQUEST);
                    return parentResCfgs2;
                }
                if (maxQPS <= 0L || (total = (long)resourceStat.getTimeSlot(curTimeSlotId).getCounter()) < maxQPS) continue;
                resourceStat.incrBlockRequestToTimeSlot(curTimeSlotId);
                if (totalBlockFunc != null && (parentResCfgs = totalBlockFunc.apply(resourceConfig, resourceConfigs)) != null && parentResCfgs.size() > 0) {
                    for (ResourceConfig pResCfg : parentResCfgs) {
                        this.getResourceStat(pResCfg.getResourceId()).incrTotalBlockRequestToTimeSlot(curTimeSlotId);
                    }
                }
                IncrRequestResult incrRequestResult = IncrRequestResult.block(resourceConfig.getResourceId(), BlockType.QPS);
                return incrRequestResult;
            }
            for (ResourceConfig resourceConfig : resourceConfigs) {
                ResourceStat resourceStat = this.getResourceStat(resourceConfig.getResourceId());
                int cons = resourceStat.getConcurrentRequests().incrementAndGet();
                resourceStat.getTimeSlot(curTimeSlotId).updatePeakConcurrentReqeusts(cons);
                resourceStat.getTimeSlot(curTimeSlotId).incr();
            }
            IncrRequestResult incrRequestResult = IncrRequestResult.success();
            return incrRequestResult;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrRequestResult incrRequest(ServerWebExchange exchange, List<ResourceConfig> resourceConfigs, long curTimeSlotId, BiFunction<ResourceConfig, List<ResourceConfig>, List<ResourceConfig>> totalBlockFunc) {
        if (resourceConfigs == null || resourceConfigs.size() == 0) {
            return null;
        }
        this.w.lock();
        try {
            ResourceStat resourceStat;
            for (ResourceConfig resourceConfig : resourceConfigs) {
                List<ResourceConfig> parentResCfgs;
                long total;
                long n;
                long maxCon = resourceConfig.getMaxCon();
                long maxQPS = resourceConfig.getMaxQPS();
                if (maxCon <= 0L && maxQPS <= 0L) continue;
                resourceStat = this.getResourceStat(resourceConfig.getResourceId());
                if (maxCon > 0L && (n = (long)resourceStat.getConcurrentRequests().get()) >= maxCon) {
                    Object parentResCfgs2;
                    resourceStat.incrBlockRequestToTimeSlot(curTimeSlotId);
                    if (totalBlockFunc != null && (parentResCfgs2 = totalBlockFunc.apply(resourceConfig, resourceConfigs)) != null && parentResCfgs2.size() > 0) {
                        Iterator iterator = parentResCfgs2.iterator();
                        while (iterator.hasNext()) {
                            ResourceConfig pResCfg = (ResourceConfig)iterator.next();
                            this.getResourceStat(pResCfg.getResourceId()).incrTotalBlockRequestToTimeSlot(curTimeSlotId);
                        }
                    }
                    parentResCfgs2 = IncrRequestResult.block(resourceConfig.getResourceId(), BlockType.CONCURRENT_REQUEST);
                    return parentResCfgs2;
                }
                if (maxQPS <= 0L || (total = (long)resourceStat.getTimeSlot(curTimeSlotId).getCounter()) < maxQPS) continue;
                resourceStat.incrBlockRequestToTimeSlot(curTimeSlotId);
                if (totalBlockFunc != null && (parentResCfgs = totalBlockFunc.apply(resourceConfig, resourceConfigs)) != null && parentResCfgs.size() > 0) {
                    for (ResourceConfig pResCfg : parentResCfgs) {
                        this.getResourceStat(pResCfg.getResourceId()).incrTotalBlockRequestToTimeSlot(curTimeSlotId);
                    }
                }
                IncrRequestResult incrRequestResult = IncrRequestResult.block(resourceConfig.getResourceId(), BlockType.QPS);
                return incrRequestResult;
            }
            for (ResourceConfig resourceConfig : resourceConfigs) {
                this.getResourceStat(resourceConfig.getResourceId());
            }
            String service = WebUtils.getClientService(exchange);
            String path = WebUtils.getClientReqPath(exchange);
            String resource = ResourceIdUtils.buildResourceId(null, null, null, service, path);
            boolean permit = this.circuitBreakManager.permit(exchange, curTimeSlotId, this, service, path);
            if (!permit) {
                IncrRequestResult incrRequestResult = IncrRequestResult.block(resource, BlockType.CIRCUIT_BREAK);
                return incrRequestResult;
            }
            for (ResourceConfig resourceConfig : resourceConfigs) {
                resourceStat = this.getResourceStat(resourceConfig.getResourceId());
                int cons = resourceStat.getConcurrentRequests().incrementAndGet();
                resourceStat.getTimeSlot(curTimeSlotId).updatePeakConcurrentReqeusts(cons);
                resourceStat.getTimeSlot(curTimeSlotId).incr();
            }
            IncrRequestResult incrRequestResult = IncrRequestResult.success();
            return incrRequestResult;
        }
        finally {
            this.w.unlock();
        }
    }

    public void addRequestRT(List<ResourceConfig> resourceConfigs, long timeSlotId, long rt, boolean isSuccess, HttpStatus statusCode) {
        if (resourceConfigs == null || resourceConfigs.size() == 0) {
            return;
        }
        for (int i = resourceConfigs.size() - 1; i >= 0; --i) {
            ResourceStat resourceStat = this.getResourceStat(resourceConfigs.get(i).getResourceId());
            resourceStat.decrConcurrentRequest(timeSlotId);
            resourceStat.addRequestRT(timeSlotId, rt, isSuccess);
            if (statusCode.is2xxSuccessful()) {
                resourceStat.incr2xxStatusCount(timeSlotId);
                continue;
            }
            if (statusCode.is4xxClientError()) {
                resourceStat.incr4xxStatusCount(timeSlotId);
                continue;
            }
            if (statusCode.is5xxServerError()) {
                resourceStat.incr5xxStatusCount(timeSlotId);
                continue;
            }
            if (statusCode != HttpStatus.GATEWAY_TIMEOUT) continue;
            resourceStat.incr504StatusCount(timeSlotId);
        }
    }

    public boolean incrRequest(String resourceId, long curTimeSlotId, Long maxCon, Long maxRPS) {
        ResourceStat resourceStat = this.getResourceStat(resourceId);
        boolean success = resourceStat.incrConcurrentRequest(curTimeSlotId, maxCon);
        if (success) {
            success = resourceStat.incrRequestToTimeSlot(curTimeSlotId, maxRPS);
        }
        return success;
    }

    public void decrConcurrentRequest(String resourceId, long timeSlotId) {
        if (resourceId == null) {
            return;
        }
        ResourceStat resourceStat = this.getResourceStat(resourceId);
        long conns = resourceStat.getConcurrentRequests().get();
        resourceStat.decrConcurrentRequest(timeSlotId);
    }

    public void addRequestRT(String resourceId, long timeSlotId, long rt, boolean isSuccess) {
        if (resourceId == null) {
            return;
        }
        ResourceStat resourceStat = this.getResourceStat(resourceId);
        resourceStat.addRequestRT(timeSlotId, rt, isSuccess);
    }

    public ResourceStat getResourceStat(String resourceId) {
        ResourceStat resourceStat = null;
        if (this.resourceStats.containsKey(resourceId)) {
            resourceStat = (ResourceStat)this.resourceStats.get(resourceId);
        } else {
            resourceStat = new ResourceStat(resourceId);
            ResourceStat rs = this.resourceStats.putIfAbsent(resourceId, resourceStat);
            if (rs != null) {
                resourceStat = rs;
            }
        }
        return resourceStat;
    }

    public long getConcurrentRequests(String resourceId) {
        ResourceStat resourceStat = this.getResourceStat(resourceId);
        return resourceStat.getConcurrentRequests().get();
    }

    public TimeWindowStat getCurrentTimeWindowStat(String resourceId) {
        long startTimeMilli = this.currentTimeSlotId();
        return this.getTimeWindowStat(resourceId, startTimeMilli, startTimeMilli + 1000L);
    }

    private TimeWindowStat getCurrentTimeWindowStat(String resourceId, long curTimeSlotId) {
        return this.getTimeWindowStat(resourceId, curTimeSlotId, curTimeSlotId + 1000L);
    }

    public TimeWindowStat getPreviousSecondStat(String resourceId, long timeMilli) {
        long endTimeMilli = timeMilli / INTERVAL * INTERVAL;
        return this.getTimeWindowStat(resourceId, endTimeMilli - 1000L, endTimeMilli);
    }

    public TimeWindowStat getTimeWindowStat(String resourceId, long startTimeMilli, long endTimeMilli) {
        long startSlotId = startTimeMilli / INTERVAL * INTERVAL;
        long endSlotId = endTimeMilli / INTERVAL * INTERVAL;
        if (startSlotId == endSlotId) {
            endSlotId += INTERVAL;
        }
        if (this.resourceStats.containsKey(resourceId)) {
            ResourceStat resourceStat = (ResourceStat)this.resourceStats.get(resourceId);
            return resourceStat.getTimeWindowStat(startSlotId, endSlotId);
        }
        return null;
    }

    public List<ResourceTimeWindowStat> getResourceTimeWindowStats(String resourceId, long startTimeMilli, long endTimeMilli) {
        return this.getResourceTimeWindowStats(resourceId, startTimeMilli, endTimeMilli, 1L);
    }

    public List<ResourceTimeWindowStat> getResourceTimeWindowStats(String resourceId, long startTimeMilli, long endTimeMilli, long slotIntervalInSec) {
        ArrayList<ResourceTimeWindowStat> list = new ArrayList<ResourceTimeWindowStat>();
        long startSlotId = startTimeMilli / INTERVAL * INTERVAL;
        long endSlotId = endTimeMilli / INTERVAL * INTERVAL;
        if (startSlotId == endSlotId) {
            endSlotId += INTERVAL;
        }
        if (slotIntervalInSec < 1L || (endSlotId - startSlotId) / 1000L < slotIntervalInSec) {
            return list;
        }
        long slotInterval = slotIntervalInSec * 1000L;
        if (resourceId == null) {
            Set entrys = this.resourceStats.entrySet();
            for (Map.Entry entry : entrys) {
                String rid = (String)entry.getKey();
                ResourceTimeWindowStat resourceWin = new ResourceTimeWindowStat(rid);
                long start = startSlotId;
                for (long end = startSlotId + slotInterval; end <= endSlotId; end += slotInterval) {
                    TimeWindowStat tws = this.getTimeWindowStat(rid, start, end);
                    if (tws != null) {
                        resourceWin.getWindows().add(tws);
                    }
                    start += slotInterval;
                }
                if (resourceWin.getWindows().size() <= 0) continue;
                list.add(resourceWin);
            }
        } else {
            ResourceTimeWindowStat resourceWin = new ResourceTimeWindowStat(resourceId);
            long start = startSlotId;
            for (long end = startSlotId + slotInterval; end <= endSlotId; end += slotInterval) {
                TimeWindowStat tws = this.getTimeWindowStat(resourceId, start, end);
                if (tws != null) {
                    resourceWin.getWindows().add(tws);
                }
                start += slotInterval;
            }
            if (resourceWin.getWindows().size() > 0) {
                list.add(resourceWin);
            }
        }
        return list;
    }

    class PeakConcurrentJob
    implements Runnable {
        private FlowStat stat;

        public PeakConcurrentJob(FlowStat stat) {
            this.stat = stat;
        }

        @Override
        public void run() {
            Long lastTimeSlotId = null;
            while (true) {
                long curTimeSlotId = this.stat.currentTimeSlotId();
                if (lastTimeSlotId == null || lastTimeSlotId != curTimeSlotId) {
                    Set entrys = this.stat.resourceStats.entrySet();
                    for (Map.Entry entry : entrys) {
                        CircuitBreaker cb;
                        String resource = (String)entry.getKey();
                        ResourceStat resourceStat = (ResourceStat)entry.getValue();
                        if (FlowStat.this.createTimeSlotOnlyTraffic && resourceStat.getConcurrentRequests().get() > 0) {
                            resourceStat.getTimeSlot(curTimeSlotId);
                        } else {
                            resourceStat.getTimeSlot(curTimeSlotId);
                        }
                        if ((cb = FlowStat.this.circuitBreakManager.getCircuitBreaker(resource)) == null) continue;
                        cb.correctState(curTimeSlotId, this.stat);
                    }
                    lastTimeSlotId = curTimeSlotId;
                }
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (Exception e) {
                    log.error("PeakConcurrentJob error", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class HousekeepJob
    implements Runnable {
        private FlowStat stat;

        public HousekeepJob(FlowStat stat) {
            this.stat = stat;
        }

        @Override
        public void run() {
            long n = RETENTION_TIME_IN_MINUTES * 60L * 1000L / INTERVAL * INTERVAL;
            long lastSlotId = this.stat.currentTimeSlotId() - n;
            while (true) {
                long slotId = this.stat.currentTimeSlotId() - n;
                for (long i = lastSlotId; i < slotId; i += INTERVAL) {
                    Set entrys = this.stat.resourceStats.entrySet();
                    for (Map.Entry entry : entrys) {
                        String resourceId = (String)entry.getKey();
                        ConcurrentMap<Long, TimeSlot> timeSlots = ((ResourceStat)entry.getValue()).getTimeSlots();
                        timeSlots.remove(i);
                    }
                }
                lastSlotId = slotId;
                if (FlowStat.this.cleanResource) {
                    long currentTimeSlot = this.stat.currentTimeSlotId();
                    long startTimeSlot = currentTimeSlot - n;
                    for (Map.Entry entry : this.stat.resourceStats.entrySet()) {
                        String resource = (String)entry.getKey();
                        if (ResourceIdUtils.NODE_RESOURCE.equals(resource)) continue;
                        ResourceStat resourceStat = (ResourceStat)entry.getValue();
                        boolean noTraffic = true;
                        for (long timeSlot = startTimeSlot; timeSlot < currentTimeSlot; timeSlot += INTERVAL) {
                            int reqCnt = resourceStat.getTimeSlot(timeSlot).getCounter();
                            if (reqCnt <= 0) continue;
                            noTraffic = false;
                            break;
                        }
                        if (!noTraffic) continue;
                        this.stat.resourceStats.remove(resource);
                        log.info("HousekeepJob remove {}", (Object)resource);
                    }
                }
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (Exception e) {
                    log.error("HouseKeepJob error", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

