/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.stats;

import com.fizzgate.stats.FlowStat;
import com.fizzgate.stats.TimeSlot;
import com.fizzgate.stats.TimeWindowStat;
import com.fizzgate.stats.circuitbreaker.CircuitBreaker;
import java.math.BigDecimal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStat {
    private static final Logger log = LoggerFactory.getLogger(ResourceStat.class);
    private String resourceId;
    private ConcurrentMap<Long, TimeSlot> timeSlots = new ConcurrentHashMap<Long, TimeSlot>(256);
    private AtomicInteger concurrentRequests = new AtomicInteger(0);
    private ReentrantReadWriteLock rwl1 = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock rwl2 = new ReentrantReadWriteLock();
    private Lock w1 = this.rwl1.writeLock();
    private Lock w2 = this.rwl2.writeLock();

    public ResourceStat(String resourceId) {
        this.resourceId = resourceId;
    }

    public TimeSlot getTimeSlot(long timeSlotId) {
        if (this.timeSlots.containsKey(timeSlotId)) {
            return (TimeSlot)this.timeSlots.get(timeSlotId);
        }
        TimeSlot timeSlot = new TimeSlot(timeSlotId);
        timeSlot.setPeakConcurrentRequests(this.concurrentRequests.get());
        TimeSlot old = this.timeSlots.putIfAbsent(timeSlotId, timeSlot);
        if (old != null) {
            return old;
        }
        return timeSlot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean incrConcurrentRequest(long timeSlotId, Long maxCon) {
        this.w1.lock();
        try {
            boolean isExceeded = false;
            if (maxCon != null && maxCon.intValue() > 0) {
                int n = this.concurrentRequests.get();
                if ((long)n >= maxCon) {
                    isExceeded = true;
                    this.incrBlockRequestToTimeSlot(timeSlotId);
                } else {
                    int conns = this.concurrentRequests.incrementAndGet();
                    this.getTimeSlot(timeSlotId).updatePeakConcurrentReqeusts(conns);
                }
            } else {
                int conns = this.concurrentRequests.incrementAndGet();
                this.getTimeSlot(timeSlotId).updatePeakConcurrentReqeusts(conns);
            }
            boolean bl = !isExceeded;
            return bl;
        }
        finally {
            this.w1.unlock();
        }
    }

    public void decrConcurrentRequest(long timeSlotId) {
        int conns = this.concurrentRequests.decrementAndGet();
        this.getTimeSlot(timeSlotId).updatePeakConcurrentReqeusts(conns);
    }

    public void incrBlockRequestToTimeSlot(long timeSlotId) {
        this.getTimeSlot(timeSlotId).incrBlockRequests();
    }

    public void incrTotalBlockRequestToTimeSlot(long timeSlotId) {
        this.getTimeSlot(timeSlotId).incrTotalBlockRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean incrRequestToTimeSlot(long timeSlotId, Long maxRPS) {
        this.w2.lock();
        try {
            boolean isExceeded = false;
            if (maxRPS != null && maxRPS.intValue() > 0) {
                long max;
                long total = this.getTimeSlot(timeSlotId).getCounter();
                if (total >= (max = Long.valueOf(maxRPS).longValue())) {
                    isExceeded = true;
                    this.incrBlockRequestToTimeSlot(timeSlotId);
                    this.decrConcurrentRequest(timeSlotId);
                } else {
                    this.getTimeSlot(timeSlotId).incr();
                }
            } else {
                this.getTimeSlot(timeSlotId).incr();
            }
            boolean bl = !isExceeded;
            return bl;
        }
        finally {
            this.w2.unlock();
        }
    }

    public void updateCircuitBreakState(long timeSlot, CircuitBreaker.State current, CircuitBreaker.State target) {
        this.getTimeSlot(timeSlot).getCircuitBreakState().compareAndSet(current, target);
    }

    public void incrCircuitBreakNum(long timeSlot) {
        this.getTimeSlot(timeSlot).incrCircuitBreakNum();
    }

    public void incr2xxStatusCount(long timeSlot) {
        this.getTimeSlot(timeSlot).get2xxStatusCount().incrementAndGet();
    }

    public void incr4xxStatusCount(long timeSlot) {
        this.getTimeSlot(timeSlot).get4xxStatusCount().incrementAndGet();
    }

    public void incr5xxStatusCount(long timeSlot) {
        this.getTimeSlot(timeSlot).get5xxStatusCount().incrementAndGet();
    }

    public void incr504StatusCount(long timeSlot) {
        this.getTimeSlot(timeSlot).get504StatusCount().incrementAndGet();
    }

    public void addRequestRT(long timeSlotId, long rt, boolean isSuccess) {
        this.getTimeSlot(timeSlotId).addRequestRT(rt, isSuccess);
    }

    public TimeWindowStat getTimeWindowStat(long startSlotId, long endSlotId) {
        TimeWindowStat tws = new TimeWindowStat();
        tws.setStartTime(startSlotId);
        tws.setEndTime(endSlotId);
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        long totalReqs = 0L;
        long totalRt = 0L;
        long peakConcurrences = 0L;
        long peakRps = 0L;
        long errors = 0L;
        long blockReqs = 0L;
        long totalBlockReqs = 0L;
        long compReqs = 0L;
        int _2xxStatus = 0;
        int _4xxStatus = 0;
        int _5xxStatus = 0;
        int _504Status = 0;
        for (long i = startSlotId; i < endSlotId; i += FlowStat.INTERVAL) {
            if (!this.timeSlots.containsKey(i)) continue;
            TimeSlot timeSlot = (TimeSlot)this.timeSlots.get(i);
            min = timeSlot.getMin() < min ? timeSlot.getMin() : min;
            max = timeSlot.getMax() > max ? timeSlot.getMax() : max;
            peakConcurrences = timeSlot.getPeakConcurrentRequests() > peakConcurrences ? timeSlot.getPeakConcurrentRequests() : peakConcurrences;
            peakRps = (long)timeSlot.getCounter() > peakRps ? (long)timeSlot.getCounter() : peakRps;
            totalReqs += (long)timeSlot.getCounter();
            totalRt += (long)timeSlot.getTotalRt();
            errors += (long)timeSlot.getErrors();
            blockReqs += (long)timeSlot.getBlockRequests();
            totalBlockReqs += (long)timeSlot.getTotalBlockRequests();
            compReqs += (long)timeSlot.getCompReqs();
            _2xxStatus += timeSlot.get2xxStatusCount().get();
            _4xxStatus += timeSlot.get4xxStatusCount().get();
            _5xxStatus += timeSlot.get5xxStatusCount().get();
            _504Status += timeSlot.get504StatusCount().get();
        }
        tws.setMin(min == Long.MAX_VALUE ? null : Long.valueOf(min));
        tws.setMax(max == Long.MIN_VALUE ? null : Long.valueOf(max));
        tws.setPeakConcurrentReqeusts(peakConcurrences);
        tws.setTotal(totalReqs);
        tws.setErrors(errors);
        tws.setBlockRequests(blockReqs);
        tws.setTotalBlockRequests(totalBlockReqs);
        tws.setCompReqs(compReqs);
        tws.setPeakRps(new BigDecimal(peakRps));
        tws.set2xxStatus(_2xxStatus);
        tws.set4xxStatus(_4xxStatus);
        tws.set5xxStatus(_5xxStatus);
        tws.set504Status(_504Status);
        if (compReqs > 0L) {
            tws.setAvgRt(totalRt / compReqs);
        }
        if (totalReqs > 0L) {
            BigDecimal nsec = new BigDecimal(endSlotId - startSlotId).divide(new BigDecimal(1000), 5, 4);
            BigDecimal rps = new BigDecimal(totalReqs).divide(nsec, 5, 4);
            rps = rps.compareTo(new BigDecimal(10)) >= 0 ? rps.setScale(0, 4).stripTrailingZeros() : rps.setScale(2, 4).stripTrailingZeros();
            tws.setRps(rps);
        }
        return tws;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public ConcurrentMap<Long, TimeSlot> getTimeSlots() {
        return this.timeSlots;
    }

    public void setTimeSlots(ConcurrentMap<Long, TimeSlot> timeSlots) {
        this.timeSlots = timeSlots;
    }

    public AtomicInteger getConcurrentRequests() {
        return this.concurrentRequests;
    }

    public void setConcurrentRequests(AtomicInteger concurrentRequests) {
        this.concurrentRequests = concurrentRequests;
    }
}

