/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.stats;

import com.fizzgate.stats.circuitbreaker.CircuitBreaker;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class TimeSlot {
    private long id;
    private volatile int counter = 0;
    private volatile int errors = 0;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private volatile int totalRt = 0;
    private volatile int compReqs = 0;
    private volatile int peakConcurrentRequests;
    private volatile int blockRequests = 0;
    private volatile int totalBlockRequests = 0;
    private AtomicReference<CircuitBreaker.State> circuitBreakState = new AtomicReference<CircuitBreaker.State>(CircuitBreaker.State.CLOSED);
    private volatile int circuitBreakNum = 0;
    private volatile int gradualResumeNum = 0;
    private volatile int resumeTrafficFactor = 1;
    private volatile int gradualRejectNum = 0;
    private AtomicInteger _2xxStatusCount = new AtomicInteger(0);
    private AtomicInteger _4xxStatusCount = new AtomicInteger(0);
    private AtomicInteger _5xxStatusCount = new AtomicInteger(0);
    private AtomicInteger _504StatusCount = new AtomicInteger(0);

    public AtomicInteger get2xxStatusCount() {
        return this._2xxStatusCount;
    }

    public AtomicInteger get4xxStatusCount() {
        return this._4xxStatusCount;
    }

    public AtomicInteger get5xxStatusCount() {
        return this._5xxStatusCount;
    }

    public AtomicInteger get504StatusCount() {
        return this._504StatusCount;
    }

    public AtomicReference<CircuitBreaker.State> getCircuitBreakState() {
        return this.circuitBreakState;
    }

    public int getCircuitBreakNum() {
        return this.circuitBreakNum;
    }

    public void setCircuitBreakNum(int v) {
        this.circuitBreakNum = v;
    }

    public void incrCircuitBreakNum() {
        ++this.circuitBreakNum;
    }

    public int getGradualResumeNum() {
        return this.gradualResumeNum;
    }

    public int incrGradualResumeNum() {
        return ++this.gradualResumeNum;
    }

    public int decrGradualResumeNum() {
        return --this.gradualResumeNum;
    }

    public int getResumeTrafficFactor() {
        return this.resumeTrafficFactor;
    }

    public void incrResumeTrafficFactor() {
        ++this.resumeTrafficFactor;
    }

    public int getGradualRejectNum() {
        return this.gradualRejectNum;
    }

    public int incrGradualRejectNum() {
        return ++this.gradualRejectNum;
    }

    public int decrGradualRejectNum() {
        return --this.gradualRejectNum;
    }

    public TimeSlot(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void incr() {
        ++this.counter;
    }

    public synchronized void addRequestRT(long rt, boolean isSuccess) {
        this.totalRt = (int)((long)this.totalRt + rt);
        ++this.compReqs;
        if (!isSuccess) {
            ++this.errors;
        }
        this.min = rt < this.min ? rt : this.min;
        this.max = rt > this.max ? rt : this.max;
    }

    public synchronized void updatePeakConcurrentReqeusts(int concurrentRequests) {
        this.peakConcurrentRequests = concurrentRequests > this.peakConcurrentRequests ? concurrentRequests : this.peakConcurrentRequests;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public long getMin() {
        return this.min;
    }

    public void setMin(long min) {
        this.min = min;
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = max;
    }

    public int getTotalRt() {
        return this.totalRt;
    }

    public void setTotalRt(int totalRt) {
        this.totalRt = totalRt;
    }

    public long getPeakConcurrentRequests() {
        return this.peakConcurrentRequests;
    }

    public void setPeakConcurrentRequests(int peakConcurrentRequests) {
        this.peakConcurrentRequests = peakConcurrentRequests;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    public int getBlockRequests() {
        return this.blockRequests;
    }

    public void setBlockRequests(int blockRequests) {
        this.blockRequests = blockRequests;
    }

    public void incrBlockRequests() {
        ++this.blockRequests;
    }

    public int getCompReqs() {
        return this.compReqs;
    }

    public void setCompReqs(int compReqs) {
        this.compReqs = compReqs;
    }

    public int getTotalBlockRequests() {
        return this.totalBlockRequests;
    }

    public void incrTotalBlockRequests() {
        ++this.totalBlockRequests;
    }

    public void setTotalBlockRequests(int totalBlockRequests) {
        this.totalBlockRequests = totalBlockRequests;
    }
}

