/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.stats.circuitbreaker;

import com.fizzgate.stats.FlowStat;
import com.fizzgate.stats.circuitbreaker.CircuitBreaker;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.ResourceIdUtils;
import com.fizzgate.util.Result;
import com.fizzgate.util.WebUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class CircuitBreakManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CircuitBreakManager.class);
    private final Map<Long, CircuitBreaker> circuitBreakerMap = new HashMap<Long, CircuitBreaker>(64);
    private final Map<String, CircuitBreaker> resource2circuitBreakerMap = new HashMap<String, CircuitBreaker>(64);
    private final Set<String> circuitBreakersFromServiceDefault = new HashSet<String>(64);
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;

    @PostConstruct
    public void init() {
        Result<?> result = this.initCircuitBreakers();
        if (result.code == 0) {
            throw new RuntimeException(result.msg, result.t);
        }
        result = this.lsnCircuitBreakerChange();
        if (result.code == 0) {
            throw new RuntimeException(result.msg, result.t);
        }
    }

    private Result<?> initCircuitBreakers() {
        Result result = Result.succ();
        Flux circuitBreakerConfigs = this.rt.opsForHash().entries((Object)"fizz_degrade_rule");
        circuitBreakerConfigs.collectList().defaultIfEmpty(Collections.emptyList()).flatMap(es -> {
            if (!es.isEmpty()) {
                String json = null;
                try {
                    for (Map.Entry e : es) {
                        json = (String)e.getValue();
                        CircuitBreaker cb = (CircuitBreaker)JacksonUtils.readValue((String)json, CircuitBreaker.class);
                        this.circuitBreakerMap.put(cb.id, cb);
                        this.resource2circuitBreakerMap.put(cb.resource, cb);
                        LOGGER.info("init circuit breaker {}", (Object)cb);
                    }
                }
                catch (Throwable t) {
                    result.code = 0;
                    result.msg = "init circuit breaker error, json: " + json;
                    result.t = t;
                }
            } else {
                LOGGER.info("no circuit breaker config");
            }
            return Mono.empty();
        }).onErrorReturn(throwable -> {
            result.code = 0;
            result.msg = "init circuit breaker error";
            result.t = throwable;
            return true;
        }, (Object)result).block();
        return result;
    }

    private Result<?> lsnCircuitBreakerChange() {
        Result result = Result.succ();
        String channel = "fizz_degrade_rule_channel";
        this.rt.listenToChannel(new String[]{channel}).doOnError(t -> {
            result.code = 0;
            result.msg = "lsn error, channel: " + channel;
            result.t = t;
            LOGGER.error("lsn channel {} error", (Object)channel, t);
        }).doOnSubscribe(s -> LOGGER.info("success to lsn on {}", (Object)channel)).doOnNext(msg -> {
            String message = (String)msg.getMessage();
            try {
                CircuitBreaker cb = (CircuitBreaker)JacksonUtils.readValue((String)message, CircuitBreaker.class);
                if (cb.isDeleted) {
                    this.circuitBreakerMap.remove(cb.id);
                    this.resource2circuitBreakerMap.remove(cb.resource);
                    LOGGER.info("remove circuit breaker: {}", (Object)cb);
                } else {
                    CircuitBreaker prev = this.circuitBreakerMap.get(cb.id);
                    if (prev != null) {
                        this.resource2circuitBreakerMap.remove(prev.resource);
                    }
                    this.circuitBreakerMap.put(cb.id, cb);
                    this.resource2circuitBreakerMap.put(cb.resource, cb);
                    this.circuitBreakersFromServiceDefault.remove(cb.resource);
                    LOGGER.info("update circuit breaker: {}", (Object)cb);
                }
                if (cb.type == CircuitBreaker.Type.SERVICE_DEFAULT) {
                    for (String resource : this.circuitBreakersFromServiceDefault) {
                        this.resource2circuitBreakerMap.remove(resource);
                    }
                    this.circuitBreakersFromServiceDefault.clear();
                }
            }
            catch (Throwable t) {
                LOGGER.error("update circuit breaker error, {}", (Object)message, (Object)t);
            }
        }).subscribe();
        return result;
    }

    public boolean permit(ServerWebExchange exchange, long currentTimeWindow, FlowStat flowStat, String service, String path) {
        String resource = ResourceIdUtils.buildResourceId(null, null, null, service, path);
        CircuitBreaker cb = this.resource2circuitBreakerMap.get(resource);
        if (cb == null && (cb = this.resource2circuitBreakerMap.get(resource = ResourceIdUtils.buildResourceId(null, null, null, service, null))) == null) {
            cb = this.resource2circuitBreakerMap.get(ResourceIdUtils.SERVICE_DEFAULT_RESOURCE);
            cb = cb != null && cb.serviceDefaultEnable ? this.buildCircuitBreakerFromServiceDefault(service, resource) : null;
        }
        if (cb == null) {
            if (LOGGER.isDebugEnabled()) {
                ThreadContext.put((String)"traceId", (String)WebUtils.getTraceId(exchange));
                LOGGER.debug("no circuit breaker for {} {}", (Object)service, (Object)path);
            }
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            ThreadContext.put((String)"traceId", (String)WebUtils.getTraceId(exchange));
            LOGGER.debug("circuit breaker for {} {} is {}", new Object[]{service, path, cb});
        }
        return cb.permit(exchange, currentTimeWindow, flowStat);
    }

    private CircuitBreaker buildCircuitBreakerFromServiceDefault(String service, String resource) {
        CircuitBreaker serviceDefaultCircuitBreaker = this.resource2circuitBreakerMap.get(ResourceIdUtils.SERVICE_DEFAULT_RESOURCE);
        CircuitBreaker cb = new CircuitBreaker();
        cb.type = CircuitBreaker.Type.SERVICE;
        cb.service = service;
        cb.serviceDefaultEnable = true;
        cb.resource = resource;
        cb.breakStrategy = serviceDefaultCircuitBreaker.breakStrategy;
        cb.errorRatioThreshold = serviceDefaultCircuitBreaker.errorRatioThreshold;
        cb.totalErrorThreshold = serviceDefaultCircuitBreaker.totalErrorThreshold;
        cb.minRequests = serviceDefaultCircuitBreaker.minRequests;
        cb.monitorDuration = serviceDefaultCircuitBreaker.monitorDuration;
        cb.breakDuration = serviceDefaultCircuitBreaker.breakDuration;
        cb.resumeStrategy = serviceDefaultCircuitBreaker.resumeStrategy;
        if (cb.resumeStrategy == CircuitBreaker.ResumeStrategy.GRADUAL) {
            cb.resumeDuration = serviceDefaultCircuitBreaker.resumeDuration;
            cb.initGradualResumeTimeWindowContext();
        }
        cb.responseContentType = serviceDefaultCircuitBreaker.responseContentType;
        cb.responseContent = serviceDefaultCircuitBreaker.responseContent;
        cb.stateStartTime = serviceDefaultCircuitBreaker.stateStartTime;
        this.resource2circuitBreakerMap.put(resource, cb);
        this.circuitBreakersFromServiceDefault.add(resource);
        return cb;
    }

    public CircuitBreaker getCircuitBreaker(String resource) {
        return this.resource2circuitBreakerMap.get(resource);
    }

    public Map<String, CircuitBreaker> getResource2circuitBreakerMap() {
        return this.resource2circuitBreakerMap;
    }
}

