/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.stats.circuitbreaker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fizzgate.stats.FlowStat;
import com.fizzgate.stats.ResourceStat;
import com.fizzgate.stats.TimeSlot;
import com.fizzgate.stats.TimeWindowStat;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.ResourceIdUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;

public class CircuitBreaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(CircuitBreaker.class);
    public static final String DETECT_REQUEST = "detectReq@";
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public boolean isDeleted = false;
    public Type type;
    public boolean serviceDefaultEnable = false;
    public long id;
    public String service;
    public String path;
    public String resource;
    public BreakStrategy breakStrategy;
    public float errorRatioThreshold;
    public int totalErrorThreshold;
    public int monitorDuration;
    public int minRequests;
    public int breakDuration;
    public ResumeStrategy resumeStrategy;
    public int resumeDuration;
    private List<GradualResumeTimeWindowContext> gradualResumeTimeWindowContexts;
    public int initialResumeTraffic;
    public String responseContentType;
    public String responseContent;
    public final AtomicReference<State> stateRef = new AtomicReference<State>(State.CLOSED);
    public long stateStartTime;

    public CircuitBreaker() {
    }

    @JsonCreator
    public CircuitBreaker(@JsonProperty(value="isDeleted") int isDeleted, @JsonProperty(value="type") int type, @JsonProperty(value="enable") int enable, @JsonProperty(value="id") long id, @JsonProperty(value="service") String service, @JsonProperty(value="path") String path, @JsonProperty(value="strategy") int strategy, @JsonProperty(value="ratioThreshold") float ratioThreshold, @JsonProperty(value="exceptionCount") int exceptionCount, @JsonProperty(value="minRequestCount") int minRequestCount, @JsonProperty(value="timeWindow") int timeWindow, @JsonProperty(value="statInterval") int statInterval, @JsonProperty(value="recoveryStrategy") int recoveryStrategy, @JsonProperty(value="recoveryTimeWindow") int recoveryTimeWindow, @JsonProperty(value="responseContentType") String responseContentType, @JsonProperty(value="responseContent") String responseContent) {
        if (isDeleted == 1) {
            this.isDeleted = true;
        }
        if (type == 1) {
            this.type = Type.SERVICE_DEFAULT;
            this.service = "service_default";
            if (enable == 1) {
                this.serviceDefaultEnable = true;
            }
        } else {
            this.type = type == 2 ? Type.SERVICE : Type.PATH;
        }
        this.id = id;
        if (this.type != Type.SERVICE_DEFAULT) {
            this.service = service;
        }
        if (StringUtils.isNotBlank((CharSequence)path)) {
            this.path = path;
        }
        this.resource = ResourceIdUtils.buildResourceId(null, null, null, this.service, this.path);
        if (strategy == 1) {
            this.breakStrategy = BreakStrategy.ERRORS_RATIO;
            this.errorRatioThreshold = ratioThreshold;
        } else {
            this.breakStrategy = BreakStrategy.TOTAL_ERRORS;
            this.totalErrorThreshold = exceptionCount;
        }
        this.minRequests = minRequestCount;
        this.monitorDuration = statInterval * 1000;
        this.breakDuration = timeWindow * 1000;
        if (recoveryStrategy == 1) {
            this.resumeStrategy = ResumeStrategy.DETECTIVE;
        } else if (recoveryStrategy == 2) {
            this.resumeStrategy = ResumeStrategy.GRADUAL;
            this.resumeDuration = recoveryTimeWindow * 1000;
            this.initGradualResumeTimeWindowContext();
        } else {
            this.resumeStrategy = ResumeStrategy.IMMEDIATE;
        }
        this.responseContentType = responseContentType;
        this.responseContent = responseContent;
        this.stateStartTime = CircuitBreaker.currentTimeWindow();
    }

    private static long currentTimeWindow() {
        return CircuitBreaker.timeWindow(System.currentTimeMillis());
    }

    private static long timeWindow(long timeMills) {
        return timeMills / 1000L * 1000L;
    }

    public void initGradualResumeTimeWindowContext() {
        BigDecimal totalTraffic = new BigDecimal(100);
        int resumeDurationSecs = this.resumeDuration / 1000;
        BigDecimal duration = new BigDecimal(resumeDurationSecs);
        this.initialResumeTraffic = totalTraffic.divide(duration, 0, RoundingMode.HALF_UP).intValue();
        if (this.initialResumeTraffic == 0) {
            this.initialResumeTraffic = 1;
        }
        this.gradualResumeTimeWindowContexts = new ArrayList<GradualResumeTimeWindowContext>(resumeDurationSecs);
        for (int i = 1; i <= resumeDurationSecs; ++i) {
            int resumeTraffic = this.initialResumeTraffic * i;
            GradualResumeTimeWindowContext ctx = new GradualResumeTimeWindowContext(resumeTraffic);
            this.gradualResumeTimeWindowContexts.add(ctx);
        }
        LOGGER.info("{} gradualResumeTimeWindowContexts: {}", (Object)this.resource, this.gradualResumeTimeWindowContexts);
    }

    private boolean isResumeTraffic(long currentTimeWindow, FlowStat flowStat) {
        long nThSecond = this.getStateDuration(currentTimeWindow);
        GradualResumeTimeWindowContext ctx = this.gradualResumeTimeWindowContexts.get((int)nThSecond);
        ResourceStat resourceStat = flowStat.getResourceStat(this.resource);
        return ctx.permit(resourceStat, currentTimeWindow);
    }

    private long getStateDuration(long currentTimeWindow) {
        return currentTimeWindow - this.stateStartTime;
    }

    public void correctState(long currentTimeWindow, FlowStat flowStat) {
        State s = this.stateRef.get();
        long stateDuration = this.getStateDuration(currentTimeWindow);
        if (s == State.CLOSED && stateDuration > (long)this.monitorDuration) {
            LOGGER.debug("current time window {}, {} last {} second in {} large than monitor duration {}, correct to CLOSED state", new Object[]{currentTimeWindow, this.resource, stateDuration, this.stateRef.get(), this.monitorDuration});
            this.transit(s, State.CLOSED, currentTimeWindow, flowStat);
        } else if (s == State.OPEN && stateDuration > (long)this.breakDuration) {
            LOGGER.debug("current time window {}, {} last {} second in {} large than break duration {}, correct to CLOSED state", new Object[]{currentTimeWindow, this.resource, stateDuration, this.stateRef.get(), this.breakDuration});
            this.transit(s, State.CLOSED, currentTimeWindow, flowStat);
        } else if (s == State.RESUME_GRADUALLY && stateDuration > (long)this.resumeDuration) {
            LOGGER.debug("current time window {}, {} last {} second in {} large than resume duration {}, correct to CLOSED state", new Object[]{currentTimeWindow, this.resource, stateDuration, this.stateRef.get(), this.resumeDuration});
            this.transit(s, State.CLOSED, currentTimeWindow, flowStat);
        }
    }

    public boolean transit(State current, State target, long currentTimeWindow, FlowStat flowStat) {
        if (this.stateRef.compareAndSet(current, target)) {
            ResourceStat resourceStat = flowStat.getResourceStat(this.resource);
            resourceStat.getTimeSlot(currentTimeWindow).setCircuitBreakNum(0);
            resourceStat.updateCircuitBreakState(currentTimeWindow, current, target);
            LOGGER.debug("transit {} current time window {} from {} which start at {} to {}", new Object[]{this.resource, currentTimeWindow, current, this.stateStartTime, target});
            this.stateStartTime = currentTimeWindow;
            return true;
        }
        return false;
    }

    public boolean permit(ServerWebExchange exchange, long currentTimeWindow, FlowStat flowStat) {
        this.correctState(currentTimeWindow, flowStat);
        if (this.stateRef.get() == State.CLOSED) {
            return this.permitCallInClosedState(currentTimeWindow, flowStat);
        }
        if (this.stateRef.get() == State.OPEN) {
            return this.permitCallInOpenState(exchange, currentTimeWindow, flowStat);
        }
        if (this.stateRef.get() == State.RESUME_DETECTIVE) {
            flowStat.getResourceStat(this.resource).incrCircuitBreakNum(currentTimeWindow);
            return false;
        }
        if (this.stateRef.get() == State.RESUME_GRADUALLY) {
            return this.permitCallInResumeGraduallyState(currentTimeWindow, flowStat);
        }
        return true;
    }

    private boolean permitCallInClosedState(long currentTimeWindow, FlowStat flowStat) {
        BigDecimal requests;
        BigDecimal errors;
        float p;
        long endTimeWindow = currentTimeWindow + 1000L;
        TimeWindowStat timeWindowStat = flowStat.getTimeWindowStat(this.resource, this.stateStartTime, endTimeWindow);
        long reqCount = timeWindowStat.getCompReqs();
        long errCount = timeWindowStat.getErrors();
        if (this.breakStrategy == BreakStrategy.TOTAL_ERRORS && reqCount >= (long)this.minRequests && errCount >= (long)this.totalErrorThreshold) {
            LOGGER.debug("{} current time window {} request count {} >= min requests {} error count {} >= total error threshold {}", new Object[]{this.resource, currentTimeWindow, reqCount, this.minRequests, errCount, this.totalErrorThreshold});
            this.transit(State.CLOSED, State.OPEN, currentTimeWindow, flowStat);
            flowStat.getResourceStat(this.resource).incrCircuitBreakNum(currentTimeWindow);
            return false;
        }
        if (this.breakStrategy == BreakStrategy.ERRORS_RATIO && reqCount >= (long)this.minRequests && (p = (errors = new BigDecimal(errCount)).divide(requests = new BigDecimal(reqCount), 2, RoundingMode.HALF_UP).floatValue()) - this.errorRatioThreshold >= 0.0f) {
            LOGGER.debug("{} current time window {} request count {} >= min requests {} error ratio {} >= error ratio threshold {}", new Object[]{this.resource, currentTimeWindow, reqCount, this.minRequests, Float.valueOf(p), Float.valueOf(this.errorRatioThreshold)});
            this.transit(State.CLOSED, State.OPEN, currentTimeWindow, flowStat);
            flowStat.getResourceStat(this.resource).incrCircuitBreakNum(currentTimeWindow);
            return false;
        }
        LOGGER.debug("{} current time window {} in {} which start at {}, permit current request", new Object[]{this.resource, currentTimeWindow, this.stateRef.get(), this.stateStartTime});
        return true;
    }

    private boolean permitCallInOpenState(ServerWebExchange exchange, long currentTimeWindow, FlowStat flowStat) {
        long stateDuration = this.getStateDuration(currentTimeWindow);
        if (stateDuration > (long)this.breakDuration) {
            if (this.resumeStrategy == ResumeStrategy.IMMEDIATE) {
                LOGGER.debug("current time window {}, {} last {} second in {} large than break duration {}, resume immediately", new Object[]{currentTimeWindow, this.resource, stateDuration, this.stateRef.get(), this.breakDuration});
                this.transit(State.OPEN, State.CLOSED, currentTimeWindow, flowStat);
                return true;
            }
            if (this.resumeStrategy == ResumeStrategy.DETECTIVE) {
                LOGGER.debug("current time window {}, {} last {} second in {} large than break duration {}, resume detective", new Object[]{currentTimeWindow, this.resource, stateDuration, this.stateRef.get(), this.breakDuration});
                if (this.transit(State.OPEN, State.RESUME_DETECTIVE, currentTimeWindow, flowStat)) {
                    exchange.getAttributes().put(DETECT_REQUEST, this);
                    return true;
                }
                flowStat.getResourceStat(this.resource).incrCircuitBreakNum(currentTimeWindow);
                return false;
            }
            if (this.resumeStrategy == ResumeStrategy.GRADUAL) {
                LOGGER.debug("current time window {}, {} last {} second in {} large than break duration {}, resume gradual", new Object[]{currentTimeWindow, this.resource, stateDuration, this.stateRef.get(), this.breakDuration});
                this.transit(State.OPEN, State.RESUME_GRADUALLY, currentTimeWindow, flowStat);
                return this.isResumeTraffic(currentTimeWindow, flowStat);
            }
        }
        flowStat.getResourceStat(this.resource).incrCircuitBreakNum(currentTimeWindow);
        LOGGER.debug("{} current time window {} in {} which start at {}, reject current request", new Object[]{this.resource, currentTimeWindow, this.stateRef.get(), this.stateStartTime});
        return false;
    }

    private boolean permitCallInResumeGraduallyState(long currentTimeWindow, FlowStat flowStat) {
        long stateDuration = this.getStateDuration(currentTimeWindow);
        if (stateDuration > (long)this.resumeDuration) {
            LOGGER.debug("current time window {}, {} last {} second in {} large than resume duration {}, resume immediately", new Object[]{currentTimeWindow, this.resource, stateDuration, this.stateRef.get(), this.resumeDuration});
            this.transit(State.RESUME_GRADUALLY, State.CLOSED, currentTimeWindow, flowStat);
            return true;
        }
        return this.isResumeTraffic(currentTimeWindow, flowStat);
    }

    public String toString() {
        return JacksonUtils.writeValueAsString((Object)this);
    }

    private static class GradualResumeTimeWindowContext {
        private final int resumeTraffic;
        private final int rejectTraffic;

        public GradualResumeTimeWindowContext(int resumeTraffic) {
            this.resumeTraffic = resumeTraffic;
            this.rejectTraffic = 100 - this.resumeTraffic;
        }

        public boolean permit(ResourceStat resourceStat, long currentTimeWindow) {
            TimeSlot timeSlot = resourceStat.getTimeSlot(currentTimeWindow);
            long n = timeSlot.getResumeTrafficFactor();
            if ((long)timeSlot.incrGradualResumeNum() <= (long)this.resumeTraffic * n) {
                LOGGER.debug("{} current time window {}, resume traffic {}, resume traffic factor {}, resume count {}, resume current request", new Object[]{resourceStat.getResourceId(), currentTimeWindow, this.resumeTraffic, n, timeSlot.getGradualResumeNum()});
                return true;
            }
            if ((long)timeSlot.incrGradualRejectNum() <= (long)this.rejectTraffic * n) {
                timeSlot.decrGradualResumeNum();
                LOGGER.debug("{} current time window {}, reject traffic {}, resume traffic factor {}, reject count {}, reject current request", new Object[]{resourceStat.getResourceId(), currentTimeWindow, this.rejectTraffic, n, timeSlot.getGradualRejectNum()});
                return false;
            }
            timeSlot.decrGradualRejectNum();
            timeSlot.incrResumeTrafficFactor();
            LOGGER.debug("{} current time window {}, resume traffic {}, reject traffic {}, resume traffic factor {}, resume count {}, reject count {}, resume current request", new Object[]{resourceStat.getResourceId(), currentTimeWindow, this.resumeTraffic, this.rejectTraffic, n, timeSlot.getGradualResumeNum(), timeSlot.getGradualRejectNum()});
            return true;
        }

        public String toString() {
            return "GRTWC{resumeTraffic=" + this.resumeTraffic + ",rejectTraffic=" + this.rejectTraffic + '}';
        }
    }

    public static enum State {
        CLOSED,
        OPEN,
        RESUME_GRADUALLY,
        RESUME_DETECTIVE;

    }

    public static enum ResumeStrategy {
        IMMEDIATE,
        GRADUAL,
        DETECTIVE;

    }

    public static enum BreakStrategy {
        TOTAL_ERRORS,
        ERRORS_RATIO;

    }

    public static enum Type {
        SERVICE_DEFAULT,
        SERVICE,
        PATH;

    }
}

