/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.stats.degrade;

import com.fizzgate.stats.degrade.DegradeRule;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.Result;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DegradeRuleService {
    private static final Logger log = LoggerFactory.getLogger(DegradeRuleService.class);
    private static final String DEGRADE_RULE_CHANNEL = "fizz_degrade_rule_channel";
    private static final String DEGRADE_RULE_HASH_KEY = "fizz_degrade_rule";
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;
    private Map<String, DegradeRule> resourceId2DegradeRuleMap = new ConcurrentHashMap<String, DegradeRule>(32);
    private Map<Long, DegradeRule> id2DegradeRuleMap = new ConcurrentHashMap<Long, DegradeRule>(32);

    @PostConstruct
    public void init() {
        Result<?> result = this.initDegradeRule();
        if (result.code == 0) {
            throw new RuntimeException(result.msg, result.t);
        }
        result = this.lsnDegradeRuleChange();
        if (result.code == 0) {
            throw new RuntimeException(result.msg, result.t);
        }
    }

    public DegradeRule getDegradeRule(String resourceId) {
        return this.resourceId2DegradeRuleMap.get(resourceId);
    }

    public void refreshLocalCache() throws Throwable {
        this.initDegradeRule();
    }

    private Result<?> initDegradeRule() {
        Result result = Result.succ();
        ConcurrentHashMap<String, DegradeRule> resourceId2DegradeRuleMapTmp = new ConcurrentHashMap<String, DegradeRule>(32);
        ConcurrentHashMap<Long, DegradeRule> id2DegradeRuleMapTmp = new ConcurrentHashMap<Long, DegradeRule>(32);
        Flux degradeRuleEntries = this.rt.opsForHash().entries((Object)DEGRADE_RULE_HASH_KEY);
        degradeRuleEntries.collectList().defaultIfEmpty(Collections.emptyList()).flatMap(es -> {
            if (!es.isEmpty()) {
                String json = null;
                try {
                    for (Map.Entry e : es) {
                        json = (String)e.getValue();
                        DegradeRule degradeRule = (DegradeRule)JacksonUtils.readValue((String)json, DegradeRule.class);
                        resourceId2DegradeRuleMapTmp.put(degradeRule.getResourceId(), degradeRule);
                        id2DegradeRuleMapTmp.put(degradeRule.getId(), degradeRule);
                        log.info("init degrade rule: {}", (Object)json);
                    }
                }
                catch (Throwable t) {
                    result.code = 0;
                    result.msg = "init degrade rule error, json: " + json;
                    result.t = t;
                }
            } else {
                log.info("no degrade rule");
            }
            return Mono.empty();
        }).onErrorReturn(throwable -> {
            result.code = 0;
            result.msg = "init degrade rule error";
            result.t = throwable;
            return true;
        }, (Object)result).block();
        this.resourceId2DegradeRuleMap = resourceId2DegradeRuleMapTmp;
        this.id2DegradeRuleMap = id2DegradeRuleMapTmp;
        return result;
    }

    private Result<?> lsnDegradeRuleChange() {
        Result result = Result.succ();
        this.rt.listenToChannel(new String[]{DEGRADE_RULE_CHANNEL}).doOnError(t -> {
            result.code = 0;
            result.msg = "lsn error, channel: fizz_degrade_rule_channel";
            result.t = t;
            log.error("lsn channel {} error", (Object)DEGRADE_RULE_CHANNEL, t);
        }).doOnSubscribe(s -> log.info("success to lsn on {}", (Object)DEGRADE_RULE_CHANNEL)).doOnNext(msg -> {
            String message = (String)msg.getMessage();
            try {
                DegradeRule degradeRule = (DegradeRule)JacksonUtils.readValue((String)message, DegradeRule.class);
                if (degradeRule.isDeleted()) {
                    DegradeRule remove = this.id2DegradeRuleMap.remove(degradeRule.getId());
                    if (remove != null) {
                        this.resourceId2DegradeRuleMap.remove(remove.getResourceId());
                    }
                    log.info("remove degrade rule {}", (Object)message);
                } else {
                    DegradeRule previous = this.id2DegradeRuleMap.put(degradeRule.getId(), degradeRule);
                    if (previous != null && !previous.getResourceId().equals(degradeRule.getResourceId())) {
                        this.resourceId2DegradeRuleMap.remove(previous.getResourceId());
                    }
                    this.resourceId2DegradeRuleMap.put(degradeRule.getResourceId(), degradeRule);
                    log.info("update degrade rule {}", (Object)message);
                }
            }
            catch (Throwable t) {
                log.error("update degrade rule error, {}", (Object)message, (Object)t);
            }
        }).subscribe();
        return result;
    }
}

