/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.stats.ratelimit;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fizzgate.util.JacksonUtils;
import org.apache.commons.lang3.StringUtils;

public class ResourceRateLimitConfig {
    public boolean isDeleted = false;
    public int id;
    private boolean enable = true;
    public String resource;
    public String service;
    public String path;
    public String app;
    public String ip;
    public String node;
    public byte type;
    public long qps;
    public long concurrents;
    public String responseType;
    public String responseContent;
    private String resourceId = null;

    public boolean isEnable() {
        return this.enable;
    }

    public void setDeleted(int v) {
        if (v == 1) {
            this.isDeleted = true;
        }
    }

    public void setEnable(int v) {
        this.enable = v == 1;
    }

    public void setResource(String r) {
        if (StringUtils.isNotBlank((CharSequence)r)) {
            this.resource = r;
            if (!this.resource.equals("_global")) {
                this.service = this.resource;
            }
        }
    }

    public void setType(byte t) {
        this.type = t;
        if (this.type == 1) {
            this.node = "_global";
        } else if (this.type == 2) {
            this.service = "service_default";
        } else if (this.type == 5) {
            this.app = "app_default";
        }
    }

    public void setService(String s) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            this.service = s;
        }
    }

    public void setPath(String p) {
        if (StringUtils.isNotBlank((CharSequence)p)) {
            this.path = p;
        }
    }

    @JsonIgnore
    public String getResourceId() {
        if (this.resourceId == null) {
            this.resourceId = (this.app == null ? "" : this.app) + '^' + (this.ip == null ? "" : this.ip) + '^' + (this.node == null ? "" : this.node) + '^' + (this.service == null ? "" : this.service) + '^' + (this.path == null ? "" : this.path);
        }
        return this.resourceId;
    }

    public String toString() {
        return JacksonUtils.writeValueAsString((Object)this);
    }

    public static interface Type {
        public static final byte NODE = 1;
        public static final byte SERVICE_DEFAULT = 2;
        public static final byte SERVICE = 3;
        public static final byte API = 4;
        public static final byte APP_DEFAULT = 5;
        public static final byte APP = 6;
        public static final byte IP = 7;
        public static final byte HOST = 8;
    }
}

