/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.stats.ratelimit;

import com.fizzgate.stats.ratelimit.ResourceRateLimitConfig;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.ReactorUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ResourceRateLimitConfigService {
    private static final Logger log = LoggerFactory.getLogger(ResourceRateLimitConfigService.class);
    private static final String fizzRateLimit = "fizz_rate_limit";
    private static final String fizzRateLimitChannel = "fizz_rate_limit_channel";
    private Map<String, ResourceRateLimitConfig> resourceRateLimitConfigMap = new HashMap<String, ResourceRateLimitConfig>(32);
    private Map<Integer, ResourceRateLimitConfig> oldResourceRateLimitConfigMap = new HashMap<Integer, ResourceRateLimitConfig>(32);
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;

    @PostConstruct
    public void init() throws Throwable {
        this.init(this::lsnResourceRateLimitConfigChange);
    }

    public void refreshLocalCache() throws Throwable {
        this.init(null);
    }

    private void init(Supplier<Mono<Throwable>> doAfterLoadCache) throws Throwable {
        HashMap<String, ResourceRateLimitConfig> resourceRateLimitConfigMapTmp = new HashMap<String, ResourceRateLimitConfig>(32);
        HashMap<Integer, ResourceRateLimitConfig> oldResourceRateLimitConfigMapTmp = new HashMap<Integer, ResourceRateLimitConfig>(32);
        Throwable[] throwable = new Throwable[1];
        Throwable error = (Throwable)Mono.just((Object)Objects.requireNonNull(this.rt.opsForHash().entries((Object)fizzRateLimit).defaultIfEmpty(new AbstractMap.SimpleEntry<Object, Object>(ReactorUtils.OBJ, ReactorUtils.OBJ)).onErrorStop().doOnError(t -> log.info(null, t)).concatMap(e -> {
            Object k = e.getKey();
            if (k == ReactorUtils.OBJ) {
                return Flux.just((Object)e);
            }
            String json = (String)e.getValue();
            ThreadContext.put((String)"traceId", (String)k.toString());
            log.info("rateLimitConfig: " + json);
            try {
                ResourceRateLimitConfig rrlc = (ResourceRateLimitConfig)JacksonUtils.readValue((String)json, ResourceRateLimitConfig.class);
                oldResourceRateLimitConfigMapTmp.put(rrlc.id, rrlc);
                this.updateResourceRateLimitConfigMap(rrlc, resourceRateLimitConfigMapTmp);
                return Flux.just((Object)e);
            }
            catch (Throwable t) {
                throwable[0] = t;
                log.info(json, t);
                return Flux.error((Throwable)t);
            }
        }).blockLast())).flatMap(e -> {
            if (throwable[0] != null) {
                return Mono.error((Throwable)throwable[0]);
            }
            if (doAfterLoadCache != null) {
                return (Mono)doAfterLoadCache.get();
            }
            return Mono.just((Object)ReactorUtils.EMPTY_THROWABLE);
        }).block();
        if (error != ReactorUtils.EMPTY_THROWABLE) {
            throw error;
        }
        this.resourceRateLimitConfigMap = resourceRateLimitConfigMapTmp;
        this.oldResourceRateLimitConfigMap = oldResourceRateLimitConfigMapTmp;
    }

    private Mono<Throwable> lsnResourceRateLimitConfigChange() {
        Throwable[] throwable = new Throwable[1];
        boolean[] b = new boolean[]{false};
        this.rt.listenToChannel(new String[]{fizzRateLimitChannel}).doOnError(t -> {
            throwable[0] = t;
            b[0] = false;
            log.error("lsn fizz_rate_limit_channel", t);
        }).doOnSubscribe(s -> {
            b[0] = true;
            log.info("success to lsn on fizz_rate_limit_channel");
        }).doOnNext(msg -> {
            String json = (String)msg.getMessage();
            ThreadContext.put((String)"traceId", (String)("rrlc" + System.currentTimeMillis()));
            log.info("channel recv rate limit config: " + json);
            try {
                ResourceRateLimitConfig rrlc = (ResourceRateLimitConfig)JacksonUtils.readValue((String)json, ResourceRateLimitConfig.class);
                ResourceRateLimitConfig r = this.oldResourceRateLimitConfigMap.remove(rrlc.id);
                if (!rrlc.isDeleted && r != null) {
                    this.resourceRateLimitConfigMap.remove(r.getResourceId());
                }
                this.updateResourceRateLimitConfigMap(rrlc, this.resourceRateLimitConfigMap);
                if (!rrlc.isDeleted) {
                    this.oldResourceRateLimitConfigMap.put(rrlc.id, rrlc);
                }
            }
            catch (Throwable t) {
                log.info(json, t);
            }
        }).subscribe();
        Throwable t2 = throwable[0];
        while (!b[0]) {
            if (t2 != null) {
                return Mono.error((Throwable)t2);
            }
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                return Mono.error((Throwable)e);
            }
        }
        return Mono.just((Object)ReactorUtils.EMPTY_THROWABLE);
    }

    private void updateResourceRateLimitConfigMap(ResourceRateLimitConfig rrlc, Map<String, ResourceRateLimitConfig> resourceRateLimitConfigMap) {
        if (rrlc.isDeleted) {
            ResourceRateLimitConfig removedRrlc = resourceRateLimitConfigMap.remove(rrlc.getResourceId());
            log.info("remove " + removedRrlc);
        } else {
            ResourceRateLimitConfig existRrlc = resourceRateLimitConfigMap.get(rrlc.getResourceId());
            resourceRateLimitConfigMap.put(rrlc.getResourceId(), rrlc);
            if (existRrlc == null) {
                log.info("add " + rrlc);
            } else {
                log.info("update " + existRrlc + " with " + rrlc);
            }
        }
    }

    public void setReactiveStringRedisTemplate(ReactiveStringRedisTemplate rt) {
        this.rt = rt;
    }

    public ResourceRateLimitConfig getResourceRateLimitConfig(String resource) {
        return this.resourceRateLimitConfigMap.get(resource);
    }

    public Map<String, ResourceRateLimitConfig> getResourceRateLimitConfigMap() {
        return this.resourceRateLimitConfigMap;
    }

    private void to(List<String> parentList, StringBuilder b) {
        parentList.add(b.toString());
        b.delete(0, b.length());
    }

    private void checkRateLimitConfigAndAddTo(StringBuilder resourceStringBuilder, List<String> resourceList) {
        String r = resourceStringBuilder.toString();
        ResourceRateLimitConfig c = this.resourceRateLimitConfigMap.get(r);
        if (c != null) {
            resourceList.add(r);
        }
        resourceStringBuilder.delete(0, resourceStringBuilder.length());
    }
}

