/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import com.fizzgate.util.Utils;

public class ResourceIdUtils {
    public static final String NODE = "_global";
    public static final String NODE_RESOURCE = ResourceIdUtils.buildResourceId(null, null, "_global", null, null);
    public static final String SERVICE_DEFAULT = "service_default";
    public static final String SERVICE_DEFAULT_RESOURCE = ResourceIdUtils.buildResourceId(null, null, null, "service_default", null);
    public static final String APP_DEFAULT = "app_default";
    public static final String APP_DEFAULT_RESOURCE = ResourceIdUtils.buildResourceId("app_default", null, null, null, null);

    public static String buildResourceId(String app, String ip, String node, String service, String path) {
        StringBuilder b = new StringBuilder(32);
        ResourceIdUtils.buildResourceIdTo(b, app, ip, node, service, path);
        return b.toString();
    }

    public static void buildResourceIdTo(StringBuilder b, String app, String ip, String node, String service, String path) {
        b.append(app == null ? "" : app).append('^');
        b.append(ip == null ? "" : ip).append('^');
        b.append(node == null ? "" : node).append('^');
        b.append(service == null ? "" : service).append('^');
        b.append(path == null ? "" : path);
    }

    public static String getApp(String resource) {
        int i = resource.indexOf(94);
        if (i == 0) {
            return null;
        }
        return resource.substring(0, i);
    }

    public static String getIp(String resource) {
        String extract = Utils.extract((String)resource, (char)'^', (int)1);
        if (extract.equals("")) {
            return null;
        }
        return extract;
    }

    public static String getNode(String resource) {
        String extract = Utils.extract((String)resource, (char)'^', (int)2);
        if (extract.equals("")) {
            return null;
        }
        return extract;
    }

    public static String getService(String resource) {
        String extract = Utils.extract((String)resource, (char)'^', (int)3);
        if (extract.equals("")) {
            return null;
        }
        return extract;
    }

    public static String getPath(String resource) {
        int i = resource.lastIndexOf(94);
        if (i == resource.length() - 1) {
            return null;
        }
        return resource.substring(i);
    }
}

