/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.util;

import com.fizzgate.config.SystemConfig;
import com.fizzgate.filter.FilterResult;
import com.fizzgate.plugin.auth.ApiConfig;
import com.fizzgate.proxy.Route;
import com.fizzgate.util.Consts;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.NettyDataBufferUtils;
import com.fizzgate.util.Result;
import com.fizzgate.util.ThreadContext;
import com.fizzgate.util.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class WebUtils {
    private static final Logger log = LoggerFactory.getLogger(WebUtils.class);
    private static final String clientService = "cs@";
    private static final String xForwardedFor = "X-Forwarded-For";
    private static final String unknown = "unknown";
    private static final String loopBack = "127.0.0.1";
    private static final String binaryAddress = "0:0:0:0:0:0:0:1";
    private static final String directResponse = "dr@";
    private static final String response = " response ";
    private static final String originIp = "oi@";
    private static final String clientRequestPath = "crp@";
    private static final String clientRequestPathPrefix = "crpp@";
    private static final String clientRequestQuery = "crq@";
    private static String gatewayPrefix = "/";
    private static List<String> appHeaders = Stream.of("fizz-appid").collect(Collectors.toList());
    private static List<String> signHeaders = Stream.of("fizz-sign").collect(Collectors.toList());
    private static List<String> timestampHeaders = Stream.of("fizz-ts").collect(Collectors.toList());
    public static final String TRACE_ID = "traid@";
    public static final String BACKEND_SERVICE = "bs@";
    public static final String FILTER_CONTEXT = "fc@";
    public static final String APPEND_HEADERS = "ahs@";
    public static final String PREV_FILTER_RESULT = "pfr@";
    public static final String BACKEND_PATH = "bp@";
    public static final String ROUTE = "rout@";
    public static boolean LOG_RESPONSE_BODY = false;
    public static Set<String> LOG_HEADER_SET = Collections.emptySet();
    public static final String ADMIN_REQUEST = "ar@";
    public static final String FIZZ_REQUEST = "fr@";
    public static final String FAV_REQUEST = "fa@";
    public static final String BODY_ENCRYPT = "b-ecyt";
    public static final String ORIGINAL_ERROR = "origerr@";
    public static final String IGNORE_PLUGIN = "ignPlg@";
    private static final String s0 = "{\"";
    private static final String s1 = "\":";
    private static final String s2 = ",\"";
    private static final String s3 = "\":\"";
    private static final String s4 = "\"";
    private static final String s5 = ",\"traceId\":\"";
    private static final String s6 = ",\"context\":\"";
    private static final String s7 = "}";

    private WebUtils() {
    }

    public static boolean ignorePlugin(ServerWebExchange exchange) {
        return exchange.getAttributes().containsKey(IGNORE_PLUGIN);
    }

    public static boolean isFavReq(ServerWebExchange exchange) {
        return exchange.getAttribute(FAV_REQUEST) != null;
    }

    public static boolean isAdminReq(ServerWebExchange exchange) {
        return exchange.getAttribute(ADMIN_REQUEST) != null;
    }

    public static boolean isFizzReq(ServerWebExchange exchange) {
        return exchange.getAttribute(FIZZ_REQUEST) != null;
    }

    public static void setGatewayPrefix(String p) {
        gatewayPrefix = p;
    }

    public static void setAppHeaders(List<String> hdrs) {
        appHeaders = hdrs;
    }

    public static void setSignHeaders(List<String> hdrs) {
        signHeaders = hdrs;
    }

    public static void setTimestampHeaders(List<String> hdrs) {
        timestampHeaders = hdrs;
    }

    public static String getHeaderValue(ServerWebExchange exchange, String header) {
        return exchange.getRequest().getHeaders().getFirst(header);
    }

    public static List<String> getHeaderValues(ServerWebExchange exchange, String header) {
        return exchange.getRequest().getHeaders().get((Object)header);
    }

    public static boolean isDedicatedLineRequest(ServerWebExchange exchange) {
        String v = exchange.getRequest().getHeaders().getFirst("fizz-dl-id");
        return v != null;
    }

    public static String getAppId(ServerWebExchange exchange) {
        HttpHeaders headers = exchange.getRequest().getHeaders();
        for (int i = 0; i < appHeaders.size(); ++i) {
            String v = headers.getFirst(appHeaders.get(i));
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public static String getTimestamp(ServerWebExchange exchange) {
        HttpHeaders headers = exchange.getRequest().getHeaders();
        for (int i = 0; i < timestampHeaders.size(); ++i) {
            String v = headers.getFirst(timestampHeaders.get(i));
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public static String getSign(ServerWebExchange exchange) {
        HttpHeaders headers = exchange.getRequest().getHeaders();
        for (int i = 0; i < signHeaders.size(); ++i) {
            String v = headers.getFirst(signHeaders.get(i));
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public static String getDedicatedLineId(ServerWebExchange exchange) {
        return WebUtils.getHeaderValue(exchange, "fizz-dl-id");
    }

    public static String getDedicatedLineTimestamp(ServerWebExchange exchange) {
        return WebUtils.getHeaderValue(exchange, "fizz-dl-ts");
    }

    public static String getDedicatedLineSign(ServerWebExchange exchange) {
        return WebUtils.getHeaderValue(exchange, "fizz-dl-sign");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getClientService(ServerWebExchange exchange) {
        String svc = (String)exchange.getAttribute(clientService);
        if (svc == null) {
            block9: {
                String p = exchange.getRequest().getPath().value();
                int secFS = p.indexOf(47, 1);
                if (secFS == -1) {
                    if (StringUtils.isBlank((CharSequence)gatewayPrefix) || "/".equals(gatewayPrefix)) {
                        svc = p.substring(1);
                        break block9;
                    } else {
                        String prefix = p.substring(1);
                        if (!gatewayPrefix.equals(prefix) && !"/_proxytest".equals(prefix)) {
                            throw Utils.runtimeExceptionWithoutStack((String)"request prefix is wrong and no service in request path");
                        }
                        throw Utils.runtimeExceptionWithoutStack((String)"no service in request path");
                    }
                }
                String prefix = p.substring(0, secFS);
                if (StringUtils.isBlank((CharSequence)gatewayPrefix) || "/".equals(gatewayPrefix)) {
                    int trdFS;
                    svc = "/_proxytest".equals(prefix) ? ((trdFS = p.indexOf(47, secFS + 1)) == -1 ? p.substring(secFS + 1) : p.substring(secFS + 1, trdFS)) : p.substring(1, secFS);
                } else {
                    if (!gatewayPrefix.equals(prefix) && !"/_proxytest".equals(prefix)) {
                        throw Utils.runtimeExceptionWithoutStack((String)("wrong prefix " + prefix));
                    }
                    int trdFS = p.indexOf(47, secFS + 1);
                    if (trdFS == -1) {
                        trdFS = p.length();
                    }
                    svc = p.substring(secFS + 1, trdFS);
                }
            }
            exchange.getAttributes().put(clientService, svc);
        }
        return svc;
    }

    public static void setBackendService(ServerWebExchange exchange, String service) {
        exchange.getAttributes().put(BACKEND_SERVICE, service);
    }

    public static String getBackendService(ServerWebExchange exchange) {
        return (String)exchange.getAttribute(BACKEND_SERVICE);
    }

    public static byte getApiConfigType(ServerWebExchange exchange) {
        ApiConfig ac = WebUtils.getApiConfig(exchange);
        if (ac == null) {
            return 0;
        }
        return ac.type;
    }

    public static ApiConfig getApiConfig(ServerWebExchange exchange) {
        Result authRes = (Result)WebUtils.getFilterResultDataItem(exchange, "authPlugin", "result");
        if (authRes == null) {
            return null;
        }
        return (ApiConfig)authRes.data;
    }

    public static Route getRoute(ServerWebExchange exchange) {
        return (Route)exchange.getAttribute(ROUTE);
    }

    public static Mono<Void> response(ServerWebExchange exchange, HttpStatus status, HttpHeaders headers, String body) {
        return WebUtils.response(exchange.getResponse(), status, headers, body);
    }

    public static Mono<Void> response(ServerHttpResponse clientResp, HttpStatus status, HttpHeaders headers, DataBuffer body) {
        if (clientResp.isCommitted()) {
            String s = body.toString(StandardCharsets.UTF_8);
            String msg = "try to response: " + s + ", but server http response is committed and it's status: " + clientResp.getStatusCode();
            log.warn(msg);
            return Mono.error((Throwable)Utils.runtimeExceptionWithoutStack((String)msg));
        }
        if (status != null) {
            clientResp.setStatusCode(status);
        }
        if (headers != null) {
            headers.forEach((h, vs) -> clientResp.getHeaders().addAll(h, vs));
        }
        if (body == null) {
            body = NettyDataBufferUtils.EMPTY_DATA_BUFFER;
        }
        return clientResp.writeWith((Publisher)Mono.just((Object)body));
    }

    public static Mono<Void> response(ServerHttpResponse clientResp, HttpStatus status, HttpHeaders headers, ByteBuffer body) {
        DataBuffer dataBuffer = null;
        if (body != null) {
            dataBuffer = clientResp.bufferFactory().wrap(body);
        }
        return WebUtils.response(clientResp, status, headers, dataBuffer);
    }

    public static Mono<Void> response(ServerHttpResponse clientResp, HttpStatus status, HttpHeaders headers, byte[] body) {
        DataBuffer dataBuffer = null;
        if (body != null) {
            dataBuffer = clientResp.bufferFactory().wrap(body);
        }
        return WebUtils.response(clientResp, status, headers, dataBuffer);
    }

    public static Mono<Void> response(ServerHttpResponse clientResp, HttpStatus status, HttpHeaders headers, String body) {
        DataBuffer dataBuffer = null;
        if (body != null) {
            dataBuffer = clientResp.bufferFactory().wrap(body.getBytes(StandardCharsets.UTF_8));
        }
        return WebUtils.response(clientResp, status, headers, dataBuffer);
    }

    public static Mono<Void> responseJson(ServerWebExchange exchange, HttpStatus status, HttpHeaders headers, Object body) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.setContentType(MediaType.APPLICATION_JSON);
        byte[] bytes = null;
        if (body != null) {
            bytes = JacksonUtils.writeValueAsBytes((Object)body);
        }
        return WebUtils.response(exchange.getResponse(), status, headers, bytes);
    }

    public static Mono<Void> responseJson(ServerWebExchange exchange, HttpStatus status, HttpHeaders headers, String json) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.setContentType(MediaType.APPLICATION_JSON);
        return WebUtils.response(exchange, status, headers, json);
    }

    private static void bind(ServerWebExchange exchange, String filter, FilterResult fr) {
        Map<String, FilterResult> fc = WebUtils.getFilterContext(exchange);
        fc.put(filter, fr);
        fc.put(PREV_FILTER_RESULT, fr);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getClientReqPath(ServerWebExchange exchange) {
        String p = (String)exchange.getAttribute(clientRequestPath);
        if (p == null) {
            block8: {
                p = exchange.getRequest().getURI().getPath();
                int secFS = p.indexOf(47, 1);
                if (secFS == -1) {
                    if (StringUtils.isBlank((CharSequence)gatewayPrefix) || "/".equals(gatewayPrefix)) {
                        p = "/";
                        break block8;
                    } else {
                        String prefix = p.substring(1);
                        if (!gatewayPrefix.equals(prefix) && !"/_proxytest".equals(prefix)) {
                            throw Utils.runtimeExceptionWithoutStack((String)"request prefix is wrong, no service and request path");
                        }
                        throw Utils.runtimeExceptionWithoutStack((String)"no service and request path");
                    }
                }
                String prefix = p.substring(0, secFS);
                if (StringUtils.isBlank((CharSequence)gatewayPrefix) || "/".equals(gatewayPrefix)) {
                    int trdFS;
                    p = "/_proxytest".equals(prefix) ? ((trdFS = p.indexOf(47, secFS + 1)) == -1 ? "/" : p.substring(trdFS)) : p.substring(secFS);
                } else {
                    if (!gatewayPrefix.equals(prefix) && !"/_proxytest".equals(prefix)) {
                        throw Utils.runtimeExceptionWithoutStack((String)("wrong prefix " + prefix));
                    }
                    int trdFS = p.indexOf(47, secFS + 1);
                    p = trdFS == -1 ? "/" : p.substring(trdFS);
                }
            }
            exchange.getAttributes().put(clientRequestPath, p);
        }
        return p;
    }

    public static void setBackendPath(ServerWebExchange exchange, String path) {
        exchange.getAttributes().put(BACKEND_PATH, path);
    }

    public static String getBackendPath(ServerWebExchange exchange) {
        return (String)exchange.getAttribute(BACKEND_PATH);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getClientReqPathPrefix(ServerWebExchange exchange) {
        String prefix = (String)exchange.getAttribute(clientRequestPathPrefix);
        if (prefix != null) return prefix;
        String path = exchange.getRequest().getPath().value();
        int secFS = path.indexOf(47, 1);
        if (secFS == -1) {
            prefix = path.substring(1);
            if (StringUtils.isBlank((CharSequence)gatewayPrefix) || "/".equals(gatewayPrefix)) {
                prefix = "/";
            } else {
                if (!gatewayPrefix.equals(prefix) && !"/_proxytest".equals(prefix)) throw Utils.runtimeExceptionWithoutStack((String)("wrong prefix " + prefix));
                prefix = prefix + '/';
            }
        } else {
            prefix = path.substring(0, secFS);
            if (StringUtils.isBlank((CharSequence)gatewayPrefix) || "/".equals(gatewayPrefix)) {
                prefix = "/_proxytest".equals(prefix) ? prefix + '/' : "/";
            } else {
                if (!gatewayPrefix.equals(prefix) && !"/_proxytest".equals(prefix)) throw Utils.runtimeExceptionWithoutStack((String)("wrong prefix " + prefix));
                prefix = prefix + '/';
            }
        }
        exchange.getAttributes().put(clientRequestPathPrefix, prefix);
        return prefix;
    }

    public static String getClientReqQuery(ServerWebExchange exchange) {
        String qry = (String)exchange.getAttribute(clientRequestQuery);
        if (qry != null && "".equals(qry)) {
            return null;
        }
        if (qry == null) {
            URI uri = exchange.getRequest().getURI();
            qry = uri.getQuery();
            if (qry == null) {
                exchange.getAttributes().put(clientRequestQuery, "");
            } else {
                if (StringUtils.indexOfAny((CharSequence)qry, (char[])new char[]{'{', '/', '#'}) > 0) {
                    qry = uri.getRawQuery();
                }
                exchange.getAttributes().put(clientRequestQuery, qry);
            }
        }
        return qry;
    }

    public static String getClientReqPathQuery(ServerWebExchange exchange) {
        String pathQry = WebUtils.getClientReqPath(exchange);
        MultiValueMap queryParams = exchange.getRequest().getQueryParams();
        if (!queryParams.isEmpty()) {
            String qry = WebUtils.toQueryString((MultiValueMap<String, String>)queryParams);
            pathQry = pathQry + '?' + qry;
        }
        return pathQry;
    }

    public static Map<String, List<String>> getClientReqPathQueryTemplate(ServerWebExchange exchange) {
        String pathQry = WebUtils.getClientReqPath(exchange);
        MultiValueMap queryParams = exchange.getRequest().getQueryParams();
        if (queryParams.isEmpty()) {
            return Collections.singletonMap(pathQry, Collections.emptyList());
        }
        Map<String, List<String>> queryStringTemplate = WebUtils.toQueryStringTemplate((MultiValueMap<String, String>)queryParams);
        Map.Entry<String, List<String>> entry = queryStringTemplate.entrySet().iterator().next();
        pathQry = pathQry + '?' + entry.getKey();
        return Collections.singletonMap(pathQry, entry.getValue());
    }

    public static String appendQuery(String path, ServerWebExchange exchange) {
        String qry = WebUtils.getClientReqQuery(exchange);
        if (qry != null) {
            return path + '?' + qry;
        }
        return path;
    }

    public static Map<String, String> appendHeader(ServerWebExchange exchange, String name, String value) {
        Map<String, String> appendHeaders = WebUtils.getAppendHeaders(exchange);
        appendHeaders.put(name, value);
        return appendHeaders;
    }

    public static Map<String, String> appendHeaders(ServerWebExchange exchange, Map<String, String> headers) {
        Map<String, String> appendHeaders = WebUtils.getAppendHeaders(exchange);
        headers.forEach((name, value) -> appendHeaders.put((String)name, (String)value));
        return appendHeaders;
    }

    public static Map<String, String> getAppendHeaders(ServerWebExchange exchange) {
        return (Map)exchange.getAttribute(APPEND_HEADERS);
    }

    public static HttpHeaders mergeAppendHeaders(ServerWebExchange exchange) {
        ServerHttpRequest req = exchange.getRequest();
        Map<String, String> appendHeaders = WebUtils.getAppendHeaders(exchange);
        HttpHeaders hdrs = new HttpHeaders();
        req.getHeaders().forEach((h, vs) -> hdrs.addAll(h, vs));
        appendHeaders.forEach((h, v) -> {
            List vs = hdrs.get(h);
            if (vs != null && !vs.isEmpty()) {
                vs.clear();
                vs.add(v);
            } else {
                hdrs.add(h, v);
            }
        });
        return hdrs;
    }

    public static void request2stringBuilder(ServerWebExchange exchange, StringBuilder b) {
        ServerHttpRequest req = exchange.getRequest();
        WebUtils.request2stringBuilder(WebUtils.getTraceId(exchange), req.getMethod(), req.getURI().toString(), req.getHeaders(), null, b);
    }

    public static void request2stringBuilder(String traceId, HttpMethod method, String uri, HttpHeaders headers, Object body, StringBuilder b) {
        b.append(traceId).append(' ').append(method).append(' ').append(uri);
        if (headers != null) {
            boolean[] f = new boolean[]{false};
            LOG_HEADER_SET.forEach(h -> {
                String v = headers.getFirst(h);
                if (v != null) {
                    if (!f[0]) {
                        b.append(Consts.S.LINE_SEPARATOR);
                        f[0] = true;
                    }
                    Utils.addTo((StringBuilder)b, (String)h, (char)'=', (String)v, (String)"  ");
                }
            });
        }
    }

    public static void response2stringBuilder(String traceId, ClientResponse clientResponse, StringBuilder b) {
        b.append(traceId).append(response).append(clientResponse.statusCode());
        HttpHeaders headers = clientResponse.headers().asHttpHeaders();
        boolean[] f = new boolean[]{false};
        LOG_HEADER_SET.forEach(h -> {
            String v = headers.getFirst(h);
            if (v != null) {
                if (!f[0]) {
                    b.append(Consts.S.LINE_SEPARATOR);
                    f[0] = true;
                }
                Utils.addTo((StringBuilder)b, (String)h, (char)'=', (String)v, (String)"  ");
            }
        });
    }

    private static Mono<Void> responseError(ServerWebExchange exchange, String filter, int code, String msg, Throwable t, boolean bindContext) {
        exchange.getResponse().getHeaders().set(BODY_ENCRYPT, "0");
        String traceId = WebUtils.getTraceId(exchange);
        StringBuilder b = ThreadContext.getStringBuilder();
        WebUtils.request2stringBuilder(exchange, b);
        b.append(Consts.S.LINE_SEPARATOR);
        b.append(filter).append(' ').append(code).append(' ').append(msg);
        org.apache.logging.log4j.ThreadContext.put((String)"traceId", (String)traceId);
        if (t == null) {
            log.error(b.toString());
        } else {
            log.error(b.toString(), t);
            Throwable[] suppressed = t.getSuppressed();
            if (suppressed != null && suppressed.length != 0) {
                log.error("", suppressed[0]);
            }
        }
        if (filter != null) {
            if (t == null) {
                WebUtils.transmitFailFilterResult(exchange, filter);
            } else {
                WebUtils.transmitFailFilterResult(exchange, filter, t);
            }
        }
        HttpStatus s = HttpStatus.OK;
        if (SystemConfig.FIZZ_ERR_RESP_HTTP_STATUS_ENABLE) {
            s = HttpStatus.resolve((int)code);
        }
        if (bindContext) {
            return WebUtils.buildJsonDirectResponseAndBindContext(exchange, s, null, WebUtils.jsonRespBody(code, msg, traceId));
        }
        return WebUtils.buildJsonDirectResponse(exchange, s, null, WebUtils.jsonRespBody(code, msg, traceId));
    }

    public static Mono<Void> responseError(ServerWebExchange exchange, int code, String msg) {
        return WebUtils.responseError(exchange, null, code, msg, null, false);
    }

    public static Mono<Void> responseError(ServerWebExchange exchange, String reporter, int code, String msg, Throwable t) {
        return WebUtils.responseError(exchange, reporter, code, msg, t, false);
    }

    public static String getOriginIp(ServerWebExchange exchange) {
        String ip = (String)exchange.getAttribute(originIp);
        if (ip == null) {
            ServerHttpRequest req = exchange.getRequest();
            String v = req.getHeaders().getFirst(xForwardedFor);
            if (StringUtils.isBlank((CharSequence)v)) {
                ip = req.getRemoteAddress().getAddress().getHostAddress();
            } else {
                ip = StringUtils.split((String)v, (char)',')[0].trim();
                if (ip.equalsIgnoreCase(unknown)) {
                    ip = req.getRemoteAddress().getAddress().getHostAddress();
                } else if (ip.equals(binaryAddress)) {
                    ip = loopBack;
                }
            }
            exchange.getAttributes().put(originIp, ip);
        }
        return ip;
    }

    public static String getTraceId(ServerWebExchange exchange) {
        String id = (String)exchange.getAttribute(TRACE_ID);
        if (id == null) {
            id = exchange.getRequest().getId();
        }
        return id;
    }

    public static void traceDebug(Logger log, Function<Boolean, String> messageFactory) {
        if (log.isDebugEnabled()) {
            boolean traceEnabled = log.isTraceEnabled();
            String logMessage = messageFactory.apply(traceEnabled);
            if (traceEnabled) {
                log.trace(logMessage);
            } else {
                log.debug(logMessage);
            }
        }
    }

    public static String jsonRespBody(int code, @Nullable String msg) {
        return WebUtils.jsonRespBody(code, msg, null, null);
    }

    public static String jsonRespBody(int code, @Nullable String msg, @Nullable String traceId) {
        return WebUtils.jsonRespBody(code, msg, traceId, null);
    }

    public static String jsonRespBody(int code, @Nullable String msg, @Nullable String traceId, @Nullable Object context) {
        StringBuilder b = ThreadContext.getStringBuilder((String)"$sb0");
        b.append(s0).append(SystemConfig.FIZZ_ERR_RESP_CODE_FIELD).append(s1).append(code);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            b.append(s2).append(SystemConfig.FIZZ_ERR_RESP_MSG_FIELD).append(s3).append(msg).append(s4);
        }
        if (traceId != null) {
            b.append(s5).append(traceId).append(s4);
        }
        if (context != null) {
            b.append(s6).append(context).append(s4);
        }
        b.append(s7);
        return b.toString();
    }

    public static String toQueryString(MultiValueMap<String, String> queryParams) {
        StringBuilder b = ThreadContext.getStringBuilder((String)"$sb0");
        Set params = queryParams.entrySet();
        int ps = params.size();
        int cnt = 0;
        try {
            for (Map.Entry param : params) {
                String name = (String)param.getKey();
                List values = (List)param.getValue();
                if (values.isEmpty()) {
                    b.append(name);
                } else {
                    int vs = values.size();
                    int i = 0;
                    while (i < vs) {
                        b.append(name);
                        String v = (String)values.get(i);
                        if (v != null) {
                            b.append('=');
                            if (!"".equals(v)) {
                                b.append(URLDecoder.decode(v, "UTF-8"));
                            }
                        }
                        if (++i == vs) continue;
                        b.append('&');
                    }
                }
                if (++cnt == ps) continue;
                b.append('&');
            }
            return b.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Map<String, List<String>> toQueryStringTemplate(MultiValueMap<String, String> queryParams) {
        StringBuilder b = ThreadContext.getStringBuilder((String)"$sb0");
        Set params = queryParams.entrySet();
        int ps = params.size();
        int cnt = 0;
        ArrayList<String> paramValues = new ArrayList<String>();
        for (Map.Entry param : params) {
            String name = (String)param.getKey();
            List values = (List)param.getValue();
            if (values.isEmpty()) {
                b.append(name);
            } else {
                int vs = values.size();
                int i = 0;
                while (i < vs) {
                    b.append(name);
                    String v = (String)values.get(i);
                    if (v != null) {
                        b.append('=');
                        if (!"".equals(v)) {
                            paramValues.add(v);
                            b.append('{').append(paramValues.size()).append('}');
                        }
                    }
                    if (++i == vs) continue;
                    b.append('&');
                }
            }
            if (++cnt == ps) continue;
            b.append('&');
        }
        return Collections.singletonMap(b.toString(), paramValues);
    }

    @Deprecated
    public static Mono<Void> getDirectResponse(ServerWebExchange exchange) {
        return (Mono)exchange.getAttribute(directResponse);
    }

    @Deprecated
    public static Map<String, FilterResult> getFilterContext(ServerWebExchange exchange) {
        return (Map)exchange.getAttribute(FILTER_CONTEXT);
    }

    @Deprecated
    public static FilterResult getFilterResult(ServerWebExchange exchange, String filter) {
        return WebUtils.getFilterContext(exchange).get(filter);
    }

    @Deprecated
    public static Map<String, Object> getFilterResultData(ServerWebExchange exchange, String filter) {
        return WebUtils.getFilterResult((ServerWebExchange)exchange, (String)filter).data;
    }

    @Deprecated
    public static Object getFilterResultDataItem(ServerWebExchange exchange, String filter, String key) {
        return WebUtils.getFilterResultData(exchange, filter).get(key);
    }

    @Deprecated
    public static Mono<Void> buildDirectResponse(ServerWebExchange exchange, HttpStatus status, HttpHeaders headers, String body) {
        return WebUtils.buildDirectResponse(exchange.getResponse(), status, headers, body);
    }

    @Deprecated
    public static Mono<Void> buildDirectResponse(ServerHttpResponse clientResp, HttpStatus status, HttpHeaders headers, String body) {
        if (clientResp.isCommitted()) {
            String msg = "try to response: " + body + ", but server http response is committed and it's status: " + clientResp.getStatusCode();
            log.warn(msg);
            return Mono.error((Throwable)Utils.runtimeExceptionWithoutStack((String)msg));
        }
        if (status != null) {
            clientResp.setStatusCode(status);
        }
        if (headers != null) {
            headers.forEach((h, vs) -> clientResp.getHeaders().addAll(h, vs));
        }
        if (body == null) {
            body = "";
        }
        return clientResp.writeWith((Publisher)Mono.just((Object)clientResp.bufferFactory().wrap(body.getBytes())));
    }

    @Deprecated
    public static Mono buildJsonDirectResponse(ServerWebExchange exchange, HttpStatus status, HttpHeaders headers, String json) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.setContentType(MediaType.APPLICATION_JSON);
        return WebUtils.buildDirectResponse(exchange, status, headers, json);
    }

    @Deprecated
    public static Mono buildDirectResponseAndBindContext(ServerWebExchange exchange, HttpStatus status, HttpHeaders headers, String bodyContent) {
        Mono<Void> mv = WebUtils.buildDirectResponse(exchange, status, headers, bodyContent);
        exchange.getAttributes().put(directResponse, mv);
        return mv;
    }

    @Deprecated
    public static Mono buildJsonDirectResponseAndBindContext(ServerWebExchange exchange, HttpStatus status, HttpHeaders headers, String json) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.add("Content-Type", "application/json");
        return WebUtils.buildDirectResponseAndBindContext(exchange, status, headers, json);
    }

    @Deprecated
    public static void transmitSuccessFilterResult(ServerWebExchange exchange, String filter, Map<String, Object> data) {
        FilterResult fr = FilterResult.SUCCESS_WITH(filter, data);
        WebUtils.bind(exchange, filter, fr);
    }

    @Deprecated
    public static Mono transmitSuccessFilterResultAndEmptyMono(ServerWebExchange exchange, String filter, Map<String, Object> data) {
        WebUtils.transmitSuccessFilterResult(exchange, filter, data);
        return Mono.empty();
    }

    @Deprecated
    public static void transmitFailFilterResult(ServerWebExchange exchange, String filter) {
        FilterResult fr = FilterResult.FAIL(filter);
        WebUtils.bind(exchange, filter, fr);
    }

    @Deprecated
    public static void transmitFailFilterResult(ServerWebExchange exchange, String filter, Throwable cause) {
        FilterResult fr = FilterResult.FAIL_WITH(filter, cause);
        WebUtils.bind(exchange, filter, fr);
    }

    @Deprecated
    public static FilterResult getPrevFilterResult(ServerWebExchange exchange) {
        return WebUtils.getFilterContext(exchange).get(PREV_FILTER_RESULT);
    }

    @Deprecated
    public static Mono<Void> responseErrorAndBindContext(ServerWebExchange exchange, String filter, int code, String msg) {
        return WebUtils.responseError(exchange, filter, code, msg, null, true);
    }

    @Deprecated
    public static Mono<Void> responseErrorAndBindContext(ServerWebExchange exchange, String filter, int code, String msg, Throwable t) {
        return WebUtils.responseError(exchange, filter, code, msg, t, true);
    }

    @Deprecated
    public static Mono<Void> responseErrorAndBindContext(ServerWebExchange exchange, String filter, HttpStatus httpStatus) {
        ServerHttpResponse response = exchange.getResponse();
        String traceId = WebUtils.getTraceId(exchange);
        StringBuilder b = ThreadContext.getStringBuilder();
        WebUtils.request2stringBuilder(exchange, b);
        b.append(Consts.S.LINE_SEPARATOR);
        b.append(filter).append(' ').append(httpStatus);
        org.apache.logging.log4j.ThreadContext.put((String)"traceId", (String)traceId);
        log.error(b.toString());
        WebUtils.transmitFailFilterResult(exchange, filter);
        return WebUtils.buildDirectResponseAndBindContext(exchange, httpStatus, new HttpHeaders(), "");
    }

    @Deprecated
    public static Mono<Void> responseErrorAndBindContext(ServerWebExchange exchange, String filter, HttpStatus httpStatus, HttpHeaders headers, String content) {
        ServerHttpResponse response = exchange.getResponse();
        String traceId = WebUtils.getTraceId(exchange);
        StringBuilder b = ThreadContext.getStringBuilder();
        WebUtils.request2stringBuilder(exchange, b);
        b.append(Consts.S.LINE_SEPARATOR);
        b.append(filter).append(' ').append(httpStatus);
        org.apache.logging.log4j.ThreadContext.put((String)"traceId", (String)traceId);
        log.error(b.toString());
        WebUtils.transmitFailFilterResult(exchange, filter);
        headers = headers == null ? new HttpHeaders() : headers;
        content = StringUtils.isBlank((CharSequence)content) ? "" : content;
        return WebUtils.buildDirectResponseAndBindContext(exchange, httpStatus, headers, content);
    }

    public static void setXForwardedFor(ServerWebExchange exchange, HttpHeaders headers) {
        List values = headers.get((Object)xForwardedFor);
        if (CollectionUtils.isEmpty((Collection)values)) {
            String originIp = WebUtils.getOriginIp(exchange);
            headers.add(xForwardedFor, originIp);
        }
    }
}

