/*
 * Decompiled with CFR 0.152.
 */
package we.plugin.basicAuth;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import we.plugin.FizzPluginFilter;
import we.plugin.FizzPluginFilterChain;
import we.plugin.basicAuth.GlobalConfig;
import we.util.JacksonUtils;
import we.util.ReactorUtils;
import we.util.WebUtils;

@Component(value="basicAuthPlugin")
public class BasicAuthPluginFilter
implements FizzPluginFilter {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthPluginFilter.class);
    public static final String BASIC_AUTH_PLUGIN_FILTER = "basicAuthPlugin";
    public static final String BASIC_AUTH_KEY = "_basicAuth";
    public static final String BASIC_AUTH_VALUE = "Y";
    private GlobalConfig globalConfig = null;
    private String customConfigCache = null;

    public Mono<Void> filter(ServerWebExchange exchange, Map<String, Object> config) {
        try {
            HttpHeaders reqHeaders;
            String authorization;
            String customConfig = (String)config.get("fcK");
            if (this.globalConfig == null || this.customConfigCache == null || this.customConfigCache != null && !this.customConfigCache.equals(customConfig)) {
                this.globalConfig = StringUtils.isNotBlank((CharSequence)customConfig) ? (GlobalConfig)JacksonUtils.readValue((String)customConfig, GlobalConfig.class) : null;
                this.customConfigCache = customConfig;
            }
            HashMap<String, String> routeUsers = new HashMap<String, String>();
            String routeLevelConfig = (String)config.get("users");
            if (StringUtils.isNotBlank((CharSequence)routeLevelConfig)) {
                Map tmp = (Map)JacksonUtils.readValue((String)routeLevelConfig, Map.class);
                routeUsers.putAll(tmp);
            }
            if (this.checkAuth(authorization = (reqHeaders = exchange.getRequest().getHeaders()).getFirst("Authorization"), this.globalConfig, routeUsers)) {
                Mono next = FizzPluginFilterChain.next((ServerWebExchange)exchange);
                return next.defaultIfEmpty(ReactorUtils.NULL).flatMap(nil -> {
                    this.doAfter();
                    return Mono.empty();
                });
            }
            ServerHttpResponse response = exchange.getResponse();
            response.setStatusCode(HttpStatus.UNAUTHORIZED);
            response.getHeaders().setCacheControl("no-store");
            response.getHeaders().setExpires(0L);
            response.getHeaders().add("WWW-authenticate", "Basic Realm=\"input username and password\"");
            return WebUtils.response((ServerWebExchange)exchange, (HttpStatus)HttpStatus.UNAUTHORIZED, null, null);
        }
        catch (Exception e) {
            log.error("Basic Auth plugin Exception", (Throwable)e);
            return WebUtils.response((ServerWebExchange)exchange, (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, null, null);
        }
    }

    public void doAfter() {
    }

    public boolean checkAuth(String authorization, GlobalConfig globalConfig, Map<String, String> routeUsers) {
        if (authorization != null && authorization.length() > 6) {
            authorization = authorization.substring(6, authorization.length());
            try {
                String decodedAuth = new String(Base64.getDecoder().decode(authorization));
                if (decodedAuth != null && decodedAuth.indexOf(":") != -1) {
                    int idx = decodedAuth.indexOf(":");
                    String username = decodedAuth.substring(0, idx);
                    String password = decodedAuth.substring(idx + 1, decodedAuth.length());
                    if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
                        if (routeUsers != null && routeUsers.containsKey(username)) {
                            return password.equals(routeUsers.get(username));
                        }
                        if (globalConfig != null && globalConfig.getUsers() != null) {
                            return password.equals(globalConfig.getUsers().get(username));
                        }
                    }
                }
            }
            catch (Exception e) {
                log.warn("invalid basic authorization", (Throwable)e);
            }
        }
        return false;
    }
}

