/*
 * Decompiled with CFR 0.152.
 */
package we.plugin.dedicatedline.auth;

import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import we.dedicated_line.DedicatedLineService;
import we.flume.clients.log4j2appender.LogService;
import we.plugin.FizzPluginFilter;
import we.plugin.FizzPluginFilterChain;
import we.util.ReactorUtils;
import we.util.WebUtils;

@ConditionalOnBean(value={DedicatedLineService.class})
@Component(value="dedicatedLineApiAuthPlugin")
public class DedicatedLineApiAuthPluginFilter
implements FizzPluginFilter {
    private static final Logger log = LoggerFactory.getLogger(DedicatedLineApiAuthPluginFilter.class);
    @Resource
    private DedicatedLineService dedicatedLineService;
    public static final String DEDICATED_LINE_API_AUTH_PLUGIN_FILTER = "dedicatedLineApiAuthPlugin";

    public Mono<Void> filter(ServerWebExchange exchange, Map<String, Object> config) {
        String traceId = WebUtils.getTraceId((ServerWebExchange)exchange);
        try {
            String dedicatedLineId = WebUtils.getDedicatedLineId((ServerWebExchange)exchange);
            String service = WebUtils.getClientService((ServerWebExchange)exchange);
            String path = WebUtils.getClientReqPath((ServerWebExchange)exchange);
            HttpMethod method = exchange.getRequest().getMethod();
            if (this.dedicatedLineService.auth(dedicatedLineId, method, service, path)) {
                Mono next = FizzPluginFilterChain.next((ServerWebExchange)exchange);
                return next.defaultIfEmpty(ReactorUtils.NULL).flatMap(nil -> {
                    this.doAfter();
                    return Mono.empty();
                });
            }
            ServerHttpResponse response = exchange.getResponse();
            response.setStatusCode(HttpStatus.UNAUTHORIZED);
            response.getHeaders().setCacheControl("no-store");
            response.getHeaders().setExpires(0L);
            String respJson = WebUtils.jsonRespBody((int)HttpStatus.UNAUTHORIZED.value(), (String)HttpStatus.UNAUTHORIZED.getReasonPhrase(), (String)traceId);
            return WebUtils.response((ServerWebExchange)exchange, (HttpStatus)HttpStatus.UNAUTHORIZED, null, (String)respJson);
        }
        catch (Exception e) {
            log.error("{} {} exception", new Object[]{traceId, DEDICATED_LINE_API_AUTH_PLUGIN_FILTER, LogService.BIZ_ID, traceId, e});
            String respJson = WebUtils.jsonRespBody((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase(), (String)traceId);
            return WebUtils.response((ServerWebExchange)exchange, (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, null, (String)respJson);
        }
    }

    public void doAfter() {
    }
}

