/*
 * Decompiled with CFR 0.152.
 */
package we.plugin.dedicatedline.codec;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import we.config.SystemConfig;
import we.dedicated_line.DedicatedLineService;
import we.flume.clients.log4j2appender.LogService;
import we.plugin.FizzPluginFilterChain;
import we.plugin.requestbody.RequestBodyPlugin;
import we.spring.http.server.reactive.ext.FizzServerHttpRequestDecorator;
import we.spring.http.server.reactive.ext.FizzServerHttpResponseDecorator;
import we.util.NettyDataBufferUtils;
import we.util.WebUtils;

@ConditionalOnBean(value={DedicatedLineService.class})
@Component(value="dedicatedLineCodecPlugin")
public class DedicatedLineCodecPluginFilter
extends RequestBodyPlugin {
    private static final Logger log = LoggerFactory.getLogger(DedicatedLineCodecPluginFilter.class);
    public static final String DEDICATED_LINE_CODEC_PLUGIN_FILTER = "dedicatedLineCodecPlugin";
    @Resource
    private SystemConfig systemConfig;
    @Resource
    private DedicatedLineService dedicatedLineService;

    public Mono<Void> doFilter(ServerWebExchange exchange, Map<String, Object> config) {
        String traceId = WebUtils.getTraceId((ServerWebExchange)exchange);
        try {
            LogService.setBizId((Object)traceId);
            String dedicatedLineId = WebUtils.getDedicatedLineId((ServerWebExchange)exchange);
            final String cryptoKey = this.dedicatedLineService.getRequestCryptoKey(dedicatedLineId);
            FizzServerHttpRequestDecorator request = (FizzServerHttpRequestDecorator)exchange.getRequest();
            return request.getBody().defaultIfEmpty((Object)NettyDataBufferUtils.EMPTY_DATA_BUFFER).single().flatMap(body -> {
                if (body != NettyDataBufferUtils.EMPTY_DATA_BUFFER && this.systemConfig.fizzDedicatedLineClientRequestCrypto()) {
                    byte[] bodyBytes = request.getBodyBytes();
                    request.setBody(this.decrypt(bodyBytes, cryptoKey));
                    request.getHeaders().remove((Object)"Content-Length");
                }
                ServerHttpResponse original = exchange.getResponse();
                FizzServerHttpResponseDecorator fizzServerHttpResponseDecorator = new FizzServerHttpResponseDecorator(original){

                    public Publisher<? extends DataBuffer> writeWith(DataBuffer remoteResponseBody) {
                        if (remoteResponseBody == NettyDataBufferUtils.EMPTY_DATA_BUFFER) {
                            return Mono.empty();
                        }
                        if (StringUtils.isNotBlank((CharSequence)cryptoKey)) {
                            this.getDelegate().getHeaders().remove((Object)"Content-Length");
                            byte[] bytes = remoteResponseBody.asByteBuffer().array();
                            NettyDataBuffer from = NettyDataBufferUtils.from((byte[])DedicatedLineCodecPluginFilter.this.encrypt(bytes, cryptoKey));
                            return Mono.just((Object)from);
                        }
                        return Mono.just((Object)remoteResponseBody);
                    }
                };
                ServerWebExchange build = exchange.mutate().response((ServerHttpResponse)fizzServerHttpResponseDecorator).build();
                return FizzPluginFilterChain.next((ServerWebExchange)build);
            });
        }
        catch (Exception e) {
            log.error("{} {} Exception", new Object[]{traceId, DEDICATED_LINE_CODEC_PLUGIN_FILTER, LogService.BIZ_ID, traceId, e});
            String respJson = WebUtils.jsonRespBody((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase(), (String)traceId);
            return WebUtils.response((ServerWebExchange)exchange, (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, null, (String)respJson);
        }
    }

    public byte[] encrypt(byte[] data, String secretKey) {
        byte[] key = SecureUtil.decode((String)secretKey);
        SymmetricCrypto symmetric = new SymmetricCrypto(SymmetricAlgorithm.AES, key);
        return symmetric.encrypt(data);
    }

    public byte[] decrypt(byte[] data, String secretKey) {
        byte[] key = SecureUtil.decode((String)secretKey);
        SymmetricCrypto symmetric = new SymmetricCrypto(SymmetricAlgorithm.AES, key);
        return symmetric.decrypt(data);
    }
}

