/*
 * Decompiled with CFR 0.152.
 */
package we.plugin.dedicatedline.pairing;

import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import we.config.SystemConfig;
import we.dedicated_line.DedicatedLineService;
import we.flume.clients.log4j2appender.LogService;
import we.plugin.FizzPluginFilter;
import we.plugin.FizzPluginFilterChain;
import we.util.DigestUtils;
import we.util.ReactorUtils;
import we.util.WebUtils;

@ConditionalOnBean(value={DedicatedLineService.class})
@Component(value="dedicatedLinePairingPlugin")
public class DedicatedLinePairingPluginFilter
implements FizzPluginFilter {
    private static final Logger log = LoggerFactory.getLogger(DedicatedLinePairingPluginFilter.class);
    public static final String DEDICATED_LINE_PAIRING_PLUGIN_FILTER = "dedicatedLinePairingPlugin";
    @Resource
    private SystemConfig systemConfig;
    @Resource
    private DedicatedLineService dedicatedLineService;

    public Mono<Void> filter(ServerWebExchange exchange, Map<String, Object> config) {
        String traceId = WebUtils.getTraceId((ServerWebExchange)exchange);
        try {
            LogService.setBizId((Object)traceId);
            String dedicatedLineId = WebUtils.getDedicatedLineId((ServerWebExchange)exchange);
            String secretKey = this.dedicatedLineService.getSignSecretKey(dedicatedLineId);
            String ts = WebUtils.getDedicatedLineTimestamp((ServerWebExchange)exchange);
            String sign = WebUtils.getDedicatedLineSign((ServerWebExchange)exchange);
            if (this.validateSign(dedicatedLineId, ts, sign, secretKey)) {
                Mono next = FizzPluginFilterChain.next((ServerWebExchange)exchange);
                return next.defaultIfEmpty(ReactorUtils.NULL).flatMap(nil -> {
                    this.doAfter();
                    return Mono.empty();
                });
            }
            ServerHttpResponse response = exchange.getResponse();
            response.setStatusCode(HttpStatus.UNAUTHORIZED);
            response.getHeaders().setCacheControl("no-store");
            response.getHeaders().setExpires(0L);
            String respJson = WebUtils.jsonRespBody((int)HttpStatus.UNAUTHORIZED.value(), (String)HttpStatus.UNAUTHORIZED.getReasonPhrase(), (String)traceId);
            return WebUtils.response((ServerWebExchange)exchange, (HttpStatus)HttpStatus.UNAUTHORIZED, null, (String)respJson);
        }
        catch (Exception e) {
            log.error("{} {} Exception", new Object[]{traceId, DEDICATED_LINE_PAIRING_PLUGIN_FILTER, LogService.BIZ_ID, traceId, e});
            String respJson = WebUtils.jsonRespBody((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase(), (String)traceId);
            return WebUtils.response((ServerWebExchange)exchange, (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, null, (String)respJson);
        }
    }

    private boolean validateSign(String dedicatedLineId, String ts, String sign, String secretkey) {
        if (StringUtils.isBlank((CharSequence)dedicatedLineId) || StringUtils.isBlank((CharSequence)ts) || StringUtils.isBlank((CharSequence)sign) || StringUtils.isBlank((CharSequence)secretkey)) {
            return false;
        }
        String data = dedicatedLineId + "_" + ts + "_" + secretkey;
        if (!DigestUtils.sha256Hex((String)data).equals(sign)) {
            return false;
        }
        long t = 0L;
        try {
            t = Long.valueOf(ts);
        }
        catch (Exception e) {
            log.warn("invalid timestamp: {}", (Object)ts);
            return false;
        }
        long now = System.currentTimeMillis();
        long offset = 300000L;
        if (t < now - offset || t > now + offset) {
            log.warn("timestamp expired: {}", (Object)ts);
            return false;
        }
        return true;
    }

    public void doAfter() {
    }
}

