/*
 * Decompiled with CFR 0.152.
 */
package we.plugin.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import we.plugin.PluginFilter;
import we.plugin.jwt.GlobalConfig;
import we.util.JacksonUtils;
import we.util.PemUtils;
import we.util.WebUtils;

@Component(value="jwtAuthPlugin")
public class JwtAuthPluginFilter
extends PluginFilter {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthPluginFilter.class);
    public static final String JWT_AUTH_PLUGIN_FILTER = "jwtAuthPlugin";
    public static final String RSA = "RSA";
    public static final String EC = "EC";
    public static final String KEY = "key";
    public static final String PASS_HEADER = "passHeader";
    public static final String EXTRACT_CLAIMS = "extractClaims";
    public static final String STATUS_CODE = "statusCode";
    public static final String CONTENT_TYPE = "contentType";
    public static final String RESP_BODY = "respBody";
    public static final String JWT_CLAIMS = "jwt.claims";
    private GlobalConfig globalConfig = null;
    private String fixedConfigCache = null;

    public Mono<Void> doFilter(ServerWebExchange exchange, Map<String, Object> config, String fixedConfig) {
        try {
            if (this.globalConfig == null || this.fixedConfigCache == null || this.fixedConfigCache != null && !this.fixedConfigCache.equals(fixedConfig)) {
                this.globalConfig = StringUtils.isNotBlank((CharSequence)fixedConfig) ? (GlobalConfig)JacksonUtils.readValue((String)fixedConfig, GlobalConfig.class) : null;
                this.fixedConfigCache = fixedConfig;
            }
            String secretKey = (String)config.get(KEY);
            String publicKey = (String)config.get(KEY);
            secretKey = StringUtils.isBlank((CharSequence)secretKey) ? this.globalConfig.getSecretKey() : secretKey;
            publicKey = StringUtils.isBlank((CharSequence)publicKey) ? this.globalConfig.getPublicKey() : publicKey;
            Boolean passHeader = null;
            List passHeaderList = (List)config.get(PASS_HEADER);
            if (passHeaderList != null && passHeaderList.size() > 0) {
                passHeader = (Boolean)passHeaderList.get(0);
            }
            Boolean extractClaims = null;
            List extractClaimsList = (List)config.get(EXTRACT_CLAIMS);
            if (extractClaimsList != null && extractClaimsList.size() > 0) {
                extractClaims = (Boolean)extractClaimsList.get(0);
            }
            Integer statusCode = (Integer)config.get(STATUS_CODE);
            String contentType = (String)config.get(CONTENT_TYPE);
            String respBody = (String)config.get(RESP_BODY);
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", contentType);
            HttpHeaders reqHeaders = exchange.getRequest().getHeaders();
            String token = reqHeaders.getFirst("Authorization");
            if (!StringUtils.isNotBlank((CharSequence)token) || token.length() <= 7 || !token.substring(0, 7).equalsIgnoreCase("Bearer ")) {
                if (StringUtils.isBlank((CharSequence)token)) {
                    log.warn("JWT Auth plugin - Token is missing");
                    return WebUtils.responseErrorAndBindContext((ServerWebExchange)exchange, (String)JWT_AUTH_PLUGIN_FILTER, (HttpStatus)HttpStatus.valueOf((int)statusCode), (HttpHeaders)headers, (String)respBody);
                }
                log.warn("JWT Auth plugin - invalid token");
                return WebUtils.responseErrorAndBindContext((ServerWebExchange)exchange, (String)JWT_AUTH_PLUGIN_FILTER, (HttpStatus)HttpStatus.valueOf((int)statusCode), (HttpHeaders)headers, (String)respBody);
            }
            token = token.substring(7);
            DecodedJWT jwt = this.verify(token, secretKey, publicKey);
            if (jwt == null) {
                return WebUtils.responseErrorAndBindContext((ServerWebExchange)exchange, (String)JWT_AUTH_PLUGIN_FILTER, (HttpStatus)HttpStatus.valueOf((int)statusCode), (HttpHeaders)headers, (String)respBody);
            }
            if (passHeader != null && !passHeader.booleanValue()) {
                reqHeaders.remove((Object)"Authorization");
            }
            if (extractClaims != null && extractClaims.booleanValue()) {
                exchange.getAttributes().put(JWT_CLAIMS, jwt.getClaims());
            }
            return WebUtils.transmitSuccessFilterResultAndEmptyMono((ServerWebExchange)exchange, (String)JWT_AUTH_PLUGIN_FILTER, null);
        }
        catch (Exception e) {
            log.error("JWT Auth plugin Exception", (Throwable)e);
            return WebUtils.responseErrorAndBindContext((ServerWebExchange)exchange, (String)JWT_AUTH_PLUGIN_FILTER, (HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public DecodedJWT verify(String token, String secretKey, String publicKey) {
        block29: {
            try {
                DecodedJWT jwt = JWT.decode((String)token);
                String alg = jwt.getAlgorithm();
                Algorithm algorithm = null;
                switch (alg) {
                    case "HS256": {
                        algorithm = Algorithm.HMAC256((String)secretKey);
                        break;
                    }
                    case "HS384": {
                        algorithm = Algorithm.HMAC384((String)secretKey);
                        break;
                    }
                    case "HS512": {
                        algorithm = Algorithm.HMAC512((String)secretKey);
                        break;
                    }
                    case "RS256": {
                        algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)PemUtils.readPublicKeyFromString((String)publicKey, (String)RSA)), null);
                        break;
                    }
                    case "RS384": {
                        algorithm = Algorithm.RSA384((RSAPublicKey)((RSAPublicKey)PemUtils.readPublicKeyFromString((String)publicKey, (String)RSA)), null);
                        break;
                    }
                    case "RS512": {
                        algorithm = Algorithm.RSA512((RSAPublicKey)((RSAPublicKey)PemUtils.readPublicKeyFromString((String)publicKey, (String)RSA)), null);
                        break;
                    }
                    case "ES256": {
                        algorithm = Algorithm.ECDSA256((ECPublicKey)((ECPublicKey)PemUtils.readPublicKeyFromString((String)publicKey, (String)EC)), null);
                        break;
                    }
                    case "ES256K": {
                        algorithm = Algorithm.ECDSA256K((ECPublicKey)((ECPublicKey)PemUtils.readPublicKeyFromString((String)publicKey, (String)EC)), null);
                        break;
                    }
                    case "ES384": {
                        algorithm = Algorithm.ECDSA384((ECPublicKey)((ECPublicKey)PemUtils.readPublicKeyFromString((String)publicKey, (String)EC)), null);
                        break;
                    }
                    case "ES512": {
                        algorithm = Algorithm.ECDSA512((ECPublicKey)((ECPublicKey)PemUtils.readPublicKeyFromString((String)publicKey, (String)EC)), null);
                    }
                }
                if (algorithm == null) {
                    log.warn("{} Algorithm NOT Supported", (Object)alg);
                    break block29;
                }
                JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
                try {
                    return verifier.verify(token);
                }
                catch (JWTVerificationException e) {
                    log.warn("JWT verification failed: {}", (Object)e.getMessage());
                }
            }
            catch (Exception e) {
                log.warn("JWT verification exception", (Throwable)e);
            }
        }
        return null;
    }
}

