/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine;

import com.flagsmith.flagengine.environments.EnvironmentModel;
import com.flagsmith.flagengine.features.FeatureModel;
import com.flagsmith.flagengine.features.FeatureStateModel;
import com.flagsmith.flagengine.identities.IdentityModel;
import com.flagsmith.flagengine.identities.traits.TraitModel;
import com.flagsmith.flagengine.segments.SegmentEvaluator;
import com.flagsmith.flagengine.segments.SegmentModel;
import com.flagsmith.flagengine.utils.exceptions.FeatureStateNotFound;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Engine {
    public static List<FeatureStateModel> getEnvironmentFeatureStates(EnvironmentModel environment) {
        if (environment.getProject().getHideDisabledFlags().booleanValue()) {
            return environment.getFeatureStates().stream().filter(featureState -> featureState.getEnabled()).collect(Collectors.toList());
        }
        return environment.getFeatureStates();
    }

    public static FeatureStateModel getEnvironmentFeatureState(EnvironmentModel environment, String featureName) throws FeatureStateNotFound {
        return environment.getFeatureStates().stream().filter(featureState -> featureState.getFeature().getName().equals(featureName)).findFirst().orElseThrow(() -> new FeatureStateNotFound());
    }

    public static List<FeatureStateModel> getIdentityFeatureStates(EnvironmentModel environmentModel, IdentityModel identityModel) {
        return Engine.getIdentityFeatureStates(environmentModel, identityModel, null);
    }

    public static List<FeatureStateModel> getIdentityFeatureStates(EnvironmentModel environmentModel, IdentityModel identityModel, List<TraitModel> overrideTraits) {
        List<FeatureStateModel> featureStates = Engine.getIdentityFeatureMap(environmentModel, identityModel, overrideTraits).values().stream().collect(Collectors.toList());
        if (environmentModel.getProject().getHideDisabledFlags().booleanValue()) {
            return featureStates.stream().filter(featureState -> featureState.getEnabled()).collect(Collectors.toList());
        }
        return featureStates;
    }

    public static FeatureStateModel getIdentityFeatureState(EnvironmentModel environmentModel, IdentityModel identityModel, String featureName, List<TraitModel> overrideTraits) throws FeatureStateNotFound {
        Map<FeatureModel, FeatureStateModel> featureStates = Engine.getIdentityFeatureMap(environmentModel, identityModel, overrideTraits);
        FeatureModel feature = featureStates.keySet().stream().filter(featureModel -> featureModel.getName().equals(featureName)).findFirst().orElseThrow(() -> new FeatureStateNotFound());
        return featureStates.get(feature);
    }

    private static Map<FeatureModel, FeatureStateModel> getIdentityFeatureMap(EnvironmentModel environmentModel, IdentityModel identityModel, List<TraitModel> overrideTraits) {
        HashMap<FeatureModel, FeatureStateModel> featureStates = new HashMap();
        if (environmentModel.getFeatureStates() != null) {
            featureStates = environmentModel.getFeatureStates().stream().collect(Collectors.toMap(FeatureStateModel::getFeature, featureState -> featureState));
        }
        List<SegmentModel> identitySegments = SegmentEvaluator.getIdentitySegments(environmentModel, identityModel, overrideTraits);
        for (SegmentModel segmentModel : identitySegments) {
            for (FeatureStateModel featureState2 : segmentModel.getFeatureStates()) {
                FeatureModel feature = featureState2.getFeature();
                FeatureStateModel existing = (FeatureStateModel)featureStates.get(feature);
                if (existing != null && existing.isHigherPriority(featureState2)) continue;
                featureStates.put(featureState2.getFeature(), featureState2);
            }
        }
        for (FeatureStateModel featureState3 : identityModel.getIdentityFeatures()) {
            if (!featureStates.containsKey(featureState3.getFeature())) continue;
            featureStates.put(featureState3.getFeature(), featureState3);
        }
        return featureStates;
    }
}

