/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.flagengine.segments;

import com.flagsmith.flagengine.environments.EnvironmentModel;
import com.flagsmith.flagengine.identities.IdentityModel;
import com.flagsmith.flagengine.identities.traits.TraitModel;
import com.flagsmith.flagengine.segments.SegmentConditionModel;
import com.flagsmith.flagengine.segments.SegmentModel;
import com.flagsmith.flagengine.segments.SegmentRuleModel;
import com.flagsmith.flagengine.segments.constants.SegmentConditions;
import com.flagsmith.flagengine.utils.Hashing;
import com.flagsmith.flagengine.utils.types.TypeCasting;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SegmentEvaluator {
    public static List<SegmentModel> getIdentitySegments(EnvironmentModel environment, IdentityModel identity) {
        return SegmentEvaluator.getIdentitySegments(environment, identity, null);
    }

    public static List<SegmentModel> getIdentitySegments(EnvironmentModel environment, IdentityModel identity, List<TraitModel> overrideTraits) {
        return environment.getProject().getSegments().stream().filter(segment -> SegmentEvaluator.evaluateIdentityInSegment(identity, segment, overrideTraits)).collect(Collectors.toList());
    }

    public static Boolean evaluateIdentityInSegment(IdentityModel identity, SegmentModel segment, List<TraitModel> overrideTraits) {
        List<TraitModel> traits;
        List<SegmentRuleModel> segmentRules = segment.getRules();
        List<TraitModel> list = traits = overrideTraits != null ? overrideTraits : identity.getIdentityTraits();
        if (segmentRules != null && segmentRules.size() > 0) {
            List segmentRuleEvaluations = segmentRules.stream().map(rule -> SegmentEvaluator.traitsMatchSegmentRule(traits, rule, segment.getId(), identity.getCompositeKey())).collect(Collectors.toList());
            return segmentRuleEvaluations.stream().allMatch(bool -> bool);
        }
        return Boolean.FALSE;
    }

    private static Boolean traitsMatchSegmentRule(List<TraitModel> identityTraits, SegmentRuleModel rule, Integer segmentId, String identityId) {
        List<SegmentRuleModel> rules;
        Boolean matchingCondition = Boolean.TRUE;
        if (rule.getConditions() != null && rule.getConditions().size() > 0) {
            List conditionEvaluations = rule.getConditions().stream().map(condition -> SegmentEvaluator.traitsMatchSegmentCondition(identityTraits, condition, segmentId, identityId)).collect(Collectors.toList());
            matchingCondition = rule.matchingFunction(conditionEvaluations.stream());
        }
        if ((rules = rule.getRules()) != null) {
            matchingCondition = matchingCondition != false && rules.stream().allMatch(segmentRule -> SegmentEvaluator.traitsMatchSegmentRule(identityTraits, segmentRule, segmentId, identityId));
        }
        return matchingCondition;
    }

    private static Boolean traitsMatchSegmentCondition(List<TraitModel> identityTraits, SegmentConditionModel condition, Integer segmentId, String identityId) {
        if (condition.getOperator().equals((Object)SegmentConditions.PERCENTAGE_SPLIT)) {
            try {
                Float floatValue = Float.valueOf(Float.parseFloat(condition.getValue()));
                return Hashing.getInstance().getHashedPercentageForObjectIds(Arrays.asList(segmentId.toString(), identityId)).floatValue() <= floatValue.floatValue();
            }
            catch (NumberFormatException nfe) {
                return Boolean.FALSE;
            }
        }
        if (identityTraits != null) {
            Optional<TraitModel> matchingTrait = identityTraits.stream().filter(trait -> trait.getTraitKey().equals(condition.getProperty_())).findFirst();
            return SegmentEvaluator.traitMatchesSegmentCondition(matchingTrait, condition);
        }
        return condition.getOperator().equals((Object)SegmentConditions.IS_NOT_SET);
    }

    private static Boolean traitMatchesSegmentCondition(Optional<TraitModel> trait, SegmentConditionModel condition) {
        if (condition.getOperator().equals((Object)SegmentConditions.IS_NOT_SET)) {
            return !trait.isPresent();
        }
        if (condition.getOperator().equals((Object)SegmentConditions.IS_SET)) {
            return trait.isPresent();
        }
        return trait.isPresent() && SegmentEvaluator.conditionMatchesTraitValue(condition, trait.get().getTraitValue()) != false;
    }

    public static Boolean conditionMatchesTraitValue(SegmentConditionModel condition, Object value) {
        SegmentConditions operator = condition.getOperator();
        if (operator.equals((Object)SegmentConditions.NOT_CONTAINS)) {
            return ((String)value).indexOf(condition.getValue()) == -1;
        }
        if (operator.equals((Object)SegmentConditions.CONTAINS)) {
            return ((String)value).indexOf(condition.getValue()) > -1;
        }
        if (operator.equals((Object)SegmentConditions.REGEX)) {
            Pattern pattern = Pattern.compile(condition.getValue());
            return pattern.matcher((String)value).find();
        }
        return TypeCasting.compare(operator, value, condition.getValue());
    }
}

