/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.internal;

import android.util.Log;
import com.flagsmith.entities.FlagEvent;
import com.flagsmith.internal.FlagsmithEventService;
import com.flagsmith.internal.FlagsmithRetrofitService;
import com.google.gson.Gson;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0011\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB4\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001a\u001a\u00020\tH\u0002R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lcom/flagsmith/internal/FlagsmithEventService;", "", "eventSourceBaseUrl", "", "environmentKey", "updates", "Lkotlin/Function1;", "Lkotlin/Result;", "Lcom/flagsmith/entities/FlagEvent;", "", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "completeEventSourceUrl", "currentEventSource", "Lokhttp3/sse/EventSource;", "sseClient", "Lokhttp3/OkHttpClient;", "sseEventSourceListener", "com/flagsmith/internal/FlagsmithEventService$sseEventSourceListener$1", "Lcom/flagsmith/internal/FlagsmithEventService$sseEventSourceListener$1;", "<set-?>", "Lkotlinx/coroutines/flow/MutableStateFlow;", "sseEventsFlow", "getSseEventsFlow", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "sseRequest", "Lokhttp3/Request;", "initEventSource", "Companion", "FlagsmithClient_release"})
public final class FlagsmithEventService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String eventSourceBaseUrl;
    @NotNull
    private final String environmentKey;
    @NotNull
    private final Function1<Result<FlagEvent>, Unit> updates;
    @NotNull
    private final OkHttpClient sseClient;
    @NotNull
    private final String completeEventSourceUrl;
    @NotNull
    private final Request sseRequest;
    @Nullable
    private EventSource currentEventSource;
    @NotNull
    private MutableStateFlow<FlagEvent> sseEventsFlow;
    @NotNull
    private final sseEventSourceListener.1 sseEventSourceListener;
    @NotNull
    private static final String TAG = "FlagsmithEventService";

    public FlagsmithEventService(@Nullable String eventSourceBaseUrl, @NotNull String environmentKey, @NotNull Function1<? super Result<FlagEvent>, Unit> updates) {
        Intrinsics.checkNotNullParameter((Object)environmentKey, (String)"environmentKey");
        Intrinsics.checkNotNullParameter(updates, (String)"updates");
        this.eventSourceBaseUrl = eventSourceBaseUrl;
        this.environmentKey = environmentKey;
        this.updates = updates;
        this.sseClient = new OkHttpClient.Builder().addInterceptor(FlagsmithRetrofitService.Companion.envKeyInterceptor(this.environmentKey)).connectTimeout(6L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.MINUTES).writeTimeout(10L, TimeUnit.MINUTES).build();
        this.completeEventSourceUrl = this.eventSourceBaseUrl + "sse/environments/" + this.environmentKey + "/stream";
        this.sseRequest = new Request.Builder().url(this.completeEventSourceUrl).header("Accept", "application/json").addHeader("Accept", "text/event-stream").build();
        this.sseEventsFlow = StateFlowKt.MutableStateFlow((Object)new FlagEvent(0.0));
        this.sseEventSourceListener = new EventSourceListener(this){
            final /* synthetic */ FlagsmithEventService this$0;
            {
                this.this$0 = $receiver;
            }

            public void onClosed(@NotNull EventSource eventSource) {
                Intrinsics.checkNotNullParameter((Object)eventSource, (String)"eventSource");
                super.onClosed(eventSource);
                Log.d((String)"FlagsmithEventService", (String)("onClosed: " + eventSource));
                FlagsmithEventService.access$initEventSource(this.this$0);
            }

            public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
                Intrinsics.checkNotNullParameter((Object)eventSource, (String)"eventSource");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                super.onEvent(eventSource, id, type, data);
                Log.d((String)"FlagsmithEventService", (String)("onEvent: " + data));
                if (type != null && Intrinsics.areEqual((Object)type, (Object)"environment_updated") && ((CharSequence)data).length() > 0) {
                    FlagEvent flagEvent = (FlagEvent)new Gson().fromJson(data, FlagEvent.class);
                    MutableStateFlow<FlagEvent> mutableStateFlow = this.this$0.getSseEventsFlow();
                    Intrinsics.checkNotNullExpressionValue((Object)flagEvent, (String)"flagEvent");
                    mutableStateFlow.tryEmit((Object)flagEvent);
                    FlagsmithEventService.access$getUpdates$p(this.this$0).invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)flagEvent)));
                }
            }

            public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                Intrinsics.checkNotNullParameter((Object)eventSource, (String)"eventSource");
                super.onFailure(eventSource, t, response);
                Throwable throwable = t;
                Log.d((String)"FlagsmithEventService", (String)("onFailure: " + (throwable != null ? throwable.getMessage() : null)));
                if (t != null) {
                    FlagsmithEventService.access$getUpdates$p(this.this$0).invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t))));
                } else {
                    FlagsmithEventService.access$getUpdates$p(this.this$0).invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Throwable("Unknown error")))));
                }
            }

            public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)eventSource, (String)"eventSource");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                super.onOpen(eventSource, response);
                Log.d((String)"FlagsmithEventService", (String)("onOpen: " + eventSource));
            }
        };
        this.initEventSource();
    }

    @NotNull
    public final MutableStateFlow<FlagEvent> getSseEventsFlow() {
        return this.sseEventsFlow;
    }

    private final void initEventSource() {
        EventSource eventSource = this.currentEventSource;
        if (eventSource != null) {
            eventSource.cancel();
        }
        this.currentEventSource = EventSources.createFactory((OkHttpClient)this.sseClient).newEventSource(this.sseRequest, (EventSourceListener)this.sseEventSourceListener);
    }

    public static final /* synthetic */ void access$initEventSource(FlagsmithEventService $this) {
        $this.initEventSource();
    }

    public static final /* synthetic */ Function1 access$getUpdates$p(FlagsmithEventService $this) {
        return $this.updates;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/flagsmith/internal/FlagsmithEventService$Companion;", "", "()V", "TAG", "", "FlagsmithClient_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

