/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith.internal;

import android.content.Context;
import android.util.Log;
import com.flagsmith.FlagsmithCacheConfig;
import com.flagsmith.entities.Flag;
import com.flagsmith.entities.IdentityAndTraits;
import com.flagsmith.entities.IdentityAndTraitsSerializer;
import com.flagsmith.entities.IdentityFlagsAndTraits;
import com.flagsmith.entities.Trait;
import com.flagsmith.entities.TraitSerializer;
import com.flagsmith.internal.FlagsmithEventTimeTracker;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014J\u0014\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003H'J)\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\u000bH'\u00a2\u0006\u0002\u0010\fJ&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\u0016\b\u0001\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H'J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\b\b\u0001\u0010\b\u001a\u00020\u0013H'\u00a8\u0006\u0015"}, d2={"Lcom/flagsmith/internal/FlagsmithRetrofitService;", "", "getFlags", "Lretrofit2/Call;", "", "Lcom/flagsmith/entities/Flag;", "getIdentityFlagsAndTraits", "Lcom/flagsmith/entities/IdentityFlagsAndTraits;", "identity", "", "transient", "", "(Ljava/lang/String;Ljava/lang/Boolean;)Lretrofit2/Call;", "postAnalytics", "", "eventMap", "", "", "postTraits", "Lcom/flagsmith/entities/IdentityAndTraits;", "Companion", "FlagsmithClient_release"})
public interface FlagsmithRetrofitService {
    @NotNull
    public static final Companion Companion = com.flagsmith.internal.FlagsmithRetrofitService$Companion.$$INSTANCE;

    @GET(value="identities/")
    @NotNull
    public Call<IdentityFlagsAndTraits> getIdentityFlagsAndTraits(@Query(value="identifier") @NotNull String var1, @Query(value="transient") @Nullable Boolean var2);

    @GET(value="flags/")
    @NotNull
    public Call<List<Flag>> getFlags();

    @POST(value="identities/")
    @NotNull
    public Call<IdentityFlagsAndTraits> postTraits(@Body @NotNull IdentityAndTraits var1);

    @POST(value="analytics/flags/")
    @NotNull
    public Call<Unit> postAnalytics(@Body @NotNull Map<String, Integer> var1);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jn\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\"\b\b\u0000\u0010\u000b*\u00020\t2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/flagsmith/internal/FlagsmithRetrofitService$Companion;", "", "()V", "ACCEPT_HEADER_VALUE", "", "CONTENT_TYPE_HEADER_VALUE", "UPDATED_AT_HEADER", "create", "Lkotlin/Pair;", "Lcom/flagsmith/internal/FlagsmithRetrofitService;", "Lokhttp3/Cache;", "T", "baseUrl", "environmentKey", "context", "Landroid/content/Context;", "cacheConfig", "Lcom/flagsmith/FlagsmithCacheConfig;", "requestTimeoutSeconds", "", "readTimeoutSeconds", "writeTimeoutSeconds", "timeTracker", "Lcom/flagsmith/internal/FlagsmithEventTimeTracker;", "klass", "Ljava/lang/Class;", "envKeyInterceptor", "Lokhttp3/Interceptor;", "FlagsmithClient_release"})
    @SourceDebugExtension(value={"SMAP\nFlagsmithRetrofitService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlagsmithRetrofitService.kt\ncom/flagsmith/internal/FlagsmithRetrofitService$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String UPDATED_AT_HEADER = "x-flagsmith-document-updated-at";
        @NotNull
        private static final String ACCEPT_HEADER_VALUE = "application/json";
        @NotNull
        private static final String CONTENT_TYPE_HEADER_VALUE = "application/json; charset=utf-8";

        private Companion() {
        }

        @NotNull
        public final <T extends FlagsmithRetrofitService> Pair<FlagsmithRetrofitService, Cache> create(@NotNull String baseUrl, @NotNull String environmentKey, @Nullable Context context, @NotNull FlagsmithCacheConfig cacheConfig, long requestTimeoutSeconds, long readTimeoutSeconds, long writeTimeoutSeconds, @NotNull FlagsmithEventTimeTracker timeTracker, @NotNull Class<T> klass) {
            Cache cache;
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkNotNullParameter((Object)environmentKey, (String)"environmentKey");
            Intrinsics.checkNotNullParameter((Object)cacheConfig, (String)"cacheConfig");
            Intrinsics.checkNotNullParameter((Object)timeTracker, (String)"timeTracker");
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            if (context != null && cacheConfig.getEnableCache()) {
                File file = context.getCacheDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.cacheDir");
                cache = new Cache(file, cacheConfig.getCacheSize());
            } else {
                cache = null;
            }
            Cache cache2 = cache;
            OkHttpClient.Builder it = new OkHttpClient.Builder().addInterceptor(this.envKeyInterceptor(environmentKey)).addInterceptor(com.flagsmith.internal.FlagsmithRetrofitService$Companion.create$updatedAtInterceptor(timeTracker)).addInterceptor(com.flagsmith.internal.FlagsmithRetrofitService$Companion.create$jsonContentTypeInterceptor());
            boolean bl = false;
            OkHttpClient client = (cacheConfig.getEnableCache() ? it.addNetworkInterceptor(com.flagsmith.internal.FlagsmithRetrofitService$Companion.create$cacheControlInterceptor(cacheConfig)) : it).callTimeout(requestTimeoutSeconds, TimeUnit.SECONDS).readTimeout(readTimeoutSeconds, TimeUnit.SECONDS).writeTimeout(writeTimeoutSeconds, TimeUnit.SECONDS).cache(cache2).build();
            Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)IdentityAndTraits.class), (Object)new IdentityAndTraitsSerializer()).registerTypeAdapter((Type)((Object)Trait.class), (Object)new TraitSerializer()).create();
            Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).client(client).build();
            return new Pair(retrofit.create(klass), (Object)cache2);
        }

        @NotNull
        public final Interceptor envKeyInterceptor(@NotNull String environmentKey) {
            Intrinsics.checkNotNullParameter((Object)environmentKey, (String)"environmentKey");
            return arg_0 -> Companion.envKeyInterceptor$lambda$4(environmentKey, arg_0);
        }

        private static final Response create$cacheControlInterceptor$lambda$0(FlagsmithCacheConfig $cacheConfig, Interceptor.Chain chain) {
            Intrinsics.checkNotNullParameter((Object)$cacheConfig, (String)"$cacheConfig");
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Response response = chain.proceed(chain.request());
            return response.newBuilder().header("Cache-Control", "public, max-age=" + $cacheConfig.getCacheTTLSeconds()).removeHeader("Pragma").build();
        }

        private static final Interceptor create$cacheControlInterceptor(FlagsmithCacheConfig $cacheConfig) {
            return arg_0 -> Companion.create$cacheControlInterceptor$lambda$0($cacheConfig, arg_0);
        }

        private static final Response create$jsonContentTypeInterceptor$lambda$1(Interceptor.Chain chain) {
            Response response;
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Request request = chain.request();
            if (Intrinsics.areEqual((Object)chain.request().method(), (Object)"POST") || Intrinsics.areEqual((Object)chain.request().method(), (Object)"PUT") || Intrinsics.areEqual((Object)chain.request().method(), (Object)"PATCH")) {
                Request newRequest = request.newBuilder().header("Content-Type", CONTENT_TYPE_HEADER_VALUE).header("Accept", ACCEPT_HEADER_VALUE).build();
                response = chain.proceed(newRequest);
            } else {
                response = chain.proceed(request);
            }
            return response;
        }

        private static final Interceptor create$jsonContentTypeInterceptor() {
            return Companion::create$jsonContentTypeInterceptor$lambda$1;
        }

        private static final Response create$updatedAtInterceptor$lambda$2(FlagsmithEventTimeTracker $tracker, Interceptor.Chain chain) {
            Intrinsics.checkNotNullParameter((Object)$tracker, (String)"$tracker");
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Response response = chain.proceed(chain.request());
            String updatedAtString = Response.header$default((Response)response, (String)UPDATED_AT_HEADER, null, (int)2, null);
            Log.i((String)"Flagsmith", (String)("updatedAt: " + updatedAtString));
            Object object = updatedAtString;
            $tracker.setLastFlagFetchTime(object != null && (object = StringsKt.toDoubleOrNull((String)object)) != null ? ((Double)object).doubleValue() : $tracker.getLastFlagFetchTime());
            return response;
        }

        private static final Interceptor create$updatedAtInterceptor(FlagsmithEventTimeTracker tracker) {
            return arg_0 -> Companion.create$updatedAtInterceptor$lambda$2(tracker, arg_0);
        }

        private static final Response envKeyInterceptor$lambda$4(String $environmentKey, Interceptor.Chain chain) {
            Intrinsics.checkNotNullParameter((Object)$environmentKey, (String)"$environmentKey");
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Request request = chain.request().newBuilder().addHeader("X-environment-key", $environmentKey).build();
            return chain.proceed(request);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ Call getIdentityFlagsAndTraits$default(FlagsmithRetrofitService flagsmithRetrofitService, String string, Boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getIdentityFlagsAndTraits");
            }
            if ((n & 2) != 0) {
                bl = null;
            }
            return flagsmithRetrofitService.getIdentityFlagsAndTraits(string, bl);
        }
    }
}

