/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.CharacterEncoding;
import com.flagstone.transform.MovieHeader;
import com.flagstone.transform.MovieTag;
import com.flagstone.transform.ShowFrame;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.Copyable;
import com.flagstone.transform.coder.DecoderRegistry;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public final class Movie
implements Copyable<Movie> {
    public static final int VERSION = 10;
    private static final int SIGNATURE_LENGTH = 3;
    private static final int HEADER_LENGTH = 8;
    public static final byte[] FWS = new byte[]{70, 87, 83};
    public static final byte[] CWS = new byte[]{67, 87, 83};
    private static final String FORMAT = "Movie: { objects=%s}";
    private transient DecoderRegistry registry;
    private transient CharacterEncoding encoding;
    private List<MovieTag> objects;

    public Movie() {
        this.registry = DecoderRegistry.getDefault();
        this.encoding = CharacterEncoding.UTF8;
        this.objects = new ArrayList<MovieTag>();
    }

    public Movie(Movie movie) {
        if (movie.registry != null) {
            this.registry = movie.registry.copy();
        }
        this.encoding = movie.encoding;
        this.objects = new ArrayList<MovieTag>(movie.objects.size());
        for (MovieTag tag : movie.objects) {
            this.objects.add((MovieTag)tag.copy());
        }
    }

    public void setRegistry(DecoderRegistry decoderRegistry) {
        this.registry = decoderRegistry;
    }

    public void setEncoding(CharacterEncoding enc) {
        this.encoding = enc;
    }

    public List<MovieTag> getObjects() {
        return this.objects;
    }

    public void setObjects(List<MovieTag> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.objects = list;
    }

    public Movie add(MovieTag anObject) {
        if (anObject == null) {
            throw new IllegalArgumentException();
        }
        this.objects.add(anObject);
        return this;
    }

    @Override
    public Movie copy() {
        return new Movie(this);
    }

    public String toString() {
        return String.format(FORMAT, this.objects);
    }

    public void decodeFromFile(File file) throws DataFormatException, IOException {
        this.decodeFromStream(new FileInputStream(file));
    }

    public void decodeFromUrl(URL url) throws DataFormatException, IOException {
        URLConnection connection = url.openConnection();
        if (connection.getContentLength() < 0) {
            throw new FileNotFoundException(url.getFile());
        }
        this.decodeFromStream(connection.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decodeFromStream(InputStream stream) throws DataFormatException, IOException {
        InputStream streamIn = null;
        try {
            Context context = new Context();
            context.setRegistry(this.registry);
            context.setEncoding(this.encoding.getEncoding());
            byte[] signature = new byte[3];
            if (stream.read(signature) != signature.length) {
                throw new DataFormatException("Could not read file signature");
            }
            if (Arrays.equals(CWS, signature)) {
                streamIn = new InflaterInputStream(stream);
                context.put(17, 1);
            } else if (Arrays.equals(FWS, signature)) {
                streamIn = stream;
                context.put(17, 0);
            } else {
                throw new DataFormatException();
            }
            context.put(1, stream.read());
            int length = stream.read();
            length |= stream.read() << 8;
            length |= stream.read() << 16;
            SWFDecoder decoder = (length |= stream.read() << 24) < 4096 ? new SWFDecoder(streamIn, length - 8) : new SWFDecoder(streamIn);
            decoder.setEncoding(this.encoding);
            this.objects.clear();
            SWFFactory<MovieTag> factory = this.registry.getMovieDecoder();
            MovieHeader header = new MovieHeader(decoder, context);
            this.objects.add(header);
            while (decoder.scanUnsignedShort() >>> 6 != 0) {
                factory.getObject(this.objects, decoder, context);
            }
            decoder.readUnsignedShort();
            header.setVersion(context.get(1));
            header.setCompressed(context.get(17) == 1);
        }
        finally {
            if (streamIn != null) {
                streamIn.close();
            }
        }
    }

    public void encodeToFile(File file) throws IOException, DataFormatException {
        this.encodeToStream(new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeToStream(OutputStream stream) throws DataFormatException, IOException {
        OutputStream streamOut = null;
        try {
            MovieHeader header = (MovieHeader)this.objects.get(0);
            Context context = new Context();
            context.setEncoding(this.encoding.getEncoding());
            context.put(1, header.getVersion());
            int length = 10;
            int frameCount = 0;
            for (MovieTag tag : this.objects) {
                length += tag.prepareToEncode(context);
                if (!(tag instanceof ShowFrame)) continue;
                ++frameCount;
            }
            header.setFrameCount(frameCount);
            if (header.isCompressed()) {
                stream.write(CWS);
            } else {
                stream.write(FWS);
            }
            stream.write(header.getVersion());
            stream.write(length);
            stream.write(length >>> 8);
            stream.write(length >>> 16);
            stream.write(length >>> 24);
            streamOut = header.isCompressed() ? new DeflaterOutputStream(stream) : stream;
            SWFEncoder coder = new SWFEncoder(streamOut);
            coder.setEncoding(this.encoding);
            for (MovieTag tag : this.objects) {
                tag.encode(coder, context);
            }
            coder.writeShort(0);
            coder.flush();
        }
        finally {
            if (streamOut != null) {
                streamOut.close();
            }
        }
    }
}

