/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class MovieHeader
implements MovieTag {
    private static final String FORMAT = "Header: { version=%d; compressed=%b; frameSize=%s; frameRate=%f; frameCount=%d}";
    private int version;
    private Bounds frameSize;
    private int frameRate;
    private int frameCount;
    private boolean compressed;

    public MovieHeader(SWFDecoder coder, Context context) throws IOException {
        this.version = context.get(1);
        this.compressed = context.get(17) == 1;
        this.frameSize = new Bounds(coder);
        this.frameRate = coder.readUnsignedShort();
        this.frameCount = coder.readUnsignedShort();
    }

    public MovieHeader() {
        this.version = 10;
        this.compressed = true;
    }

    public MovieHeader(MovieHeader object) {
        this.version = object.version;
        this.compressed = object.compressed;
        this.frameSize = object.frameSize;
        this.frameRate = object.frameRate;
        this.frameCount = object.frameCount;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int aNumber) {
        if (aNumber < 0) {
            throw new IllegalArgumentRangeException(0, Integer.MAX_VALUE, aNumber);
        }
        this.version = aNumber;
    }

    public Bounds getFrameSize() {
        return this.frameSize;
    }

    public void setFrameSize(Bounds rect) {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        this.frameSize = rect;
    }

    public float getFrameRate() {
        return (float)this.frameRate / 256.0f;
    }

    public void setFrameRate(float rate) {
        this.frameRate = (int)(rate * 256.0f);
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void setFrameCount(int count) {
        this.frameCount = count;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compress) {
        this.compressed = compress;
    }

    @Override
    public MovieHeader copy() {
        return new MovieHeader(this);
    }

    public String toString() {
        return String.format(FORMAT, this.version, this.compressed, this.frameSize, Float.valueOf(this.getFrameRate()), this.frameCount);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 4 + this.frameSize.prepareToEncode(context);
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        this.frameSize.encode(coder, context);
        coder.writeShort(this.frameRate);
        coder.writeShort(this.frameCount);
    }
}

