/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.EventHandler;
import com.flagstone.transform.MovieTag;
import com.flagstone.transform.PlaceType;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.ColorTransform;
import com.flagstone.transform.datatype.CoordTransform;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Place2
implements MovieTag {
    private static final int STANDARD_EVENTS = 5;
    private static final String FORMAT = "Place2: { type=%s; layer=%d; identifier=%d; transform=%s; colorTransform=%s; ratio=%d; clippingDepth=%d; name=%s; clipEvents=%s}";
    private PlaceType type;
    private int layer;
    private int identifier;
    private CoordTransform transform;
    private ColorTransform colorTransform;
    private Integer ratio;
    private Integer depth;
    private String name;
    private List<EventHandler> events;
    private transient int length;

    public static Place2 show(int identifier, int layer, int xCoord, int yCoord) {
        Place2 object = new Place2();
        object.setType(PlaceType.NEW);
        object.setLayer(layer);
        object.setIdentifier(identifier);
        object.setTransform(CoordTransform.translate(xCoord, yCoord));
        return object;
    }

    public static Place2 move(int layer, int xCoord, int yCoord) {
        Place2 object = new Place2();
        object.setType(PlaceType.MODIFY);
        object.setLayer(layer);
        object.setTransform(CoordTransform.translate(xCoord, yCoord));
        return object;
    }

    public static Place2 replace(int identifier, int layer) {
        Place2 object = new Place2();
        object.setType(PlaceType.REPLACE);
        object.setLayer(layer);
        object.setIdentifier(identifier);
        return object;
    }

    public static Place2 replace(int identifier, int layer, int xCoord, int yCoord) {
        Place2 object = new Place2();
        object.setType(PlaceType.REPLACE);
        object.setLayer(layer);
        object.setIdentifier(identifier);
        object.setTransform(CoordTransform.translate(xCoord, yCoord));
        return object;
    }

    public Place2(SWFDecoder coder, Context context) throws IOException {
        context.put(3, 1);
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        int bits = coder.readByte();
        boolean hasEvents = (bits & 0x80) != 0;
        boolean hasDepth = (bits & 0x40) != 0;
        boolean hasName = (bits & 0x20) != 0;
        boolean hasRatio = (bits & 0x10) != 0;
        boolean hasColorTransform = (bits & 8) != 0;
        boolean hasTransform = (bits & 4) != 0;
        switch (bits & 3) {
            case 0: {
                this.type = PlaceType.MODIFY;
                break;
            }
            case 1: {
                this.type = PlaceType.MODIFY;
                break;
            }
            case 2: {
                this.type = PlaceType.NEW;
                break;
            }
            default: {
                this.type = PlaceType.REPLACE;
            }
        }
        this.layer = coder.readUnsignedShort();
        this.events = new ArrayList<EventHandler>();
        if (this.type == PlaceType.NEW || this.type == PlaceType.REPLACE) {
            this.identifier = coder.readUnsignedShort();
        }
        if (hasTransform) {
            this.transform = new CoordTransform(coder);
        }
        if (hasColorTransform) {
            this.colorTransform = new ColorTransform(coder, context);
        }
        if (hasRatio) {
            this.ratio = coder.readUnsignedShort();
        }
        if (hasName) {
            this.name = coder.readString();
        }
        if (hasDepth) {
            this.depth = coder.readUnsignedShort();
        }
        if (hasEvents) {
            coder.readUnsignedShort();
            if (context.get(1) > 5) {
                int event;
                coder.readInt();
                while ((event = coder.readInt()) != 0) {
                    this.events.add(new EventHandler(event, coder, context));
                }
            } else {
                int event;
                coder.readUnsignedShort();
                while ((event = coder.readUnsignedShort()) != 0) {
                    this.events.add(new EventHandler(event, coder, context));
                }
            }
        }
        context.remove(3);
        coder.check(this.length);
        coder.unmark();
    }

    public Place2() {
        this.events = new ArrayList<EventHandler>();
    }

    public Place2(Place2 object) {
        this.type = object.type;
        this.layer = object.layer;
        this.identifier = object.identifier;
        if (object.transform != null) {
            this.transform = object.transform;
        }
        if (object.colorTransform != null) {
            this.colorTransform = object.colorTransform;
        }
        this.ratio = object.ratio;
        this.depth = object.depth;
        this.name = object.name;
        this.events = new ArrayList<EventHandler>(object.events.size());
        for (EventHandler event : object.events) {
            this.events.add(event.copy());
        }
    }

    public Place2 add(EventHandler aClipEvent) {
        if (aClipEvent == null) {
            throw new IllegalArgumentException();
        }
        this.events.add(aClipEvent);
        return this;
    }

    public List<EventHandler> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventHandler> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.events = list;
    }

    public PlaceType getType() {
        return this.type;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public CoordTransform getTransform() {
        return this.transform;
    }

    public ColorTransform getColorTransform() {
        return this.colorTransform;
    }

    public Integer getRatio() {
        return this.ratio;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public String getName() {
        return this.name;
    }

    public Place2 setType(PlaceType aType) {
        this.type = aType;
        return this;
    }

    public Place2 setLayer(int aLayer) {
        if (aLayer < 1 || aLayer > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, aLayer);
        }
        this.layer = aLayer;
        return this;
    }

    public Place2 setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
        return this;
    }

    public Place2 setTransform(CoordTransform matrix) {
        this.transform = matrix;
        return this;
    }

    public Place2 setLocation(int xCoord, int yCoord) {
        this.transform = CoordTransform.translate(xCoord, yCoord);
        return this;
    }

    public Place2 setColorTransform(ColorTransform cxform) {
        this.colorTransform = cxform;
        return this;
    }

    public Place2 setRatio(Integer aNumber) {
        if (aNumber != null && (aNumber < 0 || aNumber > 65535)) {
            throw new IllegalArgumentRangeException(1, 65535, aNumber);
        }
        this.ratio = aNumber;
        return this;
    }

    public Place2 setDepth(Integer aNumber) {
        if (aNumber != null && (aNumber < 1 || aNumber > 65535)) {
            throw new IllegalArgumentRangeException(1, 65535, aNumber);
        }
        this.depth = aNumber;
        return this;
    }

    public Place2 setName(String aString) {
        this.name = aString;
        return this;
    }

    @Override
    public Place2 copy() {
        return new Place2(this);
    }

    public String toString() {
        return String.format(FORMAT, new Object[]{this.type, this.layer, this.identifier, this.transform, this.colorTransform, this.ratio, this.depth, this.name, this.events});
    }

    @Override
    public int prepareToEncode(Context context) {
        context.put(3, 1);
        this.length = 3;
        this.length += this.type.equals((Object)PlaceType.NEW) || this.type.equals((Object)PlaceType.REPLACE) ? 2 : 0;
        if (this.transform != null) {
            this.length += this.transform.prepareToEncode(context);
        }
        if (this.colorTransform != null) {
            this.length += this.colorTransform.prepareToEncode(context);
        }
        this.length += this.ratio == null ? 0 : 2;
        this.length += this.depth == null ? 0 : 2;
        this.length += this.name == null ? 0 : context.strlen(this.name);
        if (!this.events.isEmpty()) {
            int eventSize = context.get(1) > 5 ? 4 : 2;
            this.length += 2 + eventSize;
            for (EventHandler handler : this.events) {
                this.length += handler.prepareToEncode(context);
            }
            this.length += eventSize;
        }
        context.remove(3);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(1727);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x680 | this.length);
        }
        coder.mark();
        context.put(3, 1);
        int bits = 0;
        bits |= this.events.isEmpty() ? 0 : 128;
        bits |= this.depth == null ? 0 : 64;
        bits |= this.name == null ? 0 : 32;
        bits |= this.ratio == null ? 0 : 16;
        bits |= this.colorTransform == null ? 0 : 8;
        bits |= this.transform == null ? 0 : 4;
        switch (this.type) {
            case MODIFY: {
                bits |= 1;
                break;
            }
            case NEW: {
                bits |= 2;
                break;
            }
            default: {
                bits |= 1;
                bits |= 2;
            }
        }
        coder.writeByte(bits);
        coder.writeShort(this.layer);
        if (this.type == PlaceType.NEW || this.type == PlaceType.REPLACE) {
            coder.writeShort(this.identifier);
        }
        if (this.transform != null) {
            this.transform.encode(coder, context);
        }
        if (this.colorTransform != null) {
            this.colorTransform.encode(coder, context);
        }
        if (this.ratio != null) {
            coder.writeShort(this.ratio);
        }
        if (this.name != null) {
            coder.writeString(this.name);
        }
        if (this.depth != null) {
            coder.writeShort(this.depth);
        }
        if (!this.events.isEmpty()) {
            int eventMask = 0;
            for (EventHandler handler : this.events) {
                eventMask |= handler.getEventCode();
            }
            coder.writeShort(0);
            if (context.get(1) > 5) {
                coder.writeInt(eventMask);
                for (EventHandler handler : this.events) {
                    handler.encode(coder, context);
                }
                coder.writeInt(0);
            } else {
                coder.writeShort(eventMask);
                for (EventHandler handler : this.events) {
                    handler.encode(coder, context);
                }
                coder.writeShort(0);
            }
        }
        context.remove(3);
        coder.check(this.length);
        coder.unmark();
    }
}

