/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;

public final class SerialNumber
implements MovieTag {
    private static final String FORMAT = "SerialNumber: { number=%s}";
    private String number;
    private transient int length;

    public SerialNumber(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.number = coder.readString(this.length - 1);
        coder.readByte();
        coder.check(this.length);
        coder.unmark();
    }

    public SerialNumber(String aString) {
        this.setNumber(aString);
    }

    public SerialNumber(SerialNumber object) {
        this.number = object.number;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String aString) {
        if (aString == null) {
            throw new IllegalArgumentException();
        }
        this.number = aString;
    }

    @Override
    public SerialNumber copy() {
        return new SerialNumber(this);
    }

    public String toString() {
        return String.format(FORMAT, this.number);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = context.strlen(this.number);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(2687);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0xA40 | this.length);
        }
        coder.writeString(this.number);
    }
}

