/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;

public final class GetUrl
implements Action {
    private static final String FORMAT = "GetUrl: { url=%s; target=%s}";
    private final transient String url;
    private final transient String target;
    private transient int length;

    public GetUrl(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort();
        this.url = coder.readString();
        this.target = coder.readString();
    }

    public GetUrl(String urlString, String targetString) {
        if (urlString == null) {
            throw new IllegalArgumentException();
        }
        this.url = urlString;
        if (targetString == null) {
            throw new IllegalArgumentException();
        }
        this.target = targetString;
    }

    public GetUrl(String urlString) {
        this(urlString, "");
    }

    public GetUrl(GetUrl object) {
        this.url = object.url;
        this.target = object.target;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTarget() {
        return this.target;
    }

    @Override
    public GetUrl copy() {
        return this;
    }

    public String toString() {
        return String.format(FORMAT, this.url, this.target);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = context.strlen(this.url);
        this.length += context.strlen(this.target);
        return 3 + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(131);
        coder.writeShort(this.length);
        coder.writeString(this.url);
        coder.writeString(this.target);
    }
}

