/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class GotoFrame2
implements Action {
    private static final String FORMAT = "Gotoframe2: { playFrame=%s; frameOffset=%d}";
    private static final int MAX_FRAME_OFFSET = 65535;
    private static final int OFFSET_MASK = 2;
    private static final int PLAY_MASK = 1;
    private static final int LEN_WITH_OFFSET = 3;
    private static final int LEN_NO_OFFSET = 1;
    private final transient boolean play;
    private final transient int frameOffset;
    private transient int length;
    private transient boolean hasOffset;

    public GotoFrame2(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort();
        int bits = coder.readByte();
        this.hasOffset = (bits & 2) != 0;
        this.play = (bits & 1) != 0;
        this.frameOffset = this.hasOffset ? coder.readSignedShort() : 0;
    }

    public GotoFrame2(boolean aBool) {
        this(0, aBool);
    }

    public GotoFrame2(int offset, boolean aBool) {
        if (offset < 0 || offset > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, offset);
        }
        this.frameOffset = offset;
        this.play = aBool;
    }

    public GotoFrame2(GotoFrame2 object) {
        this.play = object.play;
        this.frameOffset = object.frameOffset;
    }

    public int getFrameOffset() {
        return this.frameOffset;
    }

    public boolean isPlay() {
        return this.play;
    }

    @Override
    public GotoFrame2 copy() {
        return this;
    }

    public String toString() {
        return String.format(FORMAT, String.valueOf(this.play), this.frameOffset);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.hasOffset = this.frameOffset > 0;
        this.length = this.hasOffset ? 3 : 1;
        return 3 + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(159);
        coder.writeShort(this.length);
        int flags = 0;
        if (this.hasOffset) {
            flags |= 2;
        }
        if (this.play) {
            flags |= 1;
        }
        coder.writeByte(flags);
        if (this.hasOffset) {
            coder.writeShort(this.frameOffset);
        }
    }
}

