/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class RegisterCopy
implements Action {
    private static final String FORMAT = "RegisterCopy: { number=%d}";
    private static final int LAST_REGISTER = 255;
    private final transient int number;

    public RegisterCopy(SWFDecoder coder) throws IOException {
        coder.readUnsignedShort();
        this.number = coder.readByte();
    }

    public RegisterCopy(int register) {
        if (register < 0 || register > 255) {
            throw new IllegalArgumentRangeException(0, 255, register);
        }
        this.number = register;
    }

    public RegisterCopy(RegisterCopy object) {
        this.number = object.number;
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    public RegisterCopy copy() {
        return this;
    }

    public String toString() {
        return String.format(FORMAT, this.number);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 4;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(135);
        coder.writeShort(1);
        coder.writeByte(this.number);
    }
}

