/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.button;

import com.flagstone.transform.DefineTag;
import com.flagstone.transform.EventHandler;
import com.flagstone.transform.button.ButtonShape;
import com.flagstone.transform.button.ButtonType;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DefineButton2
implements DefineTag {
    private static final String FORMAT = "DefineButton2: { type=%s; identifier=%d; buttonRecords=%s; handlers=%s}";
    private int identifier;
    private int type;
    private List<ButtonShape> shapes;
    private List<EventHandler> events;
    private transient int length;
    private transient int offset;

    public DefineButton2(SWFDecoder coder, Context context) throws IOException {
        context.put(2, 34);
        context.put(3, 1);
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.type = coder.readByte();
        this.shapes = new ArrayList<ButtonShape>();
        int offsetToNext = coder.readUnsignedShort();
        while (coder.scanByte() != 0) {
            this.shapes.add(new ButtonShape(coder, context));
        }
        coder.readByte();
        this.events = new ArrayList<EventHandler>();
        if (offsetToNext != 0) {
            if (this.type == 1) {
                context.put(18, 1);
            }
            do {
                int size = (offsetToNext = coder.readUnsignedShort()) == 0 ? this.length - coder.bytesRead() - 2 : offsetToNext - 4;
                this.events.add(new EventHandler(size, coder, context));
            } while (offsetToNext != 0);
            context.remove(18);
        }
        context.remove(2);
        context.remove(3);
        coder.check(this.length);
        coder.unmark();
    }

    public DefineButton2(int uid, ButtonType buttonType, List<ButtonShape> buttonShapes, List<EventHandler> handlers) {
        this.setIdentifier(uid);
        this.setType(buttonType);
        this.setShapes(buttonShapes);
        this.setEvents(handlers);
    }

    public DefineButton2(DefineButton2 object) {
        this.identifier = object.identifier;
        this.type = object.type;
        this.shapes = new ArrayList<ButtonShape>(object.shapes.size());
        for (ButtonShape shape : object.shapes) {
            this.shapes.add(shape.copy());
        }
        this.events = new ArrayList<EventHandler>(object.events.size());
        for (EventHandler event : object.events) {
            this.events.add(event.copy());
        }
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public DefineButton2 add(ButtonShape obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        this.shapes.add(obj);
        return this;
    }

    public DefineButton2 add(EventHandler obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        this.events.add(obj);
        return this;
    }

    public ButtonType getType() {
        ButtonType value = this.type == 0 ? ButtonType.PUSH : ButtonType.MENU;
        return value;
    }

    public List<ButtonShape> getShapes() {
        return this.shapes;
    }

    public List<EventHandler> getEvents() {
        return this.events;
    }

    public void setType(ButtonType buttonType) {
        this.type = buttonType == ButtonType.PUSH ? 0 : 1;
    }

    public void setShapes(List<ButtonShape> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.shapes = list;
    }

    public void setEvents(List<EventHandler> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.events = list;
    }

    @Override
    public DefineButton2 copy() {
        return new DefineButton2(this);
    }

    public String toString() {
        return String.format(FORMAT, new Object[]{this.getType(), this.identifier, this.shapes, this.events});
    }

    @Override
    public int prepareToEncode(Context context) {
        context.put(2, 34);
        context.put(3, 1);
        this.length = 6;
        for (ButtonShape shape : this.shapes) {
            this.length += shape.prepareToEncode(context);
        }
        this.offset = this.events.isEmpty() ? 0 : this.length - 3;
        int count = this.events.size();
        if (this.type == 1) {
            context.put(18, 1);
        }
        for (int i = 0; i < count; ++i) {
            EventHandler handler = this.events.get(i);
            if (i == count - 1) {
                context.put(16, 1);
            }
            this.length += handler.prepareToEncode(context);
        }
        context.remove(2);
        context.remove(3);
        context.remove(16);
        context.remove(18);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        context.put(2, 34);
        context.put(3, 1);
        if (this.length > 62) {
            coder.writeShort(2239);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x880 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        coder.writeByte(this.type);
        coder.writeShort(this.offset);
        for (ButtonShape shape : this.shapes) {
            shape.encode(coder, context);
        }
        coder.writeByte(0);
        if (this.type == 1) {
            context.put(18, 1);
        }
        for (EventHandler handler : this.events) {
            handler.encode(coder, context);
        }
        context.remove(2);
        context.remove(3);
        context.remove(18);
        coder.check(this.length);
        coder.unmark();
    }
}

