/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.filter;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.filter.Filter;
import java.io.IOException;

public final class BlurFilter
implements Filter {
    private static final int MAX_BLUR_COUNT = 31;
    private static final String FORMAT = "BlurFilter: { blurX=%f; blurY=%f; passes=%d}";
    private final transient int blurX;
    private final transient int blurY;
    private final transient int passes;

    public BlurFilter(SWFDecoder coder) throws IOException {
        this.blurX = coder.readInt();
        this.blurY = coder.readInt();
        this.passes = coder.readByte() >>> 3;
    }

    public BlurFilter(float xBlur, float yBlur, int count) {
        this.blurX = (int)(xBlur * 65536.0f);
        this.blurY = (int)(yBlur * 65536.0f);
        if (count < 0 || count > 31) {
            throw new IllegalArgumentRangeException(0, 31, count);
        }
        this.passes = count;
    }

    public float getBlurX() {
        return (float)this.blurX / 65536.0f;
    }

    public float getBlurY() {
        return (float)this.blurY / 65536.0f;
    }

    public int getPasses() {
        return this.passes;
    }

    public String toString() {
        return String.format(FORMAT, Float.valueOf(this.getBlurX()), Float.valueOf(this.getBlurY()), this.passes);
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null) {
            result = false;
        } else if (object == this) {
            result = true;
        } else if (object instanceof BlurFilter) {
            BlurFilter filter = (BlurFilter)object;
            result = this.blurX == filter.blurX && this.blurY == filter.blurY && this.passes == filter.passes;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return (this.blurX * 31 + this.blurY) * 31 + this.passes;
    }

    @Override
    public int prepareToEncode(Context context) {
        return 10;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(1);
        coder.writeInt(this.blurX);
        coder.writeInt(this.blurY);
        coder.writeByte(this.passes << 3);
    }
}

